/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.reset.GitResetMode;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitNewResetDialog
extends DialogWrapper {
    private static final String DIALOG_ID = "git.new.reset.dialog";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<GitRepository, VcsFullCommitDetails> myCommits;
    @NotNull
    private final GitResetMode myDefaultMode;
    @NotNull
    private final ButtonGroup myButtonGroup;
    private RadioButtonEnumModel<GitResetMode> myEnumModel;

    protected GitNewResetDialog(@NotNull Project project, @NotNull Map<GitRepository, VcsFullCommitDetails> commits2, @NotNull GitResetMode defaultMode) {
        super(project);
        this.myProject = project;
        this.myCommits = commits2;
        this.myDefaultMode = defaultMode;
        this.myButtonGroup = new ButtonGroup();
        this.init();
        this.setTitle(GitBundle.message("git.reset.dialog.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("git.reset.button", new Object[0]));
        this.setResizable(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultAnchor(21).setDefaultInsets(0, 10, 12, 0);
        String description = GitNewResetDialog.prepareDescription(this.myProject, this.myCommits);
        panel2.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)description)), gb.nextLine().next().coverLine());
        JBLabel descriptionLabel = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("git.reset.dialog.description", new Object[0])), UIUtil.ComponentStyle.SMALL);
        panel2.add((Component)descriptionLabel, gb.nextLine().next().coverLine());
        for (GitResetMode mode : GitResetMode.values()) {
            JBRadioButton button2 = new JBRadioButton(mode.getName());
            button2.setMnemonic(mode.getName().charAt(0));
            this.myButtonGroup.add((AbstractButton)button2);
            panel2.add((Component)button2, gb.nextLine().next());
            panel2.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)mode.getDescription()), UIUtil.ComponentStyle.SMALL), gb.next());
        }
        this.myEnumModel = RadioButtonEnumModel.bindEnum(GitResetMode.class, (ButtonGroup)this.myButtonGroup);
        this.myEnumModel.setSelected((Enum)this.myDefaultMode);
        return panel2;
    }

    @Nullable
    protected String getHelpId() {
        return DIALOG_ID;
    }

    @NotNull
    private static String prepareDescription(@NotNull Project project, @NotNull Map<GitRepository, VcsFullCommitDetails> commits2) {
        if (commits2.size() == 1 && !GitNewResetDialog.isMultiRepo(project)) {
            Map.Entry<GitRepository, VcsFullCommitDetails> entry = commits2.entrySet().iterator().next();
            return String.format("%s -> %s", GitNewResetDialog.getSourceText(entry.getKey()), GitNewResetDialog.getTargetText(entry.getValue()));
        }
        StringBuilder desc = new StringBuilder();
        for (Map.Entry<GitRepository, VcsFullCommitDetails> entry : commits2.entrySet()) {
            GitRepository repository = entry.getKey();
            VcsFullCommitDetails commit2 = entry.getValue();
            String sourceInRepo = GitBundle.message("git.reset.dialog.description.source.in.repository", GitNewResetDialog.getSourceText(repository), DvcsUtil.getShortRepositoryName((Repository)repository));
            desc.append(String.format("%s -> %s<br/>", sourceInRepo, GitNewResetDialog.getTargetText(commit2)));
        }
        return desc.toString();
    }

    @NotNull
    @Nls
    private static String getTargetText(@NotNull VcsFullCommitDetails commit2) {
        String commitMessage = StringUtil.escapeXmlEntities((String)StringUtil.shortenTextWithEllipsis((String)commit2.getSubject(), (int)20, (int)0));
        String commitDetails = String.format("<code>%s \"%s\"</code>", XmlStringUtil.wrapInHtmlTag((String)((Hash)commit2.getId()).toShortString(), (String)"b"), commitMessage);
        String author = XmlStringUtil.wrapInHtmlTag((String)VcsUserUtil.getShortPresentation((VcsUser)commit2.getAuthor()), (String)"code");
        return GitBundle.message("git.reset.dialog.description.commit.details.by.author", commitDetails, author);
    }

    @NotNull
    @NonNls
    private static String getSourceText(@NotNull GitRepository repository) {
        String currentRevision = repository.getCurrentRevision();
        assert (currentRevision != null);
        String text = repository.getCurrentBranch() == null ? "HEAD (" + DvcsUtil.getShortHash((String)currentRevision) + ")" : repository.getCurrentBranch().getName();
        return XmlStringUtil.wrapInHtmlTag((String)text, (String)"b");
    }

    private static boolean isMultiRepo(@NotNull Project project) {
        return GitRepositoryManager.getInstance(project).moreThanOneRoot();
    }

    @NotNull
    public GitResetMode getResetMode() {
        return (GitResetMode)this.myEnumModel.getSelected();
    }
}

