/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTagModeKt;
import git4idea.push.GitVcsPushOptionValue;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushOptionsPanel
extends VcsPushOptionsPanel {
    @NotNull
    private final JBCheckBox myPushTags;
    @NotNull
    private final ComboBox<GitPushTagMode> myPushTagsMode;
    @NotNull
    private final JBCheckBox myRunHooks;

    public GitPushOptionsPanel(@Nullable GitPushTagMode defaultMode, boolean followTagsSupported, boolean showSkipHookOption) {
        String checkboxText = GitBundle.getString("push.dialog.push.tags");
        if (followTagsSupported) {
            checkboxText = checkboxText + ": ";
        }
        this.myPushTags = new JBCheckBox(checkboxText);
        this.myPushTags.setMnemonic('T');
        this.myPushTags.setSelected(defaultMode != null);
        this.myPushTagsMode = new ComboBox((Object[])GitPushTagMode.getValues());
        this.myPushTagsMode.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", GitPushTagModeKt::localizedTitle));
        this.myPushTagsMode.setEnabled(this.myPushTags.isSelected());
        if (defaultMode != null) {
            this.myPushTagsMode.setSelectedItem((Object)defaultMode);
        }
        this.myPushTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                GitPushOptionsPanel.this.myPushTagsMode.setEnabled(GitPushOptionsPanel.this.myPushTags.isSelected());
            }
        });
        this.myPushTagsMode.setVisible(followTagsSupported);
        this.myRunHooks = new JBCheckBox(GitBundle.message("checkbox.run.git.hooks", new Object[0]));
        this.myRunHooks.setMnemonic(72);
        this.myRunHooks.setSelected(true);
        this.myRunHooks.setVisible(showSkipHookOption);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add((Component)this.myPushTags);
        if (this.myPushTagsMode.isVisible()) {
            this.add(Box.createHorizontalStrut(GitPushOptionsPanel.calcStrutWidth(8, (JComponent)this.myPushTags, this.myPushTagsMode)));
            this.add((Component)this.myPushTagsMode);
        }
        if (this.myRunHooks.isVisible()) {
            this.add(Box.createHorizontalStrut(GitPushOptionsPanel.calcStrutWidth(16, this.myPushTagsMode, (JComponent)this.myRunHooks)));
            this.add((Component)this.myRunHooks);
        }
    }

    private static int calcStrutWidth(int plannedWidth, @NotNull JComponent leftComponent, @NotNull JComponent rightComponent) {
        return JBUIScale.scale((int)plannedWidth) - JBUI.insets((Insets)rightComponent.getInsets()).left - JBUI.insets((Insets)leftComponent.getInsets()).right;
    }

    @Nullable
    public VcsPushOptionValue getValue() {
        GitPushTagMode selectedTagMode = !this.myPushTagsMode.isVisible() ? GitPushTagMode.ALL : (GitPushTagMode)((Object)this.myPushTagsMode.getSelectedItem());
        GitPushTagMode tagMode = this.myPushTags.isSelected() ? selectedTagMode : null;
        return new GitVcsPushOptionValue(tagMode, this.myRunHooks.isVisible() && !this.myRunHooks.isSelected());
    }

    @NotNull
    public VcsPushOptionsPanel.OptionsPanelPosition getPosition() {
        return VcsPushOptionsPanel.OptionsPanelPosition.SOUTH;
    }
}

