/*
 * Decompiled with CFR 0.152.
 */
package git4idea.light;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.PathUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.index.LightFileStatus;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002\u001a\u000f\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007*\u00020\u0002\u001a\u0011\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007*\u00020\u000bH\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"color", "Ljava/awt/Color;", "Lgit4idea/index/LightFileStatus;", "getColor", "(Lgit4idea/index/LightFileStatus;)Ljava/awt/Color;", "getPresentation", "", "Lorg/jetbrains/annotations/Nls;", "status", "", "Lgit4idea/index/StatusCode;", "Lgit4idea/index/LightFileStatus$StatusRecord;", "intellij.vcs.git"})
public final class LightGitPresentationKt {
    @Nullable
    public static final Color getColor(@NotNull LightFileStatus $this$color) {
        return $this$color.getFileStatus$intellij_vcs_git().getColor();
    }

    @NotNull
    public static final String getPresentation(@NotNull LightFileStatus $this$getPresentation) {
        String string;
        LightFileStatus lightFileStatus = $this$getPresentation;
        if (Intrinsics.areEqual((Object)lightFileStatus, (Object)LightFileStatus.Blank.INSTANCE) || lightFileStatus instanceof LightFileStatus.NotChanged) {
            string = "";
        } else if (lightFileStatus instanceof LightFileStatus.StatusRecord) {
            string = LightGitPresentationKt.getPresentation((LightFileStatus.StatusRecord)$this$getPresentation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String getPresentation(LightFileStatus.StatusRecord $this$getPresentation) {
        String workTreePresentation;
        String fileName = PathUtil.getFileName((String)$this$getPresentation.getPath());
        if ($this$getPresentation.getIndex() == '!' || $this$getPresentation.getWorkTree() == '!' || $this$getPresentation.getIndex() == '?' || $this$getPresentation.getWorkTree() == '?') {
            return fileName + ": " + LightGitPresentationKt.getPresentation($this$getPresentation.getIndex());
        }
        if ($this$getPresentation.isConflicted$intellij_vcs_git()) {
            String string;
            if ($this$getPresentation.getIndex() == $this$getPresentation.getWorkTree()) {
                Object[] objectArray = new Object[1];
                FileStatus fileStatus = GitIndexStatusUtilKt.getFileStatus($this$getPresentation.getIndex() == 'U' ? (char)'M' : (char)$this$getPresentation.getIndex());
                if (fileStatus == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = fileStatus.getText();
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                objectArray[0] = string4;
                string = GitBundle.message("git.status.unmerged.both", objectArray);
            } else {
                String string5;
                String indexPresentation;
                String string6;
                if ($this$getPresentation.getIndex() == 'U') {
                    string6 = "";
                } else {
                    Object[] objectArray = new Object[1];
                    String string7 = LightGitPresentationKt.getPresentation($this$getPresentation.getIndex());
                    boolean bl = false;
                    String string8 = string7;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
                    objectArray[0] = string9;
                    string6 = indexPresentation = GitBundle.message("git.status.unmerged.index", objectArray);
                }
                if ($this$getPresentation.getWorkTree() == 'U') {
                    string5 = "";
                } else {
                    Object[] objectArray = new Object[1];
                    String string10 = LightGitPresentationKt.getPresentation($this$getPresentation.getWorkTree());
                    boolean bl = false;
                    String string11 = string10;
                    if (string11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string12 = string11.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).toLowerCase()");
                    objectArray[0] = string12;
                    string5 = GitBundle.message("git.status.unmerged.work.tree", objectArray);
                }
                String workTreePresentation2 = string5;
                string = StringsKt.isBlank((CharSequence)indexPresentation) ? workTreePresentation2 : (StringsKt.isBlank((CharSequence)workTreePresentation2) ? indexPresentation : indexPresentation + ", " + workTreePresentation2);
            }
            String status = string;
            return fileName + ": " + LightGitPresentationKt.getPresentation('U') + " (" + status + ')';
        }
        String indexPresentation = $this$getPresentation.getIndex() == ' ' ? "" : GitBundle.message("git.status.index", LightGitPresentationKt.getPresentation($this$getPresentation.getIndex()));
        String string = workTreePresentation = $this$getPresentation.getWorkTree() == ' ' ? "" : GitBundle.message("git.status.work.tree", LightGitPresentationKt.getPresentation($this$getPresentation.getWorkTree()));
        if (StringsKt.isBlank((CharSequence)indexPresentation)) {
            return fileName + ": " + workTreePresentation;
        }
        if (StringsKt.isBlank((CharSequence)workTreePresentation)) {
            return fileName + ": " + indexPresentation;
        }
        return fileName + ":<br/>" + indexPresentation + "<br/>" + workTreePresentation;
    }

    private static final String getPresentation(char status) {
        String string;
        switch (status) {
            case ' ': {
                string = GitBundle.message("git.status.not.changed", new Object[0]);
                break;
            }
            case 'R': {
                string = GitBundle.message("git.status.renamed", new Object[0]);
                break;
            }
            case 'C': {
                string = GitBundle.message("git.status.copied", new Object[0]);
                break;
            }
            case 'T': {
                string = GitBundle.message("git.status.type.changed", new Object[0]);
                break;
            }
            case 'U': {
                string = GitBundle.message("git.status.unmerged", new Object[0]);
                break;
            }
            case '?': {
                string = GitBundle.message("git.status.untracked", new Object[0]);
                break;
            }
            default: {
                FileStatus fileStatus = GitIndexStatusUtilKt.getFileStatus(status);
                if (fileStatus == null) {
                    Intrinsics.throwNpe();
                }
                string = fileStatus.getText();
            }
        }
        return string;
    }
}

