/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.GuiUtils;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.nio.file.NoSuchFileException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableProblemsNotifier {
    @NotNull
    private final Project myProject;

    public static GitExecutableProblemsNotifier getInstance(@NotNull Project project) {
        return (GitExecutableProblemsNotifier)ServiceManager.getService((Project)project, GitExecutableProblemsNotifier.class);
    }

    public GitExecutableProblemsNotifier(@NotNull Project project) {
        this.myProject = project;
    }

    public void notifyExecutionError(@NotNull Throwable exception) {
        GitExecutableProblemHandler problemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(this.myProject);
        NotificationErrorNotifier errorNotifier = new NotificationErrorNotifier(this.myProject);
        problemHandler.showError(exception, errorNotifier);
    }

    static void notify(@NotNull Project project, @NotNull BadGitExecutableNotification notification) {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (GitExecutableProblemsNotifier.ensureSingularOfType(project, ((Object)((Object)notification)).getClass())) {
                notification.notify(project);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private static boolean ensureSingularOfType(@NotNull Project project, @NotNull Class<? extends BadGitExecutableNotification> notificationType) {
        BadGitExecutableNotification[] currentNotifications = (BadGitExecutableNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(BadGitExecutableNotification.class, project);
        int notificationsCount = currentNotifications.length;
        if (notificationsCount <= 0) {
            return true;
        }
        for (int i2 = 0; i2 < notificationsCount - 1; ++i2) {
            currentNotifications[i2].expire();
        }
        BadGitExecutableNotification lastNotification = currentNotifications[notificationsCount - 1];
        if (((Object)((Object)lastNotification)).getClass() != notificationType) {
            lastNotification.expire();
            return true;
        }
        return false;
    }

    public void expireNotifications() {
        for (BadGitExecutableNotification notification : (BadGitExecutableNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    @NotNull
    public static String getPrettyErrorMessage(@NotNull Throwable exception) {
        String errorMessage = null;
        if (exception instanceof GitVersionIdentificationException && exception.getCause() != null) {
            Throwable cause = exception.getCause();
            errorMessage = cause instanceof NoSuchFileException ? GitBundle.message("git.executable.error.file.not.found", cause.getMessage()) : cause.getMessage();
        }
        if (errorMessage == null) {
            if (exception.getMessage() != null) {
                return exception.getMessage();
            }
            return exception.getClass().getName();
        }
        return errorMessage;
    }

    static class BadGitExecutableNotification
    extends Notification {
        BadGitExecutableNotification(@NotNull String groupDisplayId, @Nullable Icon icon, @Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
            super(groupDisplayId, icon, title, subtitle, content, type, listener);
        }
    }
}

