/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.ObjectUtils;
import git4idea.GitUtil;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHttpAuthService;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitNativeSshGuiAuthenticator;
import git4idea.commands.GitPassthroughAuthenticationGate;
import git4idea.config.GitExecutable;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitXmlRpcHandlerService;
import org.jetbrains.git4idea.ssh.GitXmlRpcNativeSshService;

public class GitHandlerAuthenticationManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getInstance(GitHandlerAuthenticationManager.class);
    @NotNull
    private final GitLineHandler myHandler;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVersion myVersion;
    @Nullable
    private UUID myHttpHandler;
    private volatile boolean myHttpAuthFailed;
    @Nullable
    private UUID myNativeSshHandler;

    private GitHandlerAuthenticationManager(@NotNull Project project, @NotNull GitLineHandler handler, @NotNull GitVersion version) {
        this.myProject = project;
        this.myHandler = handler;
        this.myVersion = version;
    }

    @NotNull
    public static GitHandlerAuthenticationManager prepare(@NotNull Project project, @NotNull GitLineHandler handler, @NotNull GitVersion version) throws IOException {
        GitHandlerAuthenticationManager manager = new GitHandlerAuthenticationManager(project, handler, version);
        GitUtil.tryRunOrClose(manager, () -> {
            boolean shouldResetCredentialHelper;
            boolean isConfigCommand;
            manager.prepareHttpAuth();
            manager.prepareNativeSshAuth();
            boolean useCredentialHelper = GitVcsApplicationSettings.getInstance().isUseCredentialHelper();
            boolean bl = isConfigCommand = handler.getCommand() == GitCommand.CONFIG;
            if (isConfigCommand) {
                return;
            }
            boolean bl2 = shouldResetCredentialHelper = !useCredentialHelper && GitVersionSpecialty.CAN_OVERRIDE_CREDENTIAL_HELPER_WITH_EMPTY.existsIn(version);
            if (shouldResetCredentialHelper) {
                handler.overwriteConfig("credential.helper=");
            }
        });
        return manager;
    }

    @Override
    public void close() {
        this.cleanupHttpAuth();
        this.cleanupNativeSshAuth();
    }

    private void prepareHttpAuth() throws IOException {
        boolean useSchannel;
        GitHttpAuthService service = (GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class);
        this.addHandlerPathToEnvironment("GIT_ASKPASS", service);
        GitAuthenticationGate authenticationGate = (GitAuthenticationGate)ObjectUtils.notNull((Object)this.myHandler.getAuthenticationGate(), (Object)GitPassthroughAuthenticationGate.getInstance());
        final GitHttpAuthenticator httpAuthenticator = service.createAuthenticator(this.myProject, this.myHandler.getUrls(), this.myHandler.getWorkingDirectory(), authenticationGate, this.myHandler.getIgnoreAuthenticationMode());
        this.myHttpHandler = service.registerHandler(httpAuthenticator);
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS_HANDLER", this.myHttpHandler.toString());
        int port = service.getXmlRcpPort();
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS_PORT", Integer.toString(port));
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS_TOKEN", BuiltinWebServerAccess.getUserAuthenticationToken());
        LOG.debug(String.format("myHandler=%s, port=%s", this.myHttpHandler, port));
        this.myHandler.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(@NonNls String line, Key outputType) {
                if (!httpAuthenticator.wasRequested()) {
                    return;
                }
                String lowerCaseLine = StringUtil.toLowerCase((String)line);
                if (lowerCaseLine.contains("authentication failed") || lowerCaseLine.contains("403 forbidden") || lowerCaseLine.contains("error: 400") || lowerCaseLine.contains("fatal: repository") && lowerCaseLine.contains("not found") || lowerCaseLine.contains("fatal: unable to access") && lowerCaseLine.contains("the requested url returned error: 403") || lowerCaseLine.contains("[remote rejected] (permission denied)")) {
                    LOG.debug("auth listener: auth failure detected: " + line);
                    GitHandlerAuthenticationManager.this.myHttpAuthFailed = true;
                }
            }

            public void processTerminated(int exitCode) {
                if (!httpAuthenticator.wasRequested()) {
                    return;
                }
                LOG.debug("auth listener: process terminated. auth failed=" + GitHandlerAuthenticationManager.this.myHttpAuthFailed + ", cancelled=" + httpAuthenticator.wasCancelled());
                if (!httpAuthenticator.wasCancelled()) {
                    if (GitHandlerAuthenticationManager.this.myHttpAuthFailed) {
                        httpAuthenticator.forgetPassword();
                    } else {
                        httpAuthenticator.saveAuthData();
                    }
                } else {
                    GitHandlerAuthenticationManager.this.myHttpAuthFailed = false;
                }
            }
        });
        boolean bl = useSchannel = SystemInfo.isWindows && GitVersionSpecialty.CAN_USE_SCHANNEL.existsIn(this.myVersion) && Registry.is((String)"git.use.schannel.on.windows");
        if (useSchannel) {
            this.myHandler.overwriteConfig("http.sslBackend=schannel");
        }
    }

    private void cleanupHttpAuth() {
        if (this.myHttpHandler != null) {
            ((GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class)).unregisterHandler(this.myHttpHandler);
            this.myHttpHandler = null;
        }
    }

    public boolean isHttpAuthFailed() {
        return this.myHttpAuthFailed;
    }

    private void prepareNativeSshAuth() throws IOException {
        GitXmlRpcNativeSshService service = (GitXmlRpcNativeSshService)ServiceManager.getService(GitXmlRpcNativeSshService.class);
        boolean doNotRememberPasswords = this.myHandler.getUrls().size() > 1;
        GitAuthenticationGate authenticationGate = (GitAuthenticationGate)ObjectUtils.notNull((Object)this.myHandler.getAuthenticationGate(), (Object)GitPassthroughAuthenticationGate.getInstance());
        GitNativeSshGuiAuthenticator authenticator = new GitNativeSshGuiAuthenticator(this.myProject, authenticationGate, this.myHandler.getIgnoreAuthenticationMode(), doNotRememberPasswords);
        this.myNativeSshHandler = service.registerHandler(authenticator);
        int port = service.getXmlRcpPort();
        this.addHandlerPathToEnvironment("SSH_ASKPASS", service);
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_SSH_ASKPASS_HANDLER", this.myNativeSshHandler.toString());
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_SSH_ASKPASS_PORT", Integer.toString(port));
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_SSH_ASKPASS_TOKEN", BuiltinWebServerAccess.getUserAuthenticationToken());
        LOG.debug(String.format("myHandler=%s, port=%s", this.myNativeSshHandler, port));
        String displayEnv = StringUtil.nullize((String)System.getenv("DISPLAY"));
        this.myHandler.addCustomEnvironmentVariable("DISPLAY", StringUtil.notNullize((String)displayEnv, (String)":0.0"));
        if (Registry.is((String)"git.use.setsid.for.native.ssh")) {
            this.myHandler.withNoTty();
        }
    }

    private void addHandlerPathToEnvironment(@NotNull String env, @NotNull GitXmlRpcHandlerService service) throws IOException {
        GitExecutable executable = this.myHandler.getExecutable();
        boolean useBatchFile = SystemInfo.isWindows && executable.isLocal() && (!Registry.is((String)"git.use.shell.script.on.windows") || !GitVersionSpecialty.CAN_USE_SHELL_HELPER_SCRIPT_ON_WINDOWS.existsIn(this.myVersion));
        File scriptFile = service.getScriptPath(executable, useBatchFile);
        this.myHandler.addCustomEnvironmentVariable(env, scriptFile);
    }

    private void cleanupNativeSshAuth() {
        if (this.myNativeSshHandler != null) {
            ((GitXmlRpcNativeSshService)ServiceManager.getService(GitXmlRpcNativeSshService.class)).unregisterHandler(this.myNativeSshHandler);
            this.myNativeSshHandler = null;
        }
    }
}

