/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommandResult {
    private final boolean myStartFailed;
    private final int myExitCode;
    private final boolean myAuthenticationFailed;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;

    public GitCommandResult(boolean startFailed, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output) {
        this(startFailed, exitCode, false, errorOutput, output);
    }

    private GitCommandResult(boolean startFailed, int exitCode, boolean authenticationFailed, @NotNull List<String> errorOutput, @NotNull List<String> output) {
        this.myExitCode = exitCode;
        this.myStartFailed = startFailed;
        this.myAuthenticationFailed = authenticationFailed;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
    }

    @NotNull
    static GitCommandResult withAuthentication(@NotNull GitCommandResult result2, boolean authenticationFailed) {
        return new GitCommandResult(result2.myStartFailed, result2.myExitCode, authenticationFailed, result2.myErrorOutput, result2.myOutput);
    }

    public boolean success() {
        return this.success(new int[0]);
    }

    public boolean success(int ... ignoredErrorCodes) {
        return !this.myStartFailed && (Arrays.stream(ignoredErrorCodes).anyMatch(i2 -> i2 == this.myExitCode) || this.myExitCode == 0);
    }

    @NotNull
    public List<String> getOutput() {
        return Collections.unmodifiableList(this.myOutput);
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public boolean isAuthenticationFailed() {
        return this.myAuthenticationFailed;
    }

    @NotNull
    public List<String> getErrorOutput() {
        return Collections.unmodifiableList(this.myErrorOutput);
    }

    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    @NotNull
    public String getErrorOutputAsHtmlString() {
        return StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"<br/>");
    }

    @NotNull
    public String getErrorOutputAsJoinedString() {
        return StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"\n");
    }

    @NotNull
    private List<String> getErrorOrStdOutput() {
        return this.myErrorOutput.isEmpty() && !this.success() ? this.myOutput : this.myErrorOutput;
    }

    @NotNull
    public String getOutputAsJoinedString() {
        return StringUtil.join(this.myOutput, (String)"\n");
    }

    @NotNull
    public String getOutputOrThrow(int ... ignoredErrorCodes) throws VcsException {
        this.throwOnError(ignoredErrorCodes);
        return this.getOutputAsJoinedString();
    }

    public void throwOnError(int ... ignoredErrorCodes) throws VcsException {
        if (!this.success(ignoredErrorCodes)) {
            throw new VcsException(this.getErrorOutputAsJoinedString());
        }
    }

    @Deprecated
    @Nullable
    public Throwable getException() {
        return null;
    }

    @NotNull
    static GitCommandResult startError(@NotNull String error) {
        return new GitCommandResult(true, -1, Collections.singletonList(error), Collections.emptyList());
    }

    @NotNull
    public static GitCommandResult error(@NotNull String error) {
        return new GitCommandResult(false, 1, Collections.singletonList(error), Collections.emptyList());
    }

    public boolean cancelled() {
        return false;
    }

    @NotNull
    private static Collection<String> cleanup(@NotNull Collection<String> errorOutput) {
        return ContainerUtil.map(errorOutput, errorMessage -> GitUtil.cleanupErrorPrefixes(errorMessage));
    }

    protected boolean hasStartFailed() {
        return this.myStartFailed;
    }
}

