/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitChangeUtils {
    public static final String COMMITTED_CHANGELIST_FORMAT = "%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03";
    private static final Logger LOG = Logger.getInstance(GitChangeUtils.class);

    private GitChangeUtils() {
    }

    private static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, GitRevisionNumber parentRevision, String s, Collection<? super Change> changes) throws VcsException {
        GitChangeUtils.parseChanges(project, vcsRoot, thisRevision, parentRevision, new StringScanner(s), changes);
    }

    private static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, @Nullable GitRevisionNumber parentRevision, StringScanner s, Collection<? super Change> changes) throws VcsException {
        GitChangeUtils.parseChanges(vcsRoot, s, (status, beforePath, afterPath) -> {
            assert (beforePath != null || afterPath != null);
            ContentRevision before = beforePath != null ? GitContentRevision.createRevision(beforePath, (VcsRevisionNumber)parentRevision, project) : null;
            ContentRevision after2 = afterPath != null ? GitContentRevision.createRevision(afterPath, (VcsRevisionNumber)thisRevision, project) : null;
            changes.add(new Change(before, after2, status));
        });
    }

    private static void parseChanges(@NotNull VirtualFile vcsRoot, @NotNull StringScanner s, @NotNull FileStatusLineConsumer consumer2) throws VcsException {
        while (s.hasMoreData()) {
            FilePath after2;
            FilePath before;
            FileStatus status = null;
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMRT".indexOf(s.peek()) == -1) {
                return;
            }
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            FilePath filePath = GitContentRevision.createPathFromEscaped(vcsRoot, path);
            switch (tokens[0].charAt(0)) {
                case 'A': 
                case 'C': {
                    status = FileStatus.ADDED;
                    before = null;
                    after2 = filePath;
                    break;
                }
                case 'U': {
                    status = FileStatus.MERGED_WITH_CONFLICTS;
                }
                case 'M': {
                    if (status == null) {
                        status = FileStatus.MODIFIED;
                    }
                    before = filePath;
                    after2 = filePath;
                    break;
                }
                case 'D': {
                    status = FileStatus.DELETED;
                    before = filePath;
                    after2 = null;
                    break;
                }
                case 'R': {
                    status = FileStatus.MODIFIED;
                    before = GitContentRevision.createPathFromEscaped(vcsRoot, tokens[1]);
                    after2 = filePath;
                    break;
                }
                case 'T': {
                    status = FileStatus.MODIFIED;
                    before = filePath;
                    after2 = filePath;
                    break;
                }
                default: {
                    throw new VcsException("Unknown file status: " + Arrays.asList(tokens));
                }
            }
            consumer2.consume(status, before, after2);
        }
    }

    @NotNull
    public static GitRevisionNumber resolveReference(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull String reference) throws VcsException {
        GitLineHandler handler = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        StringTokenizer stk = new StringTokenizer(output, "\n\r \t", false);
        if (!stk.hasMoreTokens()) {
            try {
                GitLineHandler dh = new GitLineHandler(project, vcsRoot, GitCommand.LOG);
                dh.addParameters("-1", "HEAD");
                dh.setSilent(true);
                String out = Git.getInstance().runCommand(dh).getOutputOrThrow(new int[0]);
                LOG.info("Diagnostic output from 'git log -1 HEAD': [" + out + "]");
                dh = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
                out = Git.getInstance().runCommand(dh).getOutputOrThrow(new int[0]);
                LOG.info("Diagnostic output from 'git rev-list -1 --timestamp HEAD': [" + out + "]");
            }
            catch (VcsException e) {
                LOG.info("Exception while trying to get some diagnostics info", (Throwable)e);
            }
            throw new VcsException(String.format("The string '%s' does not represent a revision number. Output: [%s]\n Root: %s", reference, output, vcsRoot));
        }
        Date timestamp = GitUtil.parseTimestampWithNFEReport(stk.nextToken(), handler, output);
        return new GitRevisionNumber(stk.nextToken(), timestamp);
    }

    @NotNull
    private static GitLineHandler createRefResolveHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull String reference) {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REV_LIST);
        handler.addParameters("--timestamp", "--max-count=1", reference);
        handler.endOptions();
        handler.setSilent(true);
        return handler;
    }

    public static GitCommittedChangeList getRevisionChanges(Project project, VirtualFile root, String revisionName, boolean skipDiffsForMerge, boolean local, boolean revertable) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.SHOW);
        h2.setSilent(true);
        h2.addParameters("--name-status", "--first-parent", "--no-abbrev", "-M", "--pretty=format:%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--encoding=UTF-8", revisionName, "--");
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        StringScanner s = new StringScanner(output);
        return GitChangeUtils.parseChangeList(project, root, s, skipDiffsForMerge, h2, local, revertable);
    }

    public static GitCommittedChangeList parseChangeList(Project project, VirtualFile root, StringScanner s, boolean skipDiffsForMerge, GitHandler handler, boolean local, boolean revertable) throws VcsException {
        ArrayList<Change> changes = new ArrayList<Change>();
        Date commitDate = GitUtil.parseTimestampWithNFEReport(s.line(), handler, s.getAllText());
        String revisionNumber = s.line();
        String parentsLine = s.line();
        String[] parents = parentsLine.length() == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : parentsLine.split(" ");
        String authorName = s.line();
        String committerName = s.line();
        committerName = GitUtil.adjustAuthorName(authorName, committerName);
        String commentSubject = s.boundedToken('\u0003', true);
        s.nextLine();
        String commentBody = s.boundedToken('\u0003', true);
        String fullComment = commentSubject.length() == 0 ? commentBody : (commentBody.length() == 0 ? commentSubject : commentSubject + "\n" + commentBody);
        GitRevisionNumber thisRevision = new GitRevisionNumber(revisionNumber, commitDate);
        if (skipDiffsForMerge || parents.length <= 1) {
            String[] parentRevision = parents.length > 0 ? GitChangeUtils.resolveReference(project, root, parents[0]) : null;
            GitChangeUtils.parseChanges(project, root, thisRevision, (GitRevisionNumber)(local ? null : parentRevision), s, changes);
        } else {
            for (String parent : parents) {
                GitRevisionNumber parentRevision = GitChangeUtils.resolveReference(project, root, parent);
                GitLineHandler diffHandler = new GitLineHandler(project, root, GitCommand.DIFF);
                diffHandler.setSilent(true);
                diffHandler.addParameters("--name-status", "-M", parentRevision.getRev(), thisRevision.getRev());
                String diff = Git.getInstance().runCommand(diffHandler).getOutputOrThrow(new int[0]);
                GitChangeUtils.parseChanges(project, root, thisRevision, parentRevision, diff, changes);
                if (changes.size() > 0) break;
            }
        }
        String changeListName = String.format("%s(%s)", commentSubject, revisionNumber);
        return new GitCommittedChangeList(changeListName, fullComment, committerName, thisRevision, commitDate, changes, GitVcs.getInstance(project), revertable);
    }

    public static long longForSHAHash(String revisionNumber) {
        return Long.parseLong(revisionNumber.substring(0, 15), 16) << 4 + Integer.parseInt(revisionNumber.substring(15, 16), 16);
    }

    @NotNull
    public static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable String oldRevision, @Nullable String newRevision, @Nullable Collection<? extends FilePath> dirtyPaths) throws VcsException {
        return GitChangeUtils.getDiff(project, root, oldRevision, newRevision, dirtyPaths, true);
    }

    @NotNull
    private static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable String oldRevision, @Nullable String newRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean detectRenames) throws VcsException {
        GitRevisionNumber newRev;
        GitRevisionNumber oldRev;
        String range;
        LOG.assertTrue(oldRevision != null || newRevision != null, (Object)"Both old and new revisions can't be null");
        if (newRevision == null) {
            range = oldRevision + "..";
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = null;
        } else if (oldRevision == null) {
            range = ".." + newRevision;
            oldRev = null;
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        } else {
            range = oldRevision + ".." + newRevision;
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        }
        String output = GitChangeUtils.getDiffOutput(project, root, range, dirtyPaths, false, detectRenames);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitChangeUtils.parseChanges(project, root, newRev, oldRev, output, changes);
        return changes;
    }

    @NotNull
    public static Collection<GitDiffChange> getStagedChanges(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        return GitChangeUtils.getLocalChanges(project, root, null, "--cached", "-M");
    }

    @NotNull
    public static Collection<GitDiffChange> getUnstagedChanges(@NotNull Project project, @NotNull VirtualFile root, boolean detectMoves) throws VcsException {
        if (detectMoves) {
            return GitChangeUtils.getLocalChanges(project, root, null, "-M");
        }
        return GitChangeUtils.getLocalChanges(project, root, null, "--no-renames");
    }

    @NotNull
    public static Collection<GitDiffChange> getWorkingTreeChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths, boolean detectMoves) throws VcsException {
        if (detectMoves) {
            return GitChangeUtils.getLocalChanges(project, root, paths, "-M", "HEAD");
        }
        return GitChangeUtils.getLocalChanges(project, root, paths, "--no-renames", "HEAD");
    }

    @NotNull
    private static Collection<GitDiffChange> getLocalChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths, String ... parameters) throws VcsException {
        if (paths != null && paths.isEmpty()) {
            return Collections.emptyList();
        }
        GitLineHandler handler = (GitLineHandler)GitUtil.createHandlerWithPaths(paths, () -> {
            GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
            diff.addParameters("--name-status");
            diff.addParameters(parameters);
            return diff;
        });
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        ArrayList<GitDiffChange> changes = new ArrayList<GitDiffChange>();
        GitChangeUtils.parseChanges(root, new StringScanner(output), (status, beforePath, afterPath) -> changes.add(new GitDiffChange(status, beforePath, afterPath)));
        return changes;
    }

    @NotNull
    public static List<FilePath> getUnmergedFiles(@NotNull GitRepository repository) throws VcsException {
        GitCommandResult result2 = Git.getInstance().getUnmergedFiles(repository);
        if (!result2.success()) {
            throw new VcsException(result2.getErrorOutputAsJoinedString());
        }
        VirtualFile root = repository.getRoot();
        String output = StringUtil.join(result2.getOutput(), (String)"\n");
        HashSet<FilePath> unmergedPaths = new HashSet<FilePath>();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            String path = GitUtil.unescapePath(relative);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)root, (String)path, (boolean)false);
            unmergedPaths.add(filePath);
        }
        return new ArrayList<FilePath>(unmergedPaths);
    }

    @NotNull
    public static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull String oldRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse) throws VcsException {
        return GitChangeUtils.getDiffWithWorkingDir(project, root, oldRevision, dirtyPaths, reverse, true);
    }

    @NotNull
    public static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull String oldRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse, boolean detectRenames) throws VcsException {
        String output = GitChangeUtils.getDiffOutput(project, root, oldRevision, dirtyPaths, reverse, detectRenames);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitRevisionNumber revisionNumber = GitChangeUtils.resolveReference(project, root, oldRevision);
        GitChangeUtils.parseChanges(project, root, reverse ? revisionNumber : null, reverse ? null : revisionNumber, output, changes);
        return changes;
    }

    @NotNull
    private static String getDiffOutput(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse, boolean detectRenames) throws VcsException {
        GitLineHandler h2 = (GitLineHandler)GitUtil.createHandlerWithPaths(dirtyPaths, () -> {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.DIFF);
            if (reverse) {
                handler.addParameters("-R");
            }
            handler.addParameters("--name-status", "--diff-filter=ADCMRUXT");
            if (detectRenames) {
                handler.addParameters("-M");
            }
            handler.addParameters(diffRange);
            handler.setSilent(true);
            handler.setStdoutSuppressed(true);
            return handler;
        });
        return Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
    }

    @Nullable
    public static Collection<Change> getDiffWithWorkingTree(@NotNull GitRepository repository, @NotNull String refToCompare, boolean detectRenames) {
        Collection<Change> changes;
        try {
            changes = GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), refToCompare, null, false, detectRenames);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't collect diff", (Throwable)e);
            changes = null;
        }
        return changes;
    }

    @Nullable
    public static Collection<Change> getDiff(@NotNull GitRepository repository, @NotNull String oldRevision, @NotNull String newRevision, boolean detectRenames) {
        try {
            return GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), oldRevision, newRevision, null, detectRenames);
        }
        catch (VcsException e) {
            LOG.info("Couldn't collect changes between " + oldRevision + " and " + newRevision, (Throwable)e);
            return null;
        }
    }

    public static class GitDiffChange
    implements FilePathChange {
        @NotNull
        private final FileStatus status;
        @Nullable
        private final FilePath beforePath;
        @Nullable
        private final FilePath afterPath;

        public GitDiffChange(@NotNull FileStatus status, @Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            assert (beforePath != null || afterPath != null);
            this.status = status;
            this.beforePath = beforePath;
            this.afterPath = afterPath;
        }

        @Nullable
        public FilePath getBeforePath() {
            return this.beforePath;
        }

        @Nullable
        public FilePath getAfterPath() {
            return this.afterPath;
        }

        @NotNull
        public FilePath getFilePath() {
            @Nullable FilePath t = this.afterPath != null ? this.afterPath : this.beforePath;
            return Objects.requireNonNull(t);
        }

        @NotNull
        public FileStatus getStatus() {
            return this.status;
        }
    }

    private static interface FileStatusLineConsumer {
        public void consume(@NotNull FileStatus var1, @Nullable FilePath var2, @Nullable FilePath var3);
    }
}

