/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Alarm;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitIncomingCheckStrategy;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchIncomingOutgoingManager
implements GitRepositoryChangeListener,
GitAuthenticationListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(GitBranchIncomingOutgoingManager.class);
    public static final Topic<GitIncomingOutgoingListener> GIT_INCOMING_OUTGOING_CHANGED = Topic.create((String)"Git incoming outgoing info changed", GitIncomingOutgoingListener.class);
    private static final String MAC_DEFAULT_LAUNCH = "com.apple.launchd";
    private static final boolean HAS_EXTERNAL_SSH_AGENT = GitBranchIncomingOutgoingManager.hasExternalSSHAgent();
    @NotNull
    private final Object LOCK = new Object();
    @NotNull
    private final Set<GitRepository> myDirtyReposWithIncoming = new HashSet<GitRepository>();
    @NotNull
    private final Set<GitRepository> myDirtyReposWithOutgoing = new HashSet<GitRepository>();
    private boolean myShouldRequestRemoteInfo;
    @NotNull
    private final MergingUpdateQueue myQueue;
    @NotNull
    private final Map<GitRepository, Set<GitLocalBranch>> myLocalBranchesWithIncoming = new ConcurrentHashMap<GitRepository, Set<GitLocalBranch>>();
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToFetch = new ConcurrentHashMap<GitRepository, Map<GitLocalBranch, Hash>>();
    @NotNull
    private final Map<GitRepository, Set<GitLocalBranch>> myLocalBranchesWithOutgoing = new ConcurrentHashMap<GitRepository, Set<GitLocalBranch>>();
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myErrorMap = MultiMap.createConcurrentSet();
    @NotNull
    private final Project myProject;
    @Nullable
    private ScheduledFuture<?> myPeriodicalUpdater;
    @Nullable
    private MessageBusConnection myConnection;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myAuthSuccessMap = MultiMap.createConcurrentSet();
    @NotNull
    private final AtomicBoolean myIsUpdating = new AtomicBoolean();

    GitBranchIncomingOutgoingManager(@NotNull Project project) {
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("GitBranchIncomingOutgoingManager", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public void dispose() {
        this.stopScheduling();
    }

    private static boolean hasExternalSSHAgent() {
        String ssh_auth_sock = EnvironmentUtil.getValue((String)"SSH_AUTH_SOCK");
        if (ssh_auth_sock == null) {
            return false;
        }
        return !StringUtil.contains((CharSequence)ssh_auth_sock, (CharSequence)MAC_DEFAULT_LAUNCH);
    }

    public boolean hasIncomingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        return this.shouldCheckIncoming() && this.getBranchesWithIncoming(repository).contains(new GitLocalBranch(localBranchName));
    }

    public boolean hasOutgoingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        return GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing() && this.getBranchesWithOutgoing(repository).contains(new GitLocalBranch(localBranchName));
    }

    public boolean shouldCheckIncoming() {
        return Registry.is((String)"git.update.incoming.outgoing.info") && GitVcsSettings.getInstance(this.myProject).getIncomingCheckStrategy() != GitIncomingCheckStrategy.Never;
    }

    private static boolean shouldCheckIncomingOutgoing() {
        return Registry.is((String)"git.update.incoming.outgoing.info");
    }

    @NotNull
    public static GitBranchIncomingOutgoingManager getInstance(@NotNull Project project) {
        return (GitBranchIncomingOutgoingManager)ServiceManager.getService((Project)project, GitBranchIncomingOutgoingManager.class);
    }

    public boolean supportsIncomingOutgoing() {
        return GitVersionSpecialty.INCOMING_OUTGOING_BRANCH_INFO.existsIn(this.myProject);
    }

    public void activate() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myConnection == null) {
                this.myConnection = this.myProject.getMessageBus().connect((Disposable)this);
                this.myConnection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
                this.myConnection.subscribe(GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS, (Object)this);
            }
            this.updateBranchesWithOutgoing();
            this.updateIncomingScheduling();
        });
    }

    public void updateIncomingScheduling() {
        if (this.myPeriodicalUpdater == null && this.shouldCheckIncoming()) {
            this.updateBranchesWithIncoming(true);
            int timeout = Registry.intValue((String)"git.update.incoming.info.time");
            this.myPeriodicalUpdater = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.updateBranchesWithIncoming(true), timeout, timeout, TimeUnit.MINUTES);
        } else if (this.myPeriodicalUpdater != null && !this.shouldCheckIncoming()) {
            this.stopScheduling();
        }
    }

    private void stopScheduling() {
        if (this.myPeriodicalUpdater != null) {
            this.myPeriodicalUpdater.cancel(true);
            this.myPeriodicalUpdater = null;
        }
    }

    public void forceUpdateBranches(final @Nullable Runnable runAfterUpdate) {
        if (!this.myIsUpdating.compareAndSet(false, true)) {
            return;
        }
        this.updateBranchesWithIncoming(false);
        this.updateBranchesWithOutgoing();
        new Task.Backgroundable(this.myProject, GitBundle.message("branches.update.info.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                Semaphore semaphore = new Semaphore(0);
                GitBranchIncomingOutgoingManager.this.myQueue.queue(Update.create((Object)((Object)this), () -> semaphore.release()));
                GitBranchIncomingOutgoingManager.this.myQueue.flush();
                try {
                    while (!indicator.isCanceled() && !semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }

            public void onFinished() {
                GitBranchIncomingOutgoingManager.this.myIsUpdating.set(false);
                if (runAfterUpdate != null) {
                    runAfterUpdate.run();
                }
            }
        }.queue();
    }

    public boolean isUpdating() {
        return this.myIsUpdating.get();
    }

    private void scheduleUpdate() {
        this.myQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"update", () -> {
            boolean shouldRequestRemoteInfo;
            ArrayList<GitRepository> withOutgoing;
            ArrayList<GitRepository> withIncoming;
            Iterator iterator = this.LOCK;
            synchronized (iterator) {
                withIncoming = new ArrayList<GitRepository>(this.myDirtyReposWithIncoming);
                withOutgoing = new ArrayList<GitRepository>(this.myDirtyReposWithOutgoing);
                shouldRequestRemoteInfo = this.myShouldRequestRemoteInfo;
                this.myDirtyReposWithIncoming.clear();
                this.myDirtyReposWithOutgoing.clear();
                this.myShouldRequestRemoteInfo = false;
            }
            for (GitRepository r : withOutgoing) {
                this.myLocalBranchesWithOutgoing.put(r, this.calculateBranchesWithOutgoing(r));
            }
            for (GitRepository r : withIncoming) {
                if (shouldRequestRemoteInfo) {
                    this.myLocalBranchesToFetch.put(r, this.calculateBranchesToFetch(r));
                }
                this.myLocalBranchesWithIncoming.put(r, this.calcBranchesWithIncoming(r));
            }
            ((GitIncomingOutgoingListener)this.myProject.getMessageBus().syncPublisher(GIT_INCOMING_OUTGOING_CHANGED)).incomingOutgoingInfoChanged();
        }));
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesWithIncoming(@Nullable GitRepository repository) {
        return GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesWithIncoming);
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesWithOutgoing(@Nullable GitRepository repository) {
        return GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesWithOutgoing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesWithIncoming(boolean fromRemote) {
        if (!this.shouldCheckIncoming()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myShouldRequestRemoteInfo = fromRemote;
            this.myDirtyReposWithIncoming.addAll(GitRepositoryManager.getInstance(this.myProject).getRepositories());
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesWithOutgoing() {
        if (!GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposWithOutgoing.addAll(GitRepositoryManager.getInstance(this.myProject).getRepositories());
        }
        this.scheduleUpdate();
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calculateBranchesToFetch(@NotNull GitRepository repository) {
        HashMap<GitLocalBranch, Hash> result2 = new HashMap<GitLocalBranch, Hash>();
        GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository).entrySet().forEach(entry -> result2.putAll(this.calcBranchesToFetchForRemote(repository, (GitRemote)entry.getKey(), (Collection)entry.getValue(), this.getAuthenticationMode(repository, (GitRemote)entry.getKey()))));
        return result2;
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calcBranchesToFetchForRemote(@NotNull GitRepository repository, @NotNull GitRemote gitRemote, @NotNull Collection<? extends GitBranchTrackInfo> trackInfoList, GitAuthenticationMode mode) {
        HashMap<GitLocalBranch, Hash> result2 = new HashMap<GitLocalBranch, Hash>();
        GitBranchesCollection branchesCollection = repository.getBranches();
        Map<String, Hash> remoteNameWithHash = this.lsRemote(repository, gitRemote, ContainerUtil.map(trackInfoList, info -> info.getRemoteBranch().getNameForRemoteOperations()), mode);
        for (Map.Entry<String, Hash> hashEntry : remoteNameWithHash.entrySet()) {
            String remoteBranchName = hashEntry.getKey();
            Hash remoteHash = hashEntry.getValue();
            trackInfoList.forEach(info -> {
                GitRemoteBranch remoteBranch = info.getRemoteBranch();
                Hash localHashForRemoteBranch = branchesCollection.getHash(remoteBranch);
                if (localHashForRemoteBranch == null) {
                    return;
                }
                if (StringUtil.equals((CharSequence)remoteBranchName, (CharSequence)GitRefUtil.addRefsHeadsPrefixIfNeeded(remoteBranch.getNameForRemoteOperations())) && !localHashForRemoteBranch.equals(remoteHash)) {
                    result2.put(info.getLocalBranch(), localHashForRemoteBranch);
                }
            });
        }
        return result2;
    }

    @NotNull
    private Set<GitLocalBranch> calcBranchesWithIncoming(@NotNull GitRepository repository) {
        HashSet<GitLocalBranch> result2 = new HashSet<GitLocalBranch>();
        GitBranchesCollection branchesCollection = repository.getBranches();
        Map<GitLocalBranch, Hash> cachedBranchesToFetch = this.myLocalBranchesToFetch.get(repository);
        branchesCollection.getLocalBranches().forEach(localBranch -> {
            GitBranchTrackInfo info = GitBranchUtil.getTrackInfoForBranch(repository, localBranch);
            if (info == null) {
                return;
            }
            Hash localHashForRemoteBranch = branchesCollection.getHash(info.getRemoteBranch());
            Hash localHash = branchesCollection.getHash((GitBranch)localBranch);
            if (localHashForRemoteBranch == null) {
                return;
            }
            if (this.hasCommitsForBranch(repository, info.getLocalBranch(), localHash, localHashForRemoteBranch, true)) {
                result2.add(info.getLocalBranch());
            } else if (cachedBranchesToFetch != null && localHashForRemoteBranch.equals(cachedBranchesToFetch.get(localBranch))) {
                result2.add(info.getLocalBranch());
            }
        });
        return result2;
    }

    @NotNull
    private GitAuthenticationMode getAuthenticationMode(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        return this.myAuthSuccessMap.get((Object)repository).contains(remote) ? GitAuthenticationMode.SILENT : GitAuthenticationMode.NONE;
    }

    private boolean shouldAvoidUserInteraction(@NotNull GitRemote remote) {
        return GitVcsSettings.getInstance(this.myProject).getIncomingCheckStrategy() == GitIncomingCheckStrategy.Auto && HAS_EXTERNAL_SSH_AGENT && GitBranchIncomingOutgoingManager.containsSSHUrl(remote);
    }

    private static boolean containsSSHUrl(@NotNull GitRemote remote) {
        return ContainerUtil.exists(remote.getUrls(), url -> !url.startsWith("http"));
    }

    @NotNull
    private Map<String, Hash> lsRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> branchRefNames, @NotNull GitAuthenticationMode authenticationMode) {
        HashMap<String, Hash> result2 = new HashMap<String, Hash>();
        if (!this.supportsIncomingOutgoing()) {
            return result2;
        }
        if (authenticationMode == GitAuthenticationMode.NONE || authenticationMode == GitAuthenticationMode.SILENT && this.shouldAvoidUserInteraction(remote)) {
            this.myErrorMap.putValue((Object)repository, (Object)remote);
            return result2;
        }
        VcsFileUtil.chunkArguments(branchRefNames).forEach(refs -> {
            ArrayList params = ContainerUtil.newArrayList((Object[])new String[]{"--heads", remote.getName()});
            params.addAll(refs);
            GitCommandResult lsRemoteResult = Git.getInstance().runCommand((Computable<? extends GitLineHandler>)((Computable)() -> this.createLsRemoteHandler(repository, remote, params, authenticationMode)));
            if (lsRemoteResult.success()) {
                Map hashWithNameMap = ContainerUtil.map2MapNotNull(lsRemoteResult.getOutput(), GitRefUtil::parseRefsLine);
                result2.putAll(GitRefUtil.getResolvedHashes(hashWithNameMap));
                this.myErrorMap.remove((Object)repository, (Object)remote);
                this.myAuthSuccessMap.putValue((Object)repository, (Object)remote);
            } else {
                this.myErrorMap.putValue((Object)repository, (Object)remote);
            }
        });
        return result2;
    }

    @NotNull
    private GitLineHandler createLsRemoteHandler(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> params, @NotNull GitAuthenticationMode authenticationMode) {
        GitLineHandler h2 = new GitLineHandler(this.myProject, repository.getRoot(), GitCommand.LS_REMOTE);
        h2.setIgnoreAuthenticationMode(authenticationMode);
        h2.addParameters(params);
        h2.setUrls(remote.getUrls());
        return h2;
    }

    @NotNull
    private Set<GitLocalBranch> calculateBranchesWithOutgoing(@NotNull GitRepository gitRepository) {
        HashSet<GitLocalBranch> branchesWithOutgoing = new HashSet<GitLocalBranch>();
        GitBranchesCollection branchesCollection = gitRepository.getBranches();
        for (GitLocalBranch branch : branchesCollection.getLocalBranches()) {
            Hash localHashForRemoteBranch;
            GitPushTarget pushTarget = GitPushSupport.getPushTargetIfExist(gitRepository, branch);
            Hash hash = localHashForRemoteBranch = pushTarget != null ? branchesCollection.getHash(pushTarget.getBranch()) : null;
            Hash localHash = branchesCollection.getHash(branch);
            if (!this.hasCommitsForBranch(gitRepository, branch, localHash, localHashForRemoteBranch, false)) continue;
            branchesWithOutgoing.add(branch);
        }
        return branchesWithOutgoing;
    }

    private boolean hasCommitsForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch localBranch, @Nullable Hash localBranchHash, @Nullable Hash localHashForRemoteBranch, boolean incoming) {
        if (!this.supportsIncomingOutgoing()) {
            return false;
        }
        if (localHashForRemoteBranch == null || Objects.equals(localBranchHash, localHashForRemoteBranch)) {
            return false;
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        handler.setSilent(true);
        String branchName = localBranch.getName();
        handler.addParameters("--count", incoming ? branchName + ".." + branchName + "@{u}" : localHashForRemoteBranch.asString() + ".." + branchName);
        try {
            String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]).trim();
            return !StringUtil.startsWithChar((CharSequence)output, (char)'0');
        }
        catch (VcsException e) {
            LOG.warn("Can't get outgoing info (git rev-list " + branchName + " failed):" + e.getMessage());
            return false;
        }
    }

    @NotNull
    private static Collection<GitLocalBranch> getBranches(@Nullable GitRepository repository, @NotNull Map<GitRepository, Set<GitLocalBranch>> branchCollection) {
        if (repository != null) {
            return (Collection)ObjectUtils.chooseNotNull(branchCollection.get(repository), Collections.emptySet());
        }
        return (Collection)StreamEx.of(branchCollection.values()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repositoryChanged(@NotNull GitRepository repository) {
        if (!GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposWithOutgoing.add(repository);
            this.myDirtyReposWithIncoming.add(repository);
        }
        this.scheduleUpdate();
    }

    @Override
    public void authenticationSucceeded(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (!this.shouldCheckIncoming()) {
            return;
        }
        this.myAuthSuccessMap.putValue((Object)repository, (Object)remote);
    }

    @NotNull
    private static MultiMap<GitRemote, GitBranchTrackInfo> groupTrackInfoByRemotes(@NotNull GitRepository repository) {
        return ContainerUtil.groupBy(repository.getBranchTrackInfos(), GitBranchTrackInfo::getRemote);
    }

    public static interface GitIncomingOutgoingListener {
        public void incomingOutgoingInfoChanged();
    }
}

