/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.annotate.AnnotationTooltipBuilder;
import git4idea.changes.GitCommittedChangeList;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.log.GitCommitTooltipLinkHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileAnnotation
extends FileAnnotation {
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final GitVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myBaseRevision;
    @NotNull
    private final List<LineInfo> myLines;
    @Nullable
    private List<VcsFileRevision> myRevisions;
    @Nullable
    private TObjectIntHashMap<VcsRevisionNumber> myRevisionMap;
    @NotNull
    private final Map<VcsRevisionNumber, String> myCommitMessageMap = new HashMap<VcsRevisionNumber, String>();
    private final VcsLogApplicationSettings myLogSettings = (VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class);
    private final LineAnnotationAspect DATE_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.DATE, true){

        @Override
        public String doGetValue(LineInfo info) {
            Date date = GitFileAnnotation.this.getDate(info);
            return FileAnnotation.formatDate((Date)date);
        }
    };
    private final LineAnnotationAspect REVISION_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.REVISION, false){

        @Override
        protected String doGetValue(LineInfo lineInfo) {
            return lineInfo.getRevisionNumber().getShortRev();
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

        @Override
        protected String doGetValue(LineInfo lineInfo) {
            return lineInfo.getAuthor();
        }
    };
    private final VcsLogUiProperties.PropertiesChangeListener myLogSettingChangeListener = this::onLogSettingChange;

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file, @Nullable VcsRevisionNumber revision, @NotNull List<LineInfo> lines) {
        super(project);
        this.myProject = project;
        this.myFile = file;
        this.myFilePath = VcsUtil.getFilePath((VirtualFile)file);
        this.myVcs = GitVcs.getInstance(this.myProject);
        this.myBaseRevision = revision;
        this.myLines = lines;
        this.myLogSettings.addChangeListener(this.myLogSettingChangeListener);
    }

    public <T> void onLogSettingChange(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (property.equals((Object)CommonUiProperties.PREFER_COMMIT_DATE)) {
            this.reload(null);
        }
    }

    public GitFileAnnotation(@NotNull GitFileAnnotation annotation) {
        this(annotation.getProject(), annotation.getFile(), annotation.getCurrentRevision(), annotation.getLines());
    }

    public void dispose() {
        this.myLogSettings.removeChangeListener(this.myLogSettingChangeListener);
    }

    public LineAnnotationAspect @NotNull [] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    @NotNull
    private Date getDate(LineInfo info) {
        return Boolean.TRUE.equals(this.myLogSettings.get(CommonUiProperties.PREFER_COMMIT_DATE)) ? info.getCommitterDate() : info.getAuthorDate();
    }

    @Nullable
    public String getAnnotatedContent() {
        try {
            ContentRevision revision = GitContentRevision.createRevision(this.myFilePath, this.myBaseRevision, this.myProject);
            return revision.getContent();
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public void setRevisions(@NotNull List<VcsFileRevision> revisions) {
        this.myRevisions = revisions;
        this.myRevisionMap = new TObjectIntHashMap();
        for (int i2 = 0; i2 < this.myRevisions.size(); ++i2) {
            this.myRevisionMap.put((Object)this.myRevisions.get(i2).getRevisionNumber(), i2);
        }
    }

    public void setCommitMessage(@NotNull VcsRevisionNumber revisionNumber, @NotNull String message) {
        this.myCommitMessageMap.put(revisionNumber, message);
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    @Nullable
    public LineInfo getLineInfo(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber);
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, false);
    }

    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, true);
    }

    @Nullable
    private String getToolTip(int lineNumber, boolean asHtml) {
        String commitMessage;
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        if (lineInfo == null) {
            return null;
        }
        AnnotationTooltipBuilder atb = new AnnotationTooltipBuilder(this.myProject, asHtml);
        GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
        atb.appendRevisionLine((VcsRevisionNumber)revisionNumber, it -> GitCommitTooltipLinkHandler.createLink(it.asString(), it));
        atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.author", (Object[])new Object[]{lineInfo.getAuthor()}));
        atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.date", (Object[])new Object[]{DateFormatUtil.formatDateTime((Date)this.getDate(lineInfo))}));
        if (!this.myFilePath.equals(lineInfo.getFilePath())) {
            String path = FileUtil.getLocationRelativeToUserHome((String)lineInfo.getFilePath().getPresentableUrl());
            atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.path", (Object[])new Object[]{path}));
        }
        if ((commitMessage = this.getCommitMessage((VcsRevisionNumber)revisionNumber)) == null) {
            commitMessage = lineInfo.getSubject() + "\n...";
        }
        atb.appendCommitMessageBlock(commitMessage);
        return atb.toString();
    }

    @Nullable
    public String getCommitMessage(@NotNull VcsRevisionNumber revisionNumber) {
        if (this.myRevisions != null && this.myRevisionMap != null && this.myRevisionMap.contains((Object)revisionNumber)) {
            VcsFileRevision fileRevision = this.myRevisions.get(this.myRevisionMap.get((Object)revisionNumber));
            return fileRevision.getCommitMessage();
        }
        return this.myCommitMessageMap.get(revisionNumber);
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getRevisionNumber() : null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? this.getDate(lineInfo) : null;
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    @NotNull
    public List<LineInfo> getLines() {
        return this.myLines;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(@NotNull VcsRevisionNumber number) {
        if (!this.myFile.isInLocalFileSystem()) {
            return false;
        }
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    @Nullable
    public FileAnnotation.CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return lineNumber -> {
            LineInfo lineInfo = this.getLineInfo(lineNumber);
            return lineInfo != null ? lineInfo.getFileRevision() : null;
        };
    }

    @Nullable
    public FileAnnotation.PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return new FileAnnotation.PreviousFileRevisionProvider(){

            @Nullable
            public VcsFileRevision getPreviousRevision(int lineNumber) {
                int index;
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
                if (lineInfo == null) {
                    return null;
                }
                VcsFileRevision previousFileRevision = lineInfo.getPreviousFileRevision();
                if (previousFileRevision != null) {
                    return previousFileRevision;
                }
                GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
                if (GitFileAnnotation.this.myRevisions != null && GitFileAnnotation.this.myRevisionMap != null && GitFileAnnotation.this.myRevisionMap.contains((Object)revisionNumber) && (index = GitFileAnnotation.this.myRevisionMap.get((Object)revisionNumber)) + 1 < GitFileAnnotation.this.myRevisions.size()) {
                    return (VcsFileRevision)GitFileAnnotation.this.myRevisions.get(index + 1);
                }
                return null;
            }

            @Nullable
            public VcsFileRevision getLastRevision() {
                if (GitFileAnnotation.this.myBaseRevision instanceof GitRevisionNumber) {
                    return new GitFileRevision(GitFileAnnotation.this.myProject, GitFileAnnotation.this.myFilePath, (GitRevisionNumber)GitFileAnnotation.this.myBaseRevision);
                }
                return (VcsFileRevision)ContainerUtil.getFirstItem(GitFileAnnotation.this.getRevisions());
            }
        };
    }

    @Nullable
    public FileAnnotation.AuthorsMappingProvider getAuthorsMappingProvider() {
        HashMap<GitRevisionNumber, String> authorsMap = new HashMap<GitRevisionNumber, String>();
        for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
            LineInfo lineInfo = this.getLineInfo(i2);
            if (lineInfo == null || authorsMap.containsKey(lineInfo.getRevisionNumber())) continue;
            authorsMap.put(lineInfo.getRevisionNumber(), lineInfo.getAuthor());
        }
        return () -> authorsMap;
    }

    @Nullable
    public FileAnnotation.RevisionsOrderProvider getRevisionsOrderProvider() {
        ContainerUtil.KeyOrderedMultiMap dates = new ContainerUtil.KeyOrderedMultiMap();
        for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
            LineInfo lineInfo = this.getLineInfo(i2);
            if (lineInfo == null) continue;
            GitRevisionNumber number = lineInfo.getRevisionNumber();
            Date date = lineInfo.getCommitterDate();
            dates.putValue((Object)date, (Object)number);
        }
        ArrayList orderedRevisions = new ArrayList();
        NavigableSet orderedDates = dates.navigableKeySet();
        for (Date date : orderedDates.descendingSet()) {
            Collection revisionNumbers = dates.get((Object)date);
            orderedRevisions.add(new ArrayList(revisionNumbers));
        }
        return () -> orderedRevisions;
    }

    @NotNull
    public FileAnnotation.RevisionChangesProvider getRevisionsChangesProvider() {
        return lineNumber -> {
            LineInfo lineInfo = this.getLineInfo(lineNumber);
            if (lineInfo == null) {
                return null;
            }
            GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(lineInfo.getFilePath());
            if (repository == null) {
                return null;
            }
            GitCommittedChangeList changeList = GitCommittedChangeListProvider.getCommittedChangeList(this.myProject, repository.getRoot(), lineInfo.getRevisionNumber());
            return Pair.create((Object)((Object)changeList), (Object)lineInfo.getFilePath());
        };
    }

    public static class LineInfo {
        @NotNull
        private final CommitInfo myCommitInfo;
        private final int myLineNumber;
        private final int myOriginalLineNumber;

        LineInfo(@NotNull CommitInfo commitInfo, int lineNumber, int originalLineNumber) {
            this.myCommitInfo = commitInfo;
            this.myLineNumber = lineNumber;
            this.myOriginalLineNumber = originalLineNumber;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getOriginalLineNumber() {
            return this.myOriginalLineNumber;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            return this.myCommitInfo.getRevisionNumber();
        }

        @NotNull
        public FilePath getFilePath() {
            return this.myCommitInfo.getFilePath();
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            return this.myCommitInfo.getFileRevision();
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            return this.myCommitInfo.getPreviousFileRevision();
        }

        @NotNull
        public Date getCommitterDate() {
            return this.myCommitInfo.getCommitterDate();
        }

        @NotNull
        public Date getAuthorDate() {
            return this.myCommitInfo.getAuthorDate();
        }

        @NotNull
        public String getAuthor() {
            return this.myCommitInfo.getAuthor();
        }

        @NotNull
        public String getSubject() {
            return this.myCommitInfo.getSubject();
        }
    }

    static class CommitInfo {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRevisionNumber myRevision;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        private final GitRevisionNumber myPreviousRevision;
        @Nullable
        private final FilePath myPreviousFilePath;
        @NotNull
        private final Date myCommitterDate;
        @NotNull
        private final Date myAuthorDate;
        @NotNull
        private final VcsUser myAuthor;
        @NotNull
        private final String mySubject;

        CommitInfo(@NotNull Project project, @NotNull GitRevisionNumber revision, @NotNull FilePath path, @NotNull Date committerDate, @NotNull Date authorDate, @NotNull VcsUser author, @NotNull String subject, @Nullable GitRevisionNumber previousRevision, @Nullable FilePath previousPath) {
            this.myProject = project;
            this.myRevision = revision;
            this.myFilePath = path;
            this.myPreviousRevision = previousRevision;
            this.myPreviousFilePath = previousPath;
            this.myCommitterDate = committerDate;
            this.myAuthorDate = authorDate;
            this.myAuthor = author;
            this.mySubject = subject;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            return this.myRevision;
        }

        @NotNull
        public FilePath getFilePath() {
            return this.myFilePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            return new GitFileRevision(this.myProject, this.myFilePath, this.myRevision);
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            if (this.myPreviousRevision == null || this.myPreviousFilePath == null) {
                return null;
            }
            return new GitFileRevision(this.myProject, this.myPreviousFilePath, this.myPreviousRevision);
        }

        @NotNull
        public Date getCommitterDate() {
            return this.myCommitterDate;
        }

        @NotNull
        public Date getAuthorDate() {
            return this.myAuthorDate;
        }

        @NotNull
        public String getAuthor() {
            return this.myAuthor.getName();
        }

        @NotNull
        public String getSubject() {
            return this.mySubject;
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        GitAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                LineInfo info = (LineInfo)GitFileAnnotation.this.myLines.get(lineNum);
                AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevisionNumber(), (FilePath)GitFileAnnotation.this.myFilePath, () -> GitFileAnnotation.this.getRevisionsChangesProvider().getChangesIn(lineNum));
            }
        }
    }
}

