/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.actions.GitOperationActionBase;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.NotNull;

public abstract class GitAbstractRebaseAction
extends GitOperationActionBase {
    protected GitAbstractRebaseAction() {
        super(Repository.State.REBASING);
    }

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (GitUtil.getRepositoryManager(project).hasOngoingRebase()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, this.getProgressTitle()){

                public void run(@NotNull ProgressIndicator indicator) {
                    GitAbstractRebaseAction.this.performActionForProject(project, indicator);
                }
            });
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void performInBackground(final @NotNull GitRepository repositoryToOperate) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(repositoryToOperate.getProject(), this.getProgressTitle()){

            public void run(@NotNull ProgressIndicator indicator) {
                GitAbstractRebaseAction.this.performActionForRepository(repositoryToOperate.getProject(), repositoryToOperate, indicator);
            }
        });
    }

    @Override
    @NotNull
    protected String getOperationName() {
        return "rebase";
    }

    @NotNull
    protected abstract String getProgressTitle();

    protected abstract void performActionForProject(@NotNull Project var1, @NotNull ProgressIndicator var2);

    protected abstract void performActionForRepository(@NotNull Project var1, @NotNull GitRepository var2, @NotNull ProgressIndicator var3);
}

