/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.ide.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.parcelize.Parceler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parcelize.ParcelizeDeclarationCheckerKt;
import org.jetbrains.kotlin.parcelize.ide.KotlinParcelizeBundle;
import org.jetbrains.kotlin.parcelize.ide.quickfixes.AbstractParcelizeQuickFix;
import org.jetbrains.kotlin.parcelize.ide.quickfixes.ParcelMigrateToParcelizeQuickFix;
import org.jetbrains.kotlin.parcelize.ide.quickfixes.ParcelMigrateToParcelizeQuickFix$Companion$findCreatorClass$;
import org.jetbrains.kotlin.parcelize.ide.quickfixes.ParcelMigrateToParcelizeQuickFix$Companion$findFunction$;
import org.jetbrains.kotlin.parcelize.ide.quickfixes.ParcelMigrateToParcelizeQuickFix$invoke$;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\f\r\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/parcelize/ide/quickfixes/ParcelMigrateToParcelizeQuickFix;", "Lorg/jetbrains/kotlin/parcelize/ide/quickfixes/AbstractParcelizeQuickFix;", "Lorg/jetbrains/kotlin/psi/KtClass;", "function", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getText", "", "invoke", "", "ktPsiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "parcelableClass", "Companion", "FactoryForCREATOR", "FactoryForWrite", "kotlin.compiler-plugins.parcelize"})
public final class ParcelMigrateToParcelizeQuickFix
extends AbstractParcelizeQuickFix<KtClass> {
    private static final FqName PARCELER_FQNAME;
    private static final Name PARCELER_WRITE_FUNCTION_NAME;
    private static final Name PARCELER_CREATE_FUNCTION_NAME;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return KotlinParcelizeBundle.message("parcelize.fix.migrate.to.parceler.companion.object", new Object[0]);
    }

    @Override
    public void invoke(@NotNull KtPsiFactory ktPsiFactory, @NotNull KtClass parcelableClass) {
        Unit unit;
        Unit unit2;
        Object createFunction;
        PsiElement anchor$iv3;
        PsiElement anchor$iv22;
        KtClassOrObject this_$iv;
        boolean bl;
        String parcelParameterName;
        int n;
        KtFunction newFunction;
        KtNamedFunction ktNamedFunction;
        boolean bl2;
        String parcelerTypeArg;
        BindingContext bindingContext;
        Pair parcelerObject;
        block61: {
            Intrinsics.checkNotNullParameter((Object)ktPsiFactory, (String)"ktPsiFactory");
            Intrinsics.checkNotNullParameter((Object)parcelableClass, (String)"parcelableClass");
            Pair pair = ParcelMigrateToParcelizeQuickFix.Companion.findParcelerCompanionObject(parcelableClass);
            if (pair == null || (pair = (KtObjectDeclaration)pair.getFirst()) == null) {
                pair = PsiModificationUtilsKt.getOrCreateCompanionObject((KtClass)parcelableClass);
            }
            parcelerObject = pair;
            bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)parcelerObject), (BodyResolveMode)BodyResolveMode.PARTIAL);
            String string = parcelableClass.getName();
            if (string == null) {
                ParcelMigrateToParcelizeQuickFix parcelMigrateToParcelizeQuickFix = this;
                boolean bl3 = false;
                boolean bl4 = false;
                ParcelMigrateToParcelizeQuickFix $this$run = parcelMigrateToParcelizeQuickFix;
                boolean bl5 = false;
                LOG.error("Parceler class should not be an anonymous class");
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parcelableClass.name ?: \u2026         return\n        }");
            parcelerTypeArg = string;
            ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)parcelerObject);
            if (classDescriptor == null) {
                ParcelMigrateToParcelizeQuickFix parcelMigrateToParcelizeQuickFix = this;
                boolean bl6 = false;
                boolean $this$run = false;
                ParcelMigrateToParcelizeQuickFix $this$run2 = parcelMigrateToParcelizeQuickFix;
                boolean bl7 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Unable to resolve parceler object for ");
                String string2 = parcelableClass.getName();
                if (string2 == null) {
                    string2 = "<unnamed Parcelable class>";
                }
                LOG.error(stringBuilder.append(string2).toString());
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"bindingContext[BindingCo\u2026         return\n        }");
            ClassDescriptor parcelerObjectDescriptor = classDescriptor;
            Sequence $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)parcelerObjectDescriptor));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ClassifierDescriptor it = (ClassifierDescriptor)element$iv;
                boolean bl8 = false;
                if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)), (Object)PARCELER_FQNAME)) continue;
                bl2 = true;
                break block61;
            }
            bl2 = false;
        }
        if (!bl2) {
            String entryText = PARCELER_FQNAME.asString() + "<" + parcelerTypeArg + ">";
            AbstractParcelizeQuickFix.Companion.shortenReferences((KtElement)parcelerObject.addSuperTypeListEntry((KtSuperTypeListEntry)ktPsiFactory.createSuperTypeEntry(entryText)));
        }
        KtNamedFunction oldWriteToParcelFunction = ParcelMigrateToParcelizeQuickFix.Companion.findWriteToParcelOverride(parcelableClass);
        KtClassOrObject ktClassOrObject = ParcelMigrateToParcelizeQuickFix.Companion.findCreatorClass(parcelableClass);
        if (ktClassOrObject != null) {
            Iterator $this$run = ktClassOrObject;
            boolean element$iv = false;
            boolean it = false;
            Iterator it2 = $this$run;
            boolean bl9 = false;
            ktNamedFunction = ParcelMigrateToParcelizeQuickFix.Companion.findCreateFromParcel((KtClassOrObject)it2);
        } else {
            ktNamedFunction = null;
        }
        KtNamedFunction oldCreateFromParcelFunction = ktNamedFunction;
        for (KtSuperTypeListEntry superTypeEntry : parcelerObject.getSuperTypeListEntries()) {
            boolean bl10;
            block62: {
                KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)superTypeEntry.getTypeReference());
                if (kotlinType == null || (kotlinType = kotlinType.getConstructor()) == null || (kotlinType = kotlinType.getDeclarationDescriptor()) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"bindingContext[BindingCo\u2026ionDescriptor ?: continue");
                KotlinType superClass = kotlinType;
                Sequence $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)superClass);
                boolean $i$f$any = false;
                for (Object element$iv2 : $this$any$iv) {
                    ClassifierDescriptor it = (ClassifierDescriptor)element$iv2;
                    boolean bl11 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)), (Object)ParcelizeDeclarationCheckerKt.getANDROID_PARCELABLE_CREATOR_CLASS_FQNAME())) continue;
                    bl10 = true;
                    break block62;
                }
                bl10 = false;
            }
            if (!bl10) continue;
            parcelerObject.removeSuperTypeListEntry(superTypeEntry);
        }
        if (Intrinsics.areEqual((Object)parcelerObject.getName(), (Object)"CREATOR")) {
            Unit unit3;
            PsiElement psiElement = parcelerObject.getNameIdentifier();
            if (psiElement != null) {
                psiElement.delete();
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = null;
            }
        }
        if (oldWriteToParcelFunction != null) {
            PsiElement psiElement;
            KtParameterList ktParameterList;
            Unit unit4;
            KtNamedFunction ktNamedFunction2 = ParcelMigrateToParcelizeQuickFix.Companion.findWriteImplementation((KtObjectDeclaration)parcelerObject);
            if (ktNamedFunction2 != null) {
                ktNamedFunction2.delete();
                unit4 = Unit.INSTANCE;
            } else {
                unit4 = null;
            }
            PsiElement psiElement2 = oldWriteToParcelFunction.copy();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            newFunction = (KtFunction)psiElement2;
            oldWriteToParcelFunction.delete();
            newFunction.setName(PARCELER_WRITE_FUNCTION_NAME.asString());
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)newFunction;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.OVERRIDE_KEYWORD");
            AddRemoveModifierKt.setModifierList((KtModifierListOwner)ktModifierListOwner, (KtModifierList)ktPsiFactory.createModifierList(ktModifierKeywordToken));
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)newFunction), (KtTypeReference)ktPsiFactory.createType(parcelerTypeArg));
            KtParameterList ktParameterList2 = newFunction.getValueParameterList();
            if (ktParameterList2 != null) {
                KtParameterList element$iv = ktParameterList2;
                boolean superClass = false;
                boolean $this$any$iv = false;
                KtParameterList $this$apply = element$iv;
                boolean bl12 = false;
                boolean element$iv2 = $this$apply.getParameters().size() == 2;
                boolean it = false;
                n = 0;
                if (_Assertions.ENABLED && !element$iv2) {
                    boolean bl13 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Object e = $this$apply.getParameters().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"parameters[0]");
                String string = ((KtParameter)e).getName();
                if (string == null) {
                    string = "parcel";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters[0].name ?: \"parcel\"");
                parcelParameterName = string;
                Object e2 = $this$apply.getParameters().get(1);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"parameters[1]");
                String string3 = ((KtParameter)e2).getName();
                if (string3 == null) {
                    string3 = "flags";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters[1].name ?: \"flags\"");
                String flagsParameterName = string3;
                n = $this$apply.getParameters().size();
                bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it3 = n2++;
                    boolean bl14 = false;
                    $this$apply.removeParameter(0);
                }
                $this$apply.addParameter(ktPsiFactory.createParameter(parcelParameterName + " : " + ParcelizeDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString()));
                $this$apply.addParameter(ktPsiFactory.createParameter(flagsParameterName + " : Int"));
                ktParameterList = element$iv;
            } else {
                ktParameterList = null;
            }
            this_$iv = (KtClassOrObject)parcelerObject;
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement $this$apply = body$iv.getRBrace();
            if ($this$apply == null) {
                PsiElement bl12 = body$iv.getLastChild();
                Intrinsics.checkNotNull((Object)bl12);
                psiElement = bl12;
            } else {
                psiElement = $this$apply;
            }
            $this$apply = new PsiElement[]{PsiWhiteSpace.class};
            anchor$iv22 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])$this$apply);
            PsiElement psiElement3 = body$iv.addAfter((PsiElement)((KtDeclaration)newFunction), anchor$iv22);
            if (psiElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtParameterList ktParameterList3 = ((KtFunction)((KtDeclaration)((KtFunction)psiElement3))).getValueParameterList();
            KtElement ktElement = ktParameterList3 != null ? AbstractParcelizeQuickFix.Companion.shortenReferences((KtElement)ktParameterList3) : null;
        } else if (ParcelMigrateToParcelizeQuickFix.Companion.findWriteImplementation((KtObjectDeclaration)parcelerObject) == null) {
            PsiElement psiElement;
            String writeFunction = "fun " + parcelerTypeArg + ".write(parcel: " + ParcelizeDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString() + ", flags: Int) = TODO()";
            this_$iv = (KtClassOrObject)parcelerObject;
            KtDeclaration declaration$iv = (KtDeclaration)ktPsiFactory.createFunction(writeFunction);
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement bl12 = body$iv.getRBrace();
            if (bl12 == null) {
                anchor$iv22 = body$iv.getLastChild();
                Intrinsics.checkNotNull((Object)anchor$iv22);
                psiElement = anchor$iv22;
            } else {
                psiElement = bl12;
            }
            bl12 = new PsiElement[]{PsiWhiteSpace.class};
            anchor$iv3 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])bl12);
            PsiElement psiElement4 = body$iv.addAfter((PsiElement)declaration$iv, anchor$iv3);
            if (psiElement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtParameterList ktParameterList = ((KtNamedFunction)((KtDeclaration)((KtNamedFunction)psiElement4))).getValueParameterList();
            KtElement ktElement = ktParameterList != null ? AbstractParcelizeQuickFix.Companion.shortenReferences((KtElement)ktParameterList) : null;
        }
        if (oldCreateFromParcelFunction != null) {
            PsiElement psiElement;
            KtClassOrObject ktClassOrObject2;
            Unit unit5;
            KtNamedFunction ktNamedFunction3 = ParcelMigrateToParcelizeQuickFix.Companion.findCreateImplementation((KtObjectDeclaration)parcelerObject);
            if (ktNamedFunction3 != null) {
                ktNamedFunction3.delete();
                unit5 = Unit.INSTANCE;
            } else {
                unit5 = null;
            }
            PsiElement psiElement5 = oldCreateFromParcelFunction.copy();
            if (psiElement5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            newFunction = (KtFunction)psiElement5;
            if (Intrinsics.areEqual((Object)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)oldCreateFromParcelFunction)), (Object)parcelerObject)) {
                oldCreateFromParcelFunction.delete();
            }
            newFunction.setName(PARCELER_CREATE_FUNCTION_NAME.asString());
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)newFunction;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.OVERRIDE_KEYWORD");
            AddRemoveModifierKt.setModifierList((KtModifierListOwner)ktModifierListOwner, (KtModifierList)ktPsiFactory.createModifierList(ktModifierKeywordToken));
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)newFunction), null);
            KtParameterList ktParameterList = newFunction.getValueParameterList();
            if (ktParameterList != null) {
                this_$iv = ktParameterList;
                boolean declaration$iv = false;
                boolean $i$f$addDeclaration = false;
                KtClassOrObject $this$apply = this_$iv;
                boolean bl15 = false;
                boolean anchor$iv22 = $this$apply.getParameters().size() == 1;
                boolean anchor$iv3 = false;
                n = 0;
                if (_Assertions.ENABLED && !anchor$iv22) {
                    bl = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Object e = $this$apply.getParameters().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"parameters[0]");
                String string = ((KtParameter)e).getName();
                if (string == null) {
                    string = "parcel";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters[0].name ?: \"parcel\"");
                parcelParameterName = string;
                $this$apply.removeParameter(0);
                $this$apply.addParameter(ktPsiFactory.createParameter(parcelParameterName + " : " + ParcelizeDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString()));
                ktClassOrObject2 = this_$iv;
            } else {
                ktClassOrObject2 = null;
            }
            this_$iv = (KtClassOrObject)parcelerObject;
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement $this$apply = body$iv.getRBrace();
            if ($this$apply == null) {
                PsiElement bl15 = body$iv.getLastChild();
                Intrinsics.checkNotNull((Object)bl15);
                psiElement = bl15;
            } else {
                psiElement = $this$apply;
            }
            $this$apply = new PsiElement[]{PsiWhiteSpace.class};
            anchor$iv22 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])$this$apply);
            PsiElement psiElement6 = body$iv.addAfter((PsiElement)((KtDeclaration)newFunction), anchor$iv22);
            if (psiElement6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtParameterList ktParameterList4 = ((KtFunction)((KtDeclaration)((KtFunction)psiElement6))).getValueParameterList();
            KtElement ktElement = ktParameterList4 != null ? AbstractParcelizeQuickFix.Companion.shortenReferences((KtElement)ktParameterList4) : null;
        } else if (ParcelMigrateToParcelizeQuickFix.Companion.findCreateImplementation((KtObjectDeclaration)parcelerObject) == null) {
            PsiElement psiElement;
            createFunction = "override fun create(parcel: " + ParcelizeDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString() + "): " + parcelerTypeArg + " = TODO()";
            this_$iv = (KtClassOrObject)parcelerObject;
            KtDeclaration declaration$iv = (KtDeclaration)ktPsiFactory.createFunction((String)createFunction);
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement bl15 = body$iv.getRBrace();
            if (bl15 == null) {
                anchor$iv22 = body$iv.getLastChild();
                Intrinsics.checkNotNull((Object)anchor$iv22);
                psiElement = anchor$iv22;
            } else {
                psiElement = bl15;
            }
            bl15 = new PsiElement[]{PsiWhiteSpace.class};
            anchor$iv3 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])bl15);
            PsiElement psiElement7 = body$iv.addAfter((PsiElement)declaration$iv, anchor$iv3);
            if (psiElement7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtParameterList ktParameterList = ((KtNamedFunction)((KtDeclaration)((KtNamedFunction)psiElement7))).getValueParameterList();
            KtElement ktElement = ktParameterList != null ? AbstractParcelizeQuickFix.Companion.shortenReferences((KtElement)ktParameterList) : null;
        }
        KtNamedFunction ktNamedFunction4 = ParcelMigrateToParcelizeQuickFix.Companion.findNewArrayOverride((KtObjectDeclaration)parcelerObject);
        if (ktNamedFunction4 != null) {
            ktNamedFunction4.delete();
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        KtNamedFunction ktNamedFunction5 = ParcelMigrateToParcelizeQuickFix.Companion.findDescribeContentsOverride(parcelableClass);
        if (ktNamedFunction5 != null) {
            KtExpression returnExpr;
            createFunction = ktNamedFunction5;
            boolean bl16 = false;
            boolean declaration$iv = false;
            Object describeContentsFunction = createFunction;
            boolean bl17 = false;
            KtExpression ktExpression = describeContentsFunction.getBodyExpression();
            Object object = returnExpr = ktExpression != null ? IfThenUtilsKt.unwrapBlockOrParenthesis((KtExpression)ktExpression) : null;
            if (returnExpr instanceof KtReturnExpression && ((KtReturnExpression)returnExpr).getTargetLabel() == null) {
                Object returnValue;
                Object object2;
                CompileTimeConstant compileTimeConstant = (CompileTimeConstant)ResolutionUtils.analyze$default((KtElement)((KtElement)returnExpr), null, (int)1, null).get((ReadOnlySlice)BindingContext.COMPILE_TIME_VALUE, (Object)((KtReturnExpression)returnExpr).getReturnedExpression());
                if (compileTimeConstant != null) {
                    SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"TypeUtils.NO_EXPECTED_TYPE");
                    object2 = compileTimeConstant.getValue((KotlinType)simpleType);
                } else {
                    object2 = returnValue = null;
                }
                if (Intrinsics.areEqual((Object)returnValue, (Object)0)) {
                    Object object3 = (SimpleFunctionDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, describeContentsFunction);
                    if (object3 != null && (object3 = object3.getOverriddenDescriptors()) != null) {
                        if (object3.size() == 1) {
                            describeContentsFunction.delete();
                        }
                    }
                }
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)parcelerObject.getDeclarations());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)invoke$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        for (KtProperty property : SequencesKt.filter((Sequence)sequence, (Function1)invoke.6.INSTANCE)) {
            if (ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)property), (FqName)JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME) == null) continue;
            property.delete();
        }
    }

    public ParcelMigrateToParcelizeQuickFix(@NotNull KtClass function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super((KtElement)function);
    }

    static {
        Companion = new Companion(null);
        PARCELER_FQNAME = new FqName(Parceler.class.getName());
        Name name = Name.identifier((String)"write");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"write\")");
        PARCELER_WRITE_FUNCTION_NAME = name;
        Name name2 = Name.identifier((String)"create");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"create\")");
        PARCELER_CREATE_FUNCTION_NAME = name2;
        Logger logger = Logger.getInstance(ParcelMigrateToParcelizeQuickFix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Parce\u2026lizeQuickFix::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/parcelize/ide/quickfixes/ParcelMigrateToParcelizeQuickFix$FactoryForWrite;", "Lorg/jetbrains/kotlin/parcelize/ide/quickfixes/AbstractParcelizeQuickFix$AbstractFactory;", "()V", "kotlin.compiler-plugins.parcelize"})
    public static final class FactoryForWrite
    extends AbstractParcelizeQuickFix.AbstractFactory {
        @NotNull
        public static final FactoryForWrite INSTANCE;

        private FactoryForWrite() {
            super((Function1<? super Diagnostic, ? extends IntentionAction>)((Function1)1.INSTANCE));
        }

        static {
            FactoryForWrite factoryForWrite;
            INSTANCE = factoryForWrite = new FactoryForWrite();
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/parcelize/ide/quickfixes/ParcelMigrateToParcelizeQuickFix$FactoryForCREATOR;", "Lorg/jetbrains/kotlin/parcelize/ide/quickfixes/AbstractParcelizeQuickFix$AbstractFactory;", "()V", "kotlin.compiler-plugins.parcelize"})
    public static final class FactoryForCREATOR
    extends AbstractParcelizeQuickFix.AbstractFactory {
        @NotNull
        public static final FactoryForCREATOR INSTANCE;

        private FactoryForCREATOR() {
            super((Function1<? super Diagnostic, ? extends IntentionAction>)((Function1)1.INSTANCE));
        }

        static {
            FactoryForCREATOR factoryForCREATOR;
            INSTANCE = factoryForCREATOR = new FactoryForCREATOR();
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0013\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0014\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0015\u001a\u00020\u0010*\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u000e*\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\f*\u00020\u0019H\u0002J'\u0010\u001b\u001a\u0004\u0018\u00010\f*\u00020\u000e2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u001d\u00a2\u0006\u0002\b\u001eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u001a\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"\u0018\u00010!*\u00020\u0019H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010\f*\u00020\u0019H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010&*\u00020'H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/parcelize/ide/quickfixes/ParcelMigrateToParcelizeQuickFix$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PARCELER_CREATE_FUNCTION_NAME", "Lorg/jetbrains/kotlin/name/Name;", "PARCELER_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "PARCELER_WRITE_FUNCTION_NAME", "findCreateFromParcel", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "creator", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "doesLookLikeCreateFromParcelOverride", "", "doesLookLikeCreateImplementation", "doesLookLikeDescribeContentsOverride", "doesLookLikeNewArrayOverride", "doesLookLikeWriteImplementation", "doesLookLikeWriteToParcelOverride", "findCreateImplementation", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "findCreatorClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "findDescribeContentsOverride", "findFunction", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "findNewArrayOverride", "findParcelerCompanionObject", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findWriteImplementation", "findWriteToParcelOverride", "getFqName", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin.compiler-plugins.parcelize"})
    public static final class Companion {
        private final Pair<KtObjectDeclaration, ClassDescriptor> findParcelerCompanionObject(KtClass $this$findParcelerCompanionObject) {
            for (KtObjectDeclaration obj : $this$findParcelerCompanionObject.getCompanionObjects()) {
                ClassDescriptor objDescriptor;
                if (ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)((KtClassOrObject)obj), null, (int)1, null) == null) {
                    continue;
                }
                for (ClassifierDescriptor superClassifier : DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)objDescriptor))) {
                    ClassDescriptor superClass;
                    ClassifierDescriptor classifierDescriptor = superClassifier;
                    if (!(classifierDescriptor instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    if ((ClassDescriptor)classifierDescriptor == null) {
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)superClass)), (Object)PARCELER_FQNAME)) continue;
                    return new Pair((Object)obj, (Object)objDescriptor);
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeWriteToParcelOverride(KtNamedFunction $this$doesLookLikeWriteToParcelOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeWriteToParcelOverride.getName(), (Object)"writeToParcel")) return false;
            if (!$this$doesLookLikeWriteToParcelOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getValueParameters().size() != 2) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeWriteToParcelOverride.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelizeDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            Object e2 = $this$doesLookLikeWriteToParcelOverride.getValueParameters().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valueParameters[1]");
            KtTypeReference ktTypeReference2 = ((KtParameter)e2).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference2 != null ? this.getFqName(ktTypeReference2) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeNewArrayOverride(KtNamedFunction $this$doesLookLikeNewArrayOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeNewArrayOverride.getName(), (Object)"newArray")) return false;
            if (!$this$doesLookLikeNewArrayOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeNewArrayOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeNewArrayOverride.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeNewArrayOverride.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeNewArrayOverride.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeDescribeContentsOverride(KtNamedFunction $this$doesLookLikeDescribeContentsOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeDescribeContentsOverride.getName(), (Object)"describeContents")) return false;
            if (!$this$doesLookLikeDescribeContentsOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getValueParameters().size() != 0) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference = $this$doesLookLikeDescribeContentsOverride.getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        private final KtNamedFunction findWriteToParcelOverride(KtClass $this$findWriteToParcelOverride) {
            return this.findFunction((KtClassOrObject)$this$findWriteToParcelOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findWriteToParcelOverride.1.INSTANCE));
        }

        private final KtNamedFunction findDescribeContentsOverride(KtClass $this$findDescribeContentsOverride) {
            return this.findFunction((KtClassOrObject)$this$findDescribeContentsOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findDescribeContentsOverride.1.INSTANCE));
        }

        private final KtNamedFunction findNewArrayOverride(KtObjectDeclaration $this$findNewArrayOverride) {
            return this.findFunction((KtClassOrObject)$this$findNewArrayOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findNewArrayOverride.1.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        private final KtClassOrObject findCreatorClass(KtClass $this$findCreatorClass) {
            for (KtObjectDeclaration companion : $this$findCreatorClass.getCompanionObjects()) {
                KotlinSourceElement sourceElement;
                KtExpression initializer;
                KtProperty creatorProperty;
                Object v0;
                block11: {
                    void $this$firstOrNull$iv;
                    Sequence $this$filterIsInstance$iv;
                    if (Intrinsics.areEqual((Object)companion.getName(), (Object)"CREATOR")) {
                        return (KtClassOrObject)companion;
                    }
                    Sequence sequence = CollectionsKt.asSequence((Iterable)companion.getDeclarations());
                    boolean $i$f$filterIsInstance = false;
                    if (SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$findCreatorClass$$inlined$filterIsInstance$1.INSTANCE) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtProperty it = (KtProperty)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"CREATOR")) continue;
                        v0 = element$iv;
                        break block11;
                    }
                    v0 = null;
                }
                if ((KtProperty)v0 == null) {
                    continue;
                }
                if (ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)creatorProperty), (FqName)JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME) == null) {
                    continue;
                }
                if (creatorProperty.getInitializer() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)initializer, (String)"creatorProperty.initializer ?: continue");
                KtExpression ktExpression = initializer;
                if (ktExpression instanceof KtObjectLiteralExpression) {
                    return (KtClassOrObject)((KtObjectLiteralExpression)initializer).getObjectDeclaration();
                }
                if (!(ktExpression instanceof KtCallExpression)) continue;
                ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)initializer), null, (int)1, null);
                Object object = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
                if (!(object instanceof ConstructorDescriptor)) {
                    object = null;
                }
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)object;
                Object constructedClass = constructorDescriptor != null ? constructorDescriptor.getConstructedClass() : null;
                if (constructedClass == null) continue;
                SourceElement sourceElement2 = constructedClass.getSource();
                if (!(sourceElement2 instanceof KotlinSourceElement)) {
                    sourceElement2 = null;
                }
                KotlinSourceElement kotlinSourceElement = sourceElement = (KotlinSourceElement)sourceElement2;
                Object object2 = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
                if (!(object2 instanceof KtClassOrObject)) {
                    object2 = null;
                }
                KtClassOrObject ktClassOrObject = (KtClassOrObject)object2;
                if (ktClassOrObject == null) continue;
                KtClassOrObject ktClassOrObject2 = ktClassOrObject;
                boolean bl = false;
                boolean bl2 = false;
                KtClassOrObject it = ktClassOrObject2;
                boolean bl3 = false;
                return it;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeCreateFromParcelOverride(KtNamedFunction $this$doesLookLikeCreateFromParcelOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeCreateFromParcelOverride.getName(), (Object)"createFromParcel")) return false;
            if (!$this$doesLookLikeCreateFromParcelOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeCreateFromParcelOverride.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelizeDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            return true;
        }

        private final KtNamedFunction findCreateFromParcel(KtClassOrObject creator) {
            return this.findFunction(creator, (Function1<? super KtNamedFunction, Boolean>)((Function1)findCreateFromParcel.1.INSTANCE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeWriteImplementation(KtNamedFunction $this$doesLookLikeWriteImplementation) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$doesLookLikeWriteImplementation));
            String containingParcelableClassFqName = ktClassOrObject != null && (ktClassOrObject = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktClassOrObject))) != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null;
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeWriteImplementation.getName(), (Object)PARCELER_WRITE_FUNCTION_NAME.asString())) return false;
            if (!$this$doesLookLikeWriteImplementation.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            KtTypeReference ktTypeReference = $this$doesLookLikeWriteImplementation.getReceiverTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)containingParcelableClassFqName)) return false;
            if ($this$doesLookLikeWriteImplementation.getValueParameters().size() != 2) return false;
            if ($this$doesLookLikeWriteImplementation.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeWriteImplementation.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference2 = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference2 != null ? this.getFqName(ktTypeReference2) : null), (Object)ParcelizeDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            Object e2 = $this$doesLookLikeWriteImplementation.getValueParameters().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valueParameters[1]");
            KtTypeReference ktTypeReference3 = ((KtParameter)e2).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference3 != null ? this.getFqName(ktTypeReference3) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeCreateImplementation(KtNamedFunction $this$doesLookLikeCreateImplementation) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeCreateImplementation.getName(), (Object)PARCELER_CREATE_FUNCTION_NAME.asString())) return false;
            if (!$this$doesLookLikeCreateImplementation.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeCreateImplementation.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeCreateImplementation.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeCreateImplementation.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeCreateImplementation.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelizeDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            return true;
        }

        private final KtNamedFunction findCreateImplementation(KtObjectDeclaration $this$findCreateImplementation) {
            return this.findFunction((KtClassOrObject)$this$findCreateImplementation, (Function1<? super KtNamedFunction, Boolean>)((Function1)findCreateImplementation.1.INSTANCE));
        }

        private final KtNamedFunction findWriteImplementation(KtObjectDeclaration $this$findWriteImplementation) {
            return this.findFunction((KtClassOrObject)$this$findWriteImplementation, (Function1<? super KtNamedFunction, Boolean>)((Function1)findWriteImplementation.1.INSTANCE));
        }

        private final KtNamedFunction findFunction(KtClassOrObject $this$findFunction, Function1<? super KtNamedFunction, Boolean> f) {
            Object v1;
            block2: {
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)$this$findFunction.getDeclarations());
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$findFunction$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                Sequence $this$firstOrNull$iv = sequence;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    if (!((Boolean)f.invoke(element$iv)).booleanValue()) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            return v1;
        }

        private final String getFqName(KtTypeReference $this$getFqName) {
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)$this$getFqName), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)$this$getFqName);
            return kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null && (kotlinType = kotlinType.getDeclarationDescriptor()) != null && (kotlinType = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)kotlinType))) != null ? kotlinType.asString() : null;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$doesLookLikeWriteToParcelOverride(Companion $this, KtNamedFunction $this$access_u24doesLookLikeWriteToParcelOverride) {
            return $this.doesLookLikeWriteToParcelOverride($this$access_u24doesLookLikeWriteToParcelOverride);
        }

        public static final /* synthetic */ boolean access$doesLookLikeDescribeContentsOverride(Companion $this, KtNamedFunction $this$access_u24doesLookLikeDescribeContentsOverride) {
            return $this.doesLookLikeDescribeContentsOverride($this$access_u24doesLookLikeDescribeContentsOverride);
        }

        public static final /* synthetic */ boolean access$doesLookLikeNewArrayOverride(Companion $this, KtNamedFunction $this$access_u24doesLookLikeNewArrayOverride) {
            return $this.doesLookLikeNewArrayOverride($this$access_u24doesLookLikeNewArrayOverride);
        }

        public static final /* synthetic */ boolean access$doesLookLikeCreateFromParcelOverride(Companion $this, KtNamedFunction $this$access_u24doesLookLikeCreateFromParcelOverride) {
            return $this.doesLookLikeCreateFromParcelOverride($this$access_u24doesLookLikeCreateFromParcelOverride);
        }

        public static final /* synthetic */ boolean access$doesLookLikeCreateImplementation(Companion $this, KtNamedFunction $this$access_u24doesLookLikeCreateImplementation) {
            return $this.doesLookLikeCreateImplementation($this$access_u24doesLookLikeCreateImplementation);
        }

        public static final /* synthetic */ boolean access$doesLookLikeWriteImplementation(Companion $this, KtNamedFunction $this$access_u24doesLookLikeWriteImplementation) {
            return $this.doesLookLikeWriteImplementation($this$access_u24doesLookLikeWriteImplementation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

