/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.windows;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.Crypt32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinCrypt;
import org.jetbrains.annotations.NotNull;

public final class WindowsCryptUtils {
    private WindowsCryptUtils() {
    }

    public static byte @NotNull [] protect(byte @NotNull [] data) {
        if (data.length == 0) {
            return data;
        }
        WinCrypt.DATA_BLOB in = WindowsCryptUtils.prepareInput(data);
        WinCrypt.DATA_BLOB.ByReference out = new WinCrypt.DATA_BLOB.ByReference();
        boolean rc = Crypt32.INSTANCE.CryptProtectData(in, "Master Key", null, null, null, 0, (WinCrypt.DATA_BLOB)out);
        return WindowsCryptUtils.getBytes((WinCrypt.DATA_BLOB)out, rc);
    }

    public static byte @NotNull [] unprotect(byte[] data) {
        if (data.length == 0) {
            return data;
        }
        WinCrypt.DATA_BLOB in = WindowsCryptUtils.prepareInput(data);
        WinCrypt.DATA_BLOB.ByReference out = new WinCrypt.DATA_BLOB.ByReference();
        boolean rc = Crypt32.INSTANCE.CryptUnprotectData(in, null, null, null, null, 0, (WinCrypt.DATA_BLOB)out);
        return WindowsCryptUtils.getBytes((WinCrypt.DATA_BLOB)out, rc);
    }

    private static WinCrypt.DATA_BLOB prepareInput(byte[] data) {
        Memory input = new Memory((long)data.length);
        input.write(0L, data, 0, data.length);
        WinCrypt.DATA_BLOB.ByReference in = new WinCrypt.DATA_BLOB.ByReference();
        in.cbData = data.length;
        in.pbData = input;
        return in;
    }

    private static byte[] getBytes(WinCrypt.DATA_BLOB out, boolean rc) {
        if (!rc) {
            throw new RuntimeException("CryptProtectData failed: " + Kernel32.INSTANCE.GetLastError());
        }
        byte[] output = new byte[out.cbData];
        out.pbData.read(0L, output, 0, output.length);
        Kernel32.INSTANCE.LocalFree(out.pbData);
        return output;
    }
}

