/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.ProtectedValue;
import com.intellij.credentialStore.kdbx.ProtectedValueKt;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/credentialStore/kdbx/XmlProtectedValueTransformer;", "", "streamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "(Lorg/bouncycastle/crypto/SkippingStreamCipher;)V", "position", "", "processEntries", "", "parentElement", "Lorg/jdom/Element;", "intellij.platform.credentialStore"})
public final class XmlProtectedValueTransformer {
    private int position;
    private final SkippingStreamCipher streamCipher;

    public final void processEntries(@NotNull Element parentElement) {
        for (Content element : parentElement.getContent()) {
            if (!(element instanceof Element)) continue;
            if (Intrinsics.areEqual((Object)((Element)element).getName(), (Object)"Group")) {
                this.processEntries((Element)element);
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Element)element).getName(), (Object)"Entry")) continue;
            for (Element container : ((Element)element).getChildren("String")) {
                Element valueElement;
                if (container.getChild("Value") == null) {
                    continue;
                }
                if (!ProtectedValueKt.isValueProtected(valueElement)) continue;
                byte[] value = Base64.getDecoder().decode(valueElement.getText());
                valueElement.setContent((Content)new ProtectedValue(value, this.position, this.streamCipher));
                this.position += value.length;
            }
        }
    }

    public XmlProtectedValueTransformer(@NotNull SkippingStreamCipher streamCipher) {
        this.streamCipher = streamCipher;
    }
}

