/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.extractors.html;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.extractors.Extractor;
import trebuchet.extractors.ExtractorFactory;
import trebuchet.extractors.html.SystraceExtractor;
import trebuchet.importers.ImportFeedback;
import trebuchet.io.BufferProducer;
import trebuchet.io.DataSlice;
import trebuchet.io.GenericByteBuffer;
import trebuchet.io.Pipe;
import trebuchet.io.StreamingReader;
import trebuchet.util.StringSearch;
import trebuchet.util.StringSearchKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltrebuchet/extractors/html/SystraceExtractor;", "Ltrebuchet/extractors/Extractor;", "()V", "endIndex", "", "startIndex", "extract", "", "stream", "Ltrebuchet/io/StreamingReader;", "processSubStream", "Lkotlin/Function1;", "Ltrebuchet/io/BufferProducer;", "processWindow", "window", "Ltrebuchet/io/StreamingReader$Window;", "pipe", "Ltrebuchet/io/Pipe;", "Ltrebuchet/io/DataSlice;", "Companion", "Factory", "SubStream", "intellij.android.profilers.atrace"})
public final class SystraceExtractor
implements Extractor {
    private int startIndex;
    private int endIndex = Integer.MAX_VALUE;
    @NotNull
    private static final StringSearch START;
    @NotNull
    private static final StringSearch END;
    private static final Companion Companion;

    @Override
    public void extract(@NotNull StreamingReader stream, @NotNull Function1<? super BufferProducer, Unit> processSubStream) {
        while (true) {
            stream.setOnWindowReleased((Function1<? super StreamingReader.Window, Unit>)((Function1)null));
            this.startIndex = StringSearch.find$default(START, stream, this.startIndex, 0, 4, null);
            if (this.startIndex == -1) {
                return;
            }
            this.startIndex += START.getLength();
            if (!stream.loadIndex(this.startIndex)) {
                return;
            }
            if (stream.get(this.startIndex) == (byte)10) {
                int n = this.startIndex;
                this.startIndex = n + 1;
            }
            this.endIndex = Integer.MAX_VALUE;
            Pipe<DataSlice> pipe = new Pipe<DataSlice>(0, 1, null);
            Thread thread2 = new Thread(new Runnable(this, stream, pipe){
                final /* synthetic */ SystraceExtractor this$0;
                final /* synthetic */ StreamingReader $stream;
                final /* synthetic */ Pipe $pipe;

                public final void run() {
                    this.$stream.setOnWindowReleased((Function1<? super StreamingReader.Window, Unit>)((Function1)new Function1<StreamingReader.Window, Unit>(this){
                        final /* synthetic */ extract.thread.1 this$0;

                        public final void invoke(@NotNull StreamingReader.Window window) {
                            SystraceExtractor.access$processWindow(this.this$0.this$0, window, this.this$0.$pipe);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                    SystraceExtractor.access$setEndIndex$p(this.this$0, StringSearch.find$default(SystraceExtractor.access$Companion().getEND(), this.$stream, SystraceExtractor.access$getStartIndex$p(this.this$0), 0, 4, null));
                    if (SystraceExtractor.access$getEndIndex$p(this.this$0) == -1) {
                        SystraceExtractor.access$setEndIndex$p(this.this$0, this.$stream.getEndIndex());
                    }
                    this.$stream.setOnWindowReleased((Function1<? super StreamingReader.Window, Unit>)((Function1)null));
                    Iterable $this$forEach$iv = this.$stream.getWindows();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        StreamingReader.Window it = (StreamingReader.Window)element$iv;
                        boolean bl = false;
                        SystraceExtractor.access$processWindow(this.this$0, it, this.$pipe);
                    }
                    this.$pipe.close();
                }
                {
                    this.this$0 = systraceExtractor;
                    this.$stream = streamingReader;
                    this.$pipe = pipe;
                }
            });
            thread2.start();
            processSubStream.invoke((Object)new SubStream(pipe));
            thread2.join();
            this.startIndex = this.endIndex;
        }
    }

    private final void processWindow(StreamingReader.Window window, Pipe<DataSlice> pipe) {
        if (window.getGlobalEndIndex() >= this.startIndex && window.getGlobalStartIndex() < this.endIndex) {
            if (window.getGlobalStartIndex() >= this.startIndex && window.getGlobalEndIndex() <= this.endIndex) {
                pipe.add(window.getSlice());
            } else {
                int n = this.startIndex - window.getGlobalStartIndex();
                int n2 = 0;
                int n3 = 0;
                int sliceStart = Math.max(n, n2);
                n2 = this.endIndex;
                n3 = window.getGlobalEndIndex();
                boolean bl = false;
                int sliceEnd = Math.min(n2, n3) - window.getGlobalStartIndex();
                DataSlice this_$iv = window.getSlice();
                DataSlice dest$iv = new DataSlice();
                boolean $i$f$slice = false;
                dest$iv.set(this_$iv.getBuffer(), this_$iv.getStartIndex() + sliceStart, this_$iv.getStartIndex() + sliceEnd);
                pipe.add(dest$iv);
            }
        }
    }

    static {
        Companion = new Companion(null);
        START = StringSearchKt.searchFor("<script class=\"trace-data\" type=\"application/text\">");
        END = StringSearchKt.searchFor("</script>");
    }

    public static final /* synthetic */ void access$processWindow(SystraceExtractor $this, StreamingReader.Window window, Pipe pipe) {
        $this.processWindow(window, pipe);
    }

    public static final /* synthetic */ int access$getEndIndex$p(SystraceExtractor $this) {
        return $this.endIndex;
    }

    public static final /* synthetic */ void access$setEndIndex$p(SystraceExtractor $this, int n) {
        $this.endIndex = n;
    }

    public static final /* synthetic */ int access$getStartIndex$p(SystraceExtractor $this) {
        return $this.startIndex;
    }

    public static final /* synthetic */ void access$setStartIndex$p(SystraceExtractor $this, int n) {
        $this.startIndex = n;
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Ltrebuchet/extractors/html/SystraceExtractor$SubStream;", "Ltrebuchet/io/BufferProducer;", "pipe", "Ltrebuchet/io/Pipe;", "Ltrebuchet/io/DataSlice;", "(Ltrebuchet/io/Pipe;)V", "getPipe", "()Ltrebuchet/io/Pipe;", "next", "intellij.android.profilers.atrace"})
    private static final class SubStream
    implements BufferProducer {
        @NotNull
        private final Pipe<DataSlice> pipe;

        @Override
        @Nullable
        public DataSlice next() {
            return this.pipe.next();
        }

        @NotNull
        public final Pipe<DataSlice> getPipe() {
            return this.pipe;
        }

        public SubStream(@NotNull Pipe<DataSlice> pipe) {
            this.pipe = pipe;
        }

        @Override
        public void close() {
            BufferProducer.DefaultImpls.close(this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Ltrebuchet/extractors/html/SystraceExtractor$Factory;", "Ltrebuchet/extractors/ExtractorFactory;", "()V", "extractorFor", "Ltrebuchet/extractors/Extractor;", "buffer", "Ltrebuchet/io/GenericByteBuffer;", "feedback", "Ltrebuchet/importers/ImportFeedback;", "intellij.android.profilers.atrace"})
    public static final class Factory
    implements ExtractorFactory {
        public static final Factory INSTANCE;

        @Override
        @Nullable
        public Extractor extractorFor(@NotNull GenericByteBuffer buffer, @NotNull ImportFeedback feedback) {
            if (StringSearchKt.contains(buffer, "<html>", 1000)) {
                return new SystraceExtractor();
            }
            return null;
        }

        private Factory() {
        }

        static {
            Factory factory;
            INSTANCE = factory = new Factory();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ltrebuchet/extractors/html/SystraceExtractor$Companion;", "", "()V", "END", "Ltrebuchet/util/StringSearch;", "getEND", "()Ltrebuchet/util/StringSearch;", "START", "getSTART", "intellij.android.profilers.atrace"})
    private static final class Companion {
        @NotNull
        public final StringSearch getSTART() {
            return START;
        }

        @NotNull
        public final StringSearch getEND() {
            return END;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

