/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.stacktrace;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeLocation {
    public static final int INVALID_LINE_NUMBER = -1;
    @Nullable
    private final String myClassName;
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myMethodName;
    @Nullable
    private final String mySignature;
    @Nullable
    private final List<String> myMethodParameters;
    private final int myLineNumber;
    private final boolean myNativeCode;
    private final long myNativeVAddress;
    @Nullable
    private final String myNativeModuleName;
    private final int myHashcode;

    private CodeLocation(@NotNull Builder builder) {
        this.myClassName = builder.myClassName;
        this.myFileName = builder.myFileName;
        this.myMethodName = builder.myMethodName;
        this.mySignature = builder.mySignature;
        this.myMethodParameters = builder.myMethodParameters;
        this.myLineNumber = builder.myLineNumber;
        this.myNativeCode = builder.myNativeCode;
        this.myNativeVAddress = builder.myNativeVAddress;
        this.myNativeModuleName = builder.myNativeModuleName;
        this.myHashcode = Arrays.hashCode(new int[]{this.myClassName == null ? 0 : this.myClassName.hashCode(), this.myFileName == null ? 0 : this.myFileName.hashCode(), this.myMethodName == null ? 0 : this.myMethodName.hashCode(), this.mySignature == null ? 0 : this.mySignature.hashCode(), this.myNativeModuleName == null ? 0 : this.myNativeModuleName.hashCode(), Integer.hashCode(this.myLineNumber)});
    }

    @NotNull
    public static CodeLocation stub() {
        return new Builder("").build();
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Nullable
    public String getOuterClassName() {
        if (this.myClassName == null) {
            return null;
        }
        int innerCharIndex = this.myClassName.indexOf(36);
        if (innerCharIndex < 0) {
            innerCharIndex = this.myClassName.length();
        }
        return this.myClassName.substring(0, innerCharIndex);
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getMethodName() {
        return this.myMethodName;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Nullable
    public String getSignature() {
        return this.mySignature;
    }

    @Nullable
    public List<String> getMethodParameters() {
        return this.myMethodParameters;
    }

    public boolean isNativeCode() {
        return this.myNativeCode;
    }

    public long getNativeVAddress() {
        return this.myNativeVAddress;
    }

    @Nullable
    public String getNativeModuleName() {
        return this.myNativeModuleName;
    }

    public int hashCode() {
        return this.myHashcode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodeLocation)) {
            return false;
        }
        CodeLocation other = (CodeLocation)obj;
        return StringUtil.equals((CharSequence)this.myClassName, (CharSequence)other.myClassName) && StringUtil.equals((CharSequence)this.myFileName, (CharSequence)other.myFileName) && StringUtil.equals((CharSequence)this.myMethodName, (CharSequence)other.myMethodName) && StringUtil.equals((CharSequence)this.mySignature, (CharSequence)other.mySignature) && StringUtil.equals((CharSequence)this.myNativeModuleName, (CharSequence)other.myNativeModuleName) && this.myLineNumber == other.myLineNumber && this.myNativeCode == other.myNativeCode;
    }

    public static final class Builder {
        @Nullable
        private final String myClassName;
        @Nullable
        String myFileName;
        @Nullable
        String myMethodName;
        @Nullable
        String mySignature;
        @Nullable
        List<String> myMethodParameters;
        int myLineNumber = -1;
        boolean myNativeCode;
        long myNativeVAddress = -1L;
        @Nullable
        String myNativeModuleName;

        public Builder(@Nullable String className) {
            this.myClassName = className;
        }

        public Builder(@NotNull CodeLocation rhs) {
            this.myClassName = rhs.getClassName();
            this.myFileName = rhs.getFileName();
            this.myMethodName = rhs.getMethodName();
            this.mySignature = rhs.getSignature();
            this.myMethodParameters = rhs.getMethodParameters();
            this.myLineNumber = rhs.getLineNumber();
            this.myNativeCode = rhs.myNativeCode;
            this.myNativeVAddress = rhs.myNativeVAddress;
            this.myNativeModuleName = rhs.myNativeModuleName;
        }

        @NotNull
        public Builder setFileName(@Nullable String fileName) {
            this.myFileName = StringUtil.nullize((String)fileName);
            return this;
        }

        @NotNull
        public Builder setMethodName(@Nullable String methodName) {
            this.myMethodName = StringUtil.nullize((String)methodName);
            return this;
        }

        @NotNull
        public Builder setMethodSignature(@NotNull String signature) {
            this.mySignature = signature;
            return this;
        }

        @NotNull
        public Builder setMethodParameters(@NotNull List<String> methodParameters) {
            this.myMethodParameters = methodParameters;
            return this;
        }

        @NotNull
        public Builder setLineNumber(int lineNumber) {
            this.myLineNumber = lineNumber;
            return this;
        }

        public Builder setNativeCode(boolean nativeCode) {
            this.myNativeCode = nativeCode;
            return this;
        }

        public Builder setNativeVAddress(long nativeVAddress) {
            this.myNativeVAddress = nativeVAddress;
            return this;
        }

        public Builder setNativeModuleName(String name) {
            this.myNativeModuleName = name;
            return this;
        }

        @NotNull
        public CodeLocation build() {
            return new CodeLocation(this);
        }
    }
}

