/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.sessions.SessionArtifactView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class SessionItemView
extends SessionArtifactView<SessionItem> {
    private static final Border DIVIDER_BORDER = JBUI.Borders.customLine((Color)ProfilerColors.SESSION_DIVIDER_COLOR, (int)1, (int)0, (int)0, (int)0);
    private static final Border COMPONENT_PADDING = JBUI.Borders.empty((int)4, (int)2, (int)4, (int)4);
    private static final Font SESSION_TIME_FONT = TITLE_FONT.deriveFont(Collections.singletonMap(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD));

    public SessionItemView(@NotNull SessionArtifactView.ArtifactDrawInfo artifactDrawInfo, @NotNull SessionItem artifact) {
        super(artifactDrawInfo, artifact);
    }

    @Override
    @NotNull
    protected JComponent buildComponent() {
        JPanel panel2 = new JPanel((LayoutManager)new TabularLayout("Fit,Fit,*", "Fit,Fit,Fit"));
        boolean isSessionAlive = SessionsManager.isSessionAlive(((SessionItem)this.getArtifact()).getSession());
        JLabel startTime = new JLabel(TimeFormatter.getLocalizedTime((long)((SessionItem)this.getArtifact()).getSessionMetaData().getStartTimestampEpochMs()));
        startTime.setBorder(LABEL_PADDING);
        startTime.setFont(SESSION_TIME_FONT);
        startTime.setForeground(StandardColors.TEXT_COLOR);
        panel2.add((Component)startTime, new TabularLayout.Constraint(0, 0));
        JPanel liveDotWrapper = new JPanel(new BorderLayout());
        if (isSessionAlive) {
            liveDotWrapper.setBorder(ProfilerLayout.TOOLBAR_ICON_BORDER);
            liveDotWrapper.setOpaque(false);
            LiveSessionDot liveDot = new LiveSessionDot();
            liveDot.setToolTipText("Currently Profiling");
            this.installContextMenus(liveDot);
            this.addMouseListeningComponents(liveDot);
            liveDotWrapper.add((Component)liveDot, "Center");
            panel2.add((Component)liveDotWrapper, new TabularLayout.Constraint(0, 1));
        }
        JLabel sessionName = new JLabel(((SessionItem)this.getArtifact()).getName());
        sessionName.setBorder(LABEL_PADDING);
        sessionName.setFont(STATUS_FONT);
        sessionName.setForeground(StandardColors.TEXT_COLOR);
        sessionName.setToolTipText(((SessionItem)this.getArtifact()).getName());
        this.installContextMenus(sessionName);
        this.addMouseListeningComponents(sessionName);
        panel2.add((Component)sessionName, new TabularLayout.Constraint(1, 0, 1, 3));
        JLabel durationLabel = new JLabel(((SessionItem)this.getArtifact()).getSubtitle());
        durationLabel.setBorder(LABEL_PADDING);
        durationLabel.setFont(STATUS_FONT);
        durationLabel.setForeground(AdtUiUtils.overlayColor((int)durationLabel.getBackground().getRGB(), (int)StandardColors.TEXT_COLOR.getRGB(), (float)0.6f));
        panel2.add((Component)durationLabel, new TabularLayout.Constraint(2, 0, 1, 3));
        int fillerWidth = Math.max(sessionName.getMinimumSize().width, durationLabel.getMinimumSize().width) - startTime.getMinimumSize().width - (isSessionAlive ? liveDotWrapper.getMinimumSize().width : 0);
        Dimension fillerDimension = new Dimension(fillerWidth, 1);
        Box.Filler filler = new Box.Filler(fillerDimension, fillerDimension, fillerDimension);
        panel2.add((Component)filler, new TabularLayout.Constraint(0, 2));
        ((SessionItem)this.getArtifact()).addDependency(this.myObserver).onChange((Enum)SessionItem.Aspect.MODEL, () -> {
            int updatedFillerWidth;
            Dimension updatedFillerDimension;
            if (!Objects.equals(((SessionItem)this.getArtifact()).getSubtitle(), durationLabel.getText())) {
                durationLabel.setText(((SessionItem)this.getArtifact()).getSubtitle());
            }
            if (!(updatedFillerDimension = new Dimension(updatedFillerWidth = Math.max(sessionName.getMinimumSize().width, durationLabel.getMinimumSize().width) - startTime.getMinimumSize().width - (isSessionAlive ? liveDotWrapper.getMinimumSize().width : 0), 1)).equals(filler.getMinimumSize())) {
                filler.changeShape(updatedFillerDimension, updatedFillerDimension, updatedFillerDimension);
            }
        });
        this.getProfilers().getSessionsManager().addDependency(this.myObserver).onChange((Enum)SessionAspect.SELECTED_SESSION, () -> this.updateBorder(panel2));
        this.updateBorder(panel2);
        return panel2;
    }

    private void updateBorder(@NotNull JPanel panel2) {
        Border selectionBorder = this.isSessionSelected() ? JBUI.Borders.merge((Border)SELECTED_BORDER, (Border)COMPONENT_PADDING, (boolean)false) : JBUI.Borders.merge((Border)UNSELECTED_BORDER, (Border)COMPONENT_PADDING, (boolean)false);
        panel2.setBorder(this.getIndex() == 0 ? selectionBorder : JBUI.Borders.merge((Border)DIVIDER_BORDER, (Border)selectionBorder, (boolean)false));
    }

    @Override
    @NotNull
    protected List<ContextMenuItem> getContextMenus() {
        boolean canEndSession = SessionsManager.isSessionAlive(((SessionItem)this.getArtifact()).getSession());
        Icon endIcon = canEndSession ? StudioIcons.Profiler.Toolbar.STOP_SESSION : IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_SESSION);
        ProfilerAction endAction = new ProfilerAction.Builder("End session").setEnableBooleanSupplier(() -> canEndSession).setActionRunnable(() -> this.getSessionsView().stopProfilingSession()).setIcon(endIcon).build();
        ProfilerAction deleteAction = new ProfilerAction.Builder("Delete").setContainerComponent(this).setActionRunnable(() -> ((SessionItem)this.getArtifact()).deleteSession()).setKeyStrokes(KeyStroke.getKeyStroke(127, 0), KeyStroke.getKeyStroke(8, 0)).build();
        return ImmutableList.of((Object)endAction, (Object)ContextMenuItem.SEPARATOR, (Object)deleteAction);
    }

    private static class LiveSessionDot
    extends JComponent {
        private static final int SIZE = JBUI.scale((int)10);
        private static final Dimension DIMENSION = new Dimension(SIZE, SIZE);

        private LiveSessionDot() {
        }

        @Override
        public Dimension getMinimumSize() {
            return DIMENSION;
        }

        @Override
        public Dimension getMaximumSize() {
            return DIMENSION;
        }

        @Override
        public Dimension getPreferredSize() {
            return DIMENSION;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(ProfilerColors.ACTIVE_SESSION_COLOR);
            g2d.fillOval(0, 0, SIZE, SIZE);
            g2d.dispose();
        }
    }
}

