/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.profilers.BorderlessTableCellRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.TimelineTable;
import com.android.tools.profilers.network.ConnectionsStateChart;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

final class ConnectionsView {
    @NotNull
    private final NetworkProfilerStage myStage;
    @NotNull
    private final ConnectionsTableModel myTableModel;
    @NotNull
    private final JTable myConnectionsTable;
    @NotNull
    private final AspectObserver myAspectObserver;

    ConnectionsView(@NotNull NetworkProfilerStageView stageView) {
        this.myStage = (NetworkProfilerStage)stageView.getStage();
        this.myTableModel = new ConnectionsTableModel(this.myStage.getHttpDataFetcher());
        this.myConnectionsTable = TimelineTable.create(this.myTableModel, (Timeline)this.myStage.getTimeline(), Column.TIMELINE.ordinal());
        this.customizeConnectionsTable();
        this.createTooltip(stageView);
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)NetworkProfilerAspect.SELECTED_CONNECTION, this::updateTableSelection);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myConnectionsTable;
    }

    private void customizeConnectionsTable() {
        this.myConnectionsTable.setAutoCreateRowSorter(true);
        this.myConnectionsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.SIZE.ordinal()).setCellRenderer(new SizeRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TYPE.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.STATUS.ordinal()).setCellRenderer(new StatusRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TIME.ordinal()).setCellRenderer(new TimeRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer(new TimelineRenderer(this.myConnectionsTable, this.myStage.getTimeline()));
        this.myConnectionsTable.setSelectionMode(0);
        this.myConnectionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int selectedRow = this.myConnectionsTable.getSelectedRow();
            if (0 <= selectedRow && selectedRow < this.myTableModel.getRowCount()) {
                int modelRow = this.myConnectionsTable.convertRowIndexToModel(selectedRow);
                this.myStage.setSelectedConnection(this.myTableModel.getHttpData(modelRow));
            }
        });
        this.myConnectionsTable.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myConnectionsTable.setShowVerticalLines(true);
        this.myConnectionsTable.setShowHorizontalLines(false);
        int defaultFontHeight = this.myConnectionsTable.getFontMetrics(this.myConnectionsTable.getFont()).getHeight();
        this.myConnectionsTable.setRowMargin(0);
        this.myConnectionsTable.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myConnectionsTable.setFocusTraversalKeys(0, null);
        this.myConnectionsTable.setFocusTraversalKeys(1, null);
        this.myConnectionsTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (int i2 = 0; i2 < Column.values().length; ++i2) {
                    Column column = Column.values()[i2];
                    ConnectionsView.this.myConnectionsTable.getColumnModel().getColumn(i2).setPreferredWidth((int)((double)ConnectionsView.this.myConnectionsTable.getWidth() * column.getWidthPercentage()));
                }
            }
        });
        this.myStage.getHttpDataFetcher().addListener(httpDataList -> this.updateTableSelection());
    }

    private void createTooltip(@NotNull StageView stageView) {
        final JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        textPane.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        textPane.setForeground(ProfilerColors.TOOLTIP_TEXT);
        textPane.setFont(TooltipView.TOOLTIP_BODY_FONT);
        final TooltipComponent tooltip2 = new TooltipComponent.Builder((JComponent)textPane, (JComponent)this.myConnectionsTable, stageView.getProfilersView().getComponent()).build();
        tooltip2.registerListenersOn((Component)this.myConnectionsTable);
        this.myConnectionsTable.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = ConnectionsView.this.myConnectionsTable.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    tooltip2.setVisible(true);
                    String url = ConnectionsView.this.myTableModel.getHttpData(ConnectionsView.this.myConnectionsTable.convertRowIndexToModel(row)).getUrl();
                    textPane.setText(url);
                } else {
                    tooltip2.setVisible(false);
                }
            }
        });
    }

    private void updateTableSelection() {
        HttpData selectedData = this.myStage.getSelectedConnection();
        if (selectedData != null) {
            for (int i2 = 0; i2 < this.myTableModel.getRowCount(); ++i2) {
                if (this.myTableModel.getHttpData(i2).getId() != selectedData.getId()) continue;
                int row = this.myConnectionsTable.convertRowIndexToView(i2);
                this.myConnectionsTable.setRowSelectionInterval(row, row);
                return;
            }
        } else {
            this.myConnectionsTable.clearSelection();
        }
    }

    private static final class TimelineRenderer
    extends TimelineTable.CellRenderer
    implements TableModelListener {
        @NotNull
        private final List<ConnectionsStateChart> myConnectionsCharts = new ArrayList<ConnectionsStateChart>();
        @NotNull
        private final JTable myTable;

        TimelineRenderer(@NotNull JTable table, @NotNull StreamingTimeline timeline) {
            super((Timeline)timeline);
            this.myTable = table;
            this.myTable.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.myTable.getModel()));
        }

        @Override
        @NotNull
        protected Component getTableCellRendererComponent(boolean isSelected, int row) {
            ConnectionsStateChart chart = this.myConnectionsCharts.get(this.myTable.convertRowIndexToModel(row));
            chart.getColors().setColorIndex(isSelected ? 1 : 0);
            return chart.getComponent();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.myConnectionsCharts.clear();
            ConnectionsTableModel model = (ConnectionsTableModel)this.myTable.getModel();
            for (int i2 = 0; i2 < model.getRowCount(); ++i2) {
                ConnectionsStateChart chart = new ConnectionsStateChart(model.getHttpData(i2), this.getTimeline().getSelectionRange());
                chart.setHeightGap(0.3f);
                this.myConnectionsCharts.add(chart);
            }
        }
    }

    private static final class TimeRenderer
    extends BorderlessTableCellRenderer {
        private TimeRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            Long durationUs = (Long)value;
            if (durationUs >= 0L) {
                long durationMs = TimeUnit.MICROSECONDS.toMillis(durationUs);
                this.setText(StringUtil.formatDuration((long)durationMs));
            } else {
                this.setText("");
            }
        }
    }

    private static final class StatusRenderer
    extends BorderlessTableCellRenderer {
        private StatusRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            Integer status = (Integer)value;
            this.setText(status > -1 ? Integer.toString(status) : "");
        }
    }

    private static final class SizeRenderer
    extends BorderlessTableCellRenderer {
        private SizeRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            int bytes = (Integer)value;
            this.setText(bytes >= 0 ? NumberFormatter.formatFileSize((long)bytes) : "");
        }
    }

    private static final class ConnectionsTableModel
    extends AbstractTableModel {
        @NotNull
        private List<HttpData> myDataList = new ArrayList<HttpData>();

        private ConnectionsTableModel(HttpDataFetcher httpDataFetcher) {
            httpDataFetcher.addListener(httpDataList -> {
                this.myDataList = httpDataList;
                this.fireTableDataChanged();
            });
        }

        @Override
        public int getRowCount() {
            return this.myDataList.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        public String getColumnName(int column) {
            return Column.values()[column].toDisplayString();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HttpData data = this.myDataList.get(rowIndex);
            return Column.values()[columnIndex].getValueFrom(data);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @NotNull
        public HttpData getHttpData(int rowIndex) {
            return this.myDataList.get(rowIndex);
        }
    }

    @VisibleForTesting
    static enum Column {
        NAME(0.25, (Class)String.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return HttpData.getUrlName(data.getUrl());
            }
        }
        ,
        SIZE(0.0625, (Class)Integer.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return data.getResponsePayloadSize();
            }
        }
        ,
        TYPE(0.0625, (Class)String.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                HttpData.ContentType type = data.getResponseHeader().getContentType();
                String[] mimeTypeParts = type.getMimeType().split("/");
                return mimeTypeParts[mimeTypeParts.length - 1];
            }
        }
        ,
        STATUS(0.0625, (Class)Integer.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return data.getResponseHeader().getStatusCode();
            }
        }
        ,
        TIME(0.0625, (Class)Long.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return data.getConnectionEndTimeUs() - data.getRequestStartTimeUs();
            }
        }
        ,
        TIMELINE(0.5, (Class)Long.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return data.getRequestStartTimeUs();
            }
        };

        private final double myWidthPercentage;
        private final Class<?> myType;

        private Column(double widthPercentage, Class<?> type) {
            this.myWidthPercentage = widthPercentage;
            this.myType = type;
        }

        public double getWidthPercentage() {
            return this.myWidthPercentage;
        }

        public Class<?> getType() {
            return this.myType;
        }

        public String toDisplayString() {
            return StringUtil.capitalize((String)this.name().toLowerCase(Locale.getDefault()));
        }

        abstract Object getValueFrom(@NotNull HttpData var1);
    }
}

