/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.chart;

import com.android.tools.adtui.model.HNode;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.chart.ClassifierSetHNode;
import com.android.tools.profilers.memory.chart.ClassifierSetHNode$WhenMappings;
import com.android.tools.profilers.memory.chart.MemoryVisualizationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0000H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0000H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00000\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/profilers/memory/chart/ClassifierSetHNode;", "Lcom/android/tools/adtui/model/HNode;", "callChartModel", "Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel;", "data", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "depth", "", "(Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel;Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;I)V", "children", "", "kotlin.jvm.PlatformType", "getData", "()Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "isFiltered", "", "()Z", "isMatched", "name", "", "getName", "()Ljava/lang/String;", "startOffset", "", "computeDuration", "getChildAt", "index", "getChildCount", "getDepth", "getDuration", "getEnd", "getFirstChild", "getLastChild", "getParent", "getStart", "updateChildrenOffsets", "", "intellij.android.profilers"})
public final class ClassifierSetHNode
implements HNode<ClassifierSetHNode> {
    private final List<ClassifierSetHNode> children;
    private long startOffset;
    private final MemoryVisualizationModel callChartModel;
    @NotNull
    private final ClassifierSet data;
    private final int depth;

    public final void updateChildrenOffsets() {
        long childOffset = this.startOffset;
        for (ClassifierSetHNode child : this.children) {
            child.startOffset = childOffset;
            childOffset += child.getDuration();
            child.updateChildrenOffsets();
        }
    }

    private final long computeDuration(ClassifierSet data) {
        long l;
        switch (ClassifierSetHNode$WhenMappings.$EnumSwitchMapping$0[this.callChartModel.getAxisFilter().ordinal()]) {
            case 1: {
                l = data.getTotalObjectCount();
                break;
            }
            case 2: {
                l = data.getTotalShallowSize();
                break;
            }
            case 3: {
                l = data.getAllocationSize();
                break;
            }
            case 4: {
                l = data.getDeltaAllocationCount();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    public int getChildCount() {
        return this.children.size();
    }

    @NotNull
    public ClassifierSetHNode getChildAt(int index) {
        return this.children.get(index);
    }

    @Nullable
    public ClassifierSetHNode getParent() {
        return null;
    }

    public long getStart() {
        return this.startOffset;
    }

    public long getEnd() {
        return this.getStart() + this.computeDuration(this.data);
    }

    public int getDepth() {
        return this.depth;
    }

    public long getDuration() {
        return this.computeDuration(this.data);
    }

    public final boolean isMatched() {
        return this.data.getIsMatched();
    }

    public final boolean isFiltered() {
        return this.data.getIsFiltered();
    }

    @Nullable
    public ClassifierSetHNode getFirstChild() {
        return (ClassifierSetHNode)CollectionsKt.first(this.children);
    }

    @Nullable
    public ClassifierSetHNode getLastChild() {
        return (ClassifierSetHNode)CollectionsKt.last(this.children);
    }

    @NotNull
    public final String getName() {
        return this.data.getName();
    }

    @NotNull
    public final ClassifierSet getData() {
        return this.data;
    }

    /*
     * WARNING - void declaration
     */
    public ClassifierSetHNode(@NotNull MemoryVisualizationModel callChartModel, @NotNull ClassifierSet data, int depth) {
        Collection<ClassifierSetHNode> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.callChartModel = callChartModel;
        this.data = data;
        this.depth = depth;
        Iterable iterable = this.data.getChildrenClassifierSets();
        ClassifierSetHNode classifierSetHNode = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassifierSet classifierSet = (ClassifierSet)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ClassifierSetHNode classifierSetHNode2 = new ClassifierSetHNode(this.callChartModel, (ClassifierSet)it, this.depth + 1);
            collection.add(classifierSetHNode2);
        }
        collection = (List)destination$iv$iv;
        classifierSetHNode.children = CollectionsKt.toList((Iterable)CollectionsKt.toSortedSet((Iterable)collection, Comparator.comparingLong(children.2.INSTANCE).reversed()));
    }
}

