/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Classifier {
    public static final Classifier IDENTITY_CLASSIFIER = new Classifier(){

        @Override
        public boolean isTerminalClassifier() {
            return true;
        }

        @Override
        @NotNull
        public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public List<ClassifierSet> getFilteredClassifierSets() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        protected List<ClassifierSet> getAllClassifierSets() {
            return Collections.emptyList();
        }
    };

    public boolean isTerminalClassifier() {
        return false;
    }

    @Nullable
    public abstract ClassifierSet getClassifierSet(@NotNull InstanceObject var1, boolean var2);

    @NotNull
    public abstract List<ClassifierSet> getFilteredClassifierSets();

    @NotNull
    protected abstract List<ClassifierSet> getAllClassifierSets();

    public final void partition(@NotNull Collection<InstanceObject> snapshotInstances, @NotNull Collection<InstanceObject> deltaInstances) {
        if (this.isTerminalClassifier()) {
            return;
        }
        snapshotInstances.forEach(instance -> this.getClassifierSet((InstanceObject)instance, true).addSnapshotInstanceObject((InstanceObject)instance));
        deltaInstances.forEach(instance -> {
            if (instance.hasTimeData()) {
                if (instance.hasAllocTime() && !snapshotInstances.contains(instance)) {
                    this.getClassifierSet((InstanceObject)instance, true).addDeltaInstanceObject((InstanceObject)instance);
                }
                if (instance.hasDeallocTime()) {
                    this.getClassifierSet((InstanceObject)instance, true).freeDeltaInstanceObject((InstanceObject)instance);
                }
            } else {
                this.getClassifierSet((InstanceObject)instance, true).addDeltaInstanceObject((InstanceObject)instance);
            }
        });
        snapshotInstances.clear();
        deltaInstances.clear();
    }
}

