/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public final class ClassDb {
    public static final int INVALID_CLASS_ID = -1;
    public static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final Map<Long, ClassEntry> myClassEntries = new HashMap<Long, ClassEntry>();
    private boolean myResolvedSubclasses = false;

    public void clear() {
        this.myClassEntries.clear();
        this.myResolvedSubclasses = false;
    }

    @NotNull
    public ClassEntry registerClass(long classId, @NotNull String className) {
        return this.registerClass(classId, -1L, className);
    }

    @NotNull
    public ClassEntry registerClass(long classId, long superClassId, @NotNull String className) {
        ClassEntry entry = this.myClassEntries.get(classId);
        if (entry == null || superClassId != entry.mySuperClassId || !className.equals(entry.myClassName)) {
            entry = new ClassEntry(classId, superClassId, className);
            this.myClassEntries.put(classId, entry);
        }
        return entry;
    }

    @NotNull
    public ClassEntry getEntry(long classId) {
        assert (this.myClassEntries.containsKey(classId));
        return this.myClassEntries.get(classId);
    }

    @NotNull
    public Set<ClassEntry> getEntriesByName(@NotNull String className) {
        HashSet<ClassEntry> entries = new HashSet<ClassEntry>();
        for (ClassEntry entry : this.myClassEntries.values()) {
            if (!entry.getClassName().equals(className)) continue;
            entries.add(entry);
        }
        return entries;
    }

    public Set<ClassEntry> getDescendantClasses(long classId) {
        this.resolveSubClasses();
        ClassEntry klass = this.getEntry(classId);
        HashSet<ClassEntry> descendants = new HashSet<ClassEntry>();
        Stack<ClassEntry> searchStack = new Stack<ClassEntry>();
        searchStack.push(klass);
        while (!searchStack.isEmpty()) {
            ClassEntry searchEntry = (ClassEntry)searchStack.pop();
            descendants.add(searchEntry);
            for (long subClassId : searchEntry.getSubClassIds()) {
                searchStack.push(this.getEntry(subClassId));
            }
        }
        return descendants;
    }

    private boolean resolveSubClasses() {
        if (this.myResolvedSubclasses) {
            return false;
        }
        for (ClassEntry entry : this.myClassEntries.values()) {
            long superClassId = entry.getSuperClassId();
            if (superClassId == -1L) continue;
            this.getEntry(superClassId).getSubClassIds().add(entry.getClassId());
        }
        this.myResolvedSubclasses = true;
        return true;
    }

    public static class ClassEntry {
        @NotNull
        private final Set<Long> mySubClassIds = new HashSet<Long>();
        @NotNull
        private final long myClassId;
        @NotNull
        private final long mySuperClassId;
        @NotNull
        private final String myClassName;
        @NotNull
        private final String[] mySplitPackageName;

        public ClassEntry(long classId, long superClassId, @NotNull String className) {
            this.myClassId = classId;
            this.mySuperClassId = superClassId;
            this.myClassName = className;
            String packageName = this.getPackageName();
            this.mySplitPackageName = packageName.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : packageName.split("\\.");
        }

        public long getClassId() {
            return this.myClassId;
        }

        public long getSuperClassId() {
            return this.mySuperClassId;
        }

        public Set<Long> getSubClassIds() {
            return this.mySubClassIds;
        }

        @NotNull
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public String getPackageName() {
            int lastIndexOfDot = this.getLastIndexOfDot();
            return lastIndexOfDot > 0 ? this.myClassName.substring(0, lastIndexOfDot) : "";
        }

        @NotNull
        public String[] getSplitPackageName() {
            return this.mySplitPackageName;
        }

        @NotNull
        public String getSimpleClassName() {
            return this.myClassName.substring(this.getLastIndexOfDot() + 1);
        }

        public int hashCode() {
            return this.myClassName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassEntry && this.myClassName.equals(((ClassEntry)obj).myClassName);
        }

        private int getLastIndexOfDot() {
            return this.myClassName.lastIndexOf(46);
        }
    }
}

