/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AllocationInfosDataSeries
extends CaptureDataSeries<CaptureObject> {
    @NotNull
    private MemoryProfilerStage myStage;

    public AllocationInfosDataSeries(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull FeatureTracker featureTracker, @NotNull MemoryProfilerStage stage) {
        super(client, session, featureTracker);
        this.myStage = stage;
    }

    public List<SeriesData<CaptureDurationData<CaptureObject>>> getDataForRange(Range range) {
        List<Memory.AllocationsInfo> infos = MemoryProfiler.getAllocationInfosForSession(this.myClient, this.mySession, range, this.myStage.getStudioProfilers().getIdeServices());
        ArrayList<SeriesData<CaptureDurationData<CaptureObject>>> seriesData = new ArrayList<SeriesData<CaptureDurationData<CaptureObject>>>();
        for (Memory.AllocationsInfo info : infos) {
            long startTimeNs = info.getStartTime();
            long durationUs = AllocationInfosDataSeries.getDurationUs(startTimeNs, info.getEndTime());
            seriesData.add((SeriesData<CaptureDurationData<CaptureObject>>)new SeriesData(AllocationInfosDataSeries.getHostTime(startTimeNs), new CaptureDurationData<CaptureObject>(durationUs, !info.getLegacy(), !info.getLegacy(), new CaptureEntry<CaptureObject>(info, () -> {
                if (info.getLegacy()) {
                    return new LegacyAllocationCaptureObject(this.myClient, this.mySession, info, this.myFeatureTracker);
                }
                return new LiveAllocationCaptureObject(this.myClient, this.mySession, startTimeNs, null, this.myStage);
            }))));
        }
        return seriesData;
    }
}

