/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.EnergyAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.EnergyMonitorTooltip;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyUsage;
import org.jetbrains.annotations.NotNull;

public class EnergyMonitor
extends ProfilerMonitor {
    public static final int MAX_EXPECTED_USAGE = 400;
    public static final Range AXIS_MARKER_RANGE = new Range(0.0, (double)(200 * EnergyAxisFormatter.LABELS.length));
    @NotNull
    private final EnergyUsage myUsage;
    @NotNull
    private final ClampedAxisComponentModel myAxis;
    @NotNull
    private final Legends myLegends;
    @NotNull
    private final Legends myTooltipLegends;

    public EnergyMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        this.myUsage = new EnergyUsage(profilers);
        this.myAxis = (ClampedAxisComponentModel)new ClampedAxisComponentModel.Builder(this.myUsage.getUsageRange(), (BaseAxisFormatter)EnergyAxisFormatter.DEFAULT).setMarkerRange(AXIS_MARKER_RANGE).build();
        this.myLegends = new Legends(this.myUsage, this.getTimeline().getDataRange());
        this.myTooltipLegends = new Legends(this.myUsage, this.getTimeline().getTooltipRange());
        this.changed(ProfilerMonitor.Aspect.ENABLE);
    }

    @Override
    public String getName() {
        return "ENERGY";
    }

    @Override
    public TooltipModel buildTooltip() {
        return new EnergyMonitorTooltip(this);
    }

    @Override
    public void expand() {
        if (this.canExpand()) {
            this.myProfilers.setStage(new EnergyProfilerStage(this.getProfilers()));
        }
    }

    @Override
    public boolean canExpand() {
        return this.isEnabled();
    }

    @Override
    public void enter() {
        if (this.isEnabled()) {
            this.myProfilers.getUpdater().register((Updatable)this.myUsage);
            this.myProfilers.getUpdater().register((Updatable)this.myAxis);
        }
    }

    @Override
    public void exit() {
        if (this.isEnabled()) {
            this.myProfilers.getUpdater().unregister((Updatable)this.myUsage);
            this.myProfilers.getUpdater().unregister((Updatable)this.myAxis);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.myProfilers.getSession().getSessionId() != 0L) {
            return this.myProfilers.getSessionsManager().getSelectedSessionMetaData().getJvmtiEnabled();
        }
        return this.myProfilers.getDevice() == null || this.myProfilers.getDevice().getFeatureLevel() >= 26;
    }

    @NotNull
    public EnergyUsage getUsage() {
        return this.myUsage;
    }

    @NotNull
    public AxisComponentModel getAxis() {
        return this.myAxis;
    }

    @NotNull
    public Legends getLegends() {
        return this.myLegends;
    }

    @NotNull
    public Legends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    public static final class Legends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myUsageLegend;

        public Legends(@NotNull EnergyUsage usage, @NotNull Range range) {
            super(range);
            this.myUsageLegend = new SeriesLegend(usage.getTotalUsageDataSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range);
            this.add((Legend)this.myUsageLegend);
        }

        @NotNull
        public SeriesLegend getUsageLegend() {
            return this.myUsageLegend;
        }
    }
}

