/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.nodemodel;

import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import org.jetbrains.annotations.NotNull;

public class JavaMethodModel
implements CaptureNodeModel {
    @NotNull
    private final String myName;
    @NotNull
    private final String myClassName;
    @NotNull
    private final String mySignature;
    private String myFullName;
    private String myId;

    public JavaMethodModel(@NotNull String name, @NotNull String className, @NotNull String signature) {
        this.myName = name;
        this.myClassName = className;
        this.mySignature = signature;
    }

    public JavaMethodModel(@NotNull String name, @NotNull String className) {
        this(name, className, "");
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public String getSignature() {
        return this.mySignature;
    }

    @Override
    @NotNull
    public String getFullName() {
        if (this.myFullName == null) {
            this.myFullName = String.format("%s.%s", this.myClassName, this.myName);
        }
        return this.myFullName;
    }

    @Override
    @NotNull
    public String getId() {
        if (this.myId == null) {
            this.myId = String.format("%s%s", this.getFullName(), this.mySignature);
        }
        return this.myId;
    }
}

