/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class CpuTreeModel<T extends CpuTreeNode<T>>
extends DefaultTreeModel {
    private final Range myRange;
    private final Range myCurrentRange;
    private final AspectObserver myAspectObserver;
    private final AspectModel<Aspect> myAspectModel;
    private final boolean myIsRootNodeIdValid;

    public CpuTreeModel(@NotNull Range range, @NotNull T node) {
        super(new DefaultMutableTreeNode(node));
        this.myIsRootNodeIdValid = !((CpuTreeNode)node).getId().isEmpty();
        this.myRange = range;
        this.myCurrentRange = new Range();
        this.myAspectModel = new AspectModel();
        this.myAspectObserver = new AspectObserver();
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::rangeChanged);
        this.rangeChanged();
    }

    @NotNull
    public AspectModel<Aspect> getAspect() {
        return this.myAspectModel;
    }

    public boolean isRootNodeIdValid() {
        return this.myIsRootNodeIdValid;
    }

    public void rangeChanged() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        LinkedList<Range> diffs = new LinkedList<Range>();
        diffs.addAll(this.myRange.subtract(this.myCurrentRange));
        diffs.addAll(this.myCurrentRange.subtract(this.myRange));
        this.update(root, this.myRange, diffs);
        this.myCurrentRange.set(this.myRange);
        this.myAspectModel.changed((Enum)Aspect.TREE_MODEL);
    }

    public boolean changes(T data, List<Range> ranges) {
        for (Range diff : ranges) {
            if (!((CpuTreeNode)data).inRange(diff)) continue;
            return true;
        }
        return false;
    }

    private void update(DefaultMutableTreeNode node, Range range, List<Range> ranges) {
        CpuTreeNode data = (CpuTreeNode)node.getUserObject();
        if (this.changes(data, ranges)) {
            Enumeration<TreeNode> e = node.children();
            HashMap<CpuTreeNode, DefaultMutableTreeNode> children2 = new HashMap<CpuTreeNode, DefaultMutableTreeNode>();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                children2.put((CpuTreeNode)child.getUserObject(), child);
            }
            HashSet<CpuTreeNode> actual = new HashSet<CpuTreeNode>();
            for (CpuTreeNode cpuTreeNode : data.getChildren()) {
                if (cpuTreeNode.inRange(range)) {
                    actual.add(cpuTreeNode);
                    DefaultMutableTreeNode existing = (DefaultMutableTreeNode)children2.get(cpuTreeNode);
                    if (existing == null) {
                        existing = new DefaultMutableTreeNode(cpuTreeNode);
                        this.insertNodeInto(existing, node, node.getChildCount());
                    }
                    this.update(existing, range, ranges);
                    continue;
                }
                cpuTreeNode.reset();
            }
            for (Map.Entry entry : children2.entrySet()) {
                if (actual.contains(entry.getKey())) continue;
                this.removeNodeFromParent((MutableTreeNode)entry.getValue());
            }
            data.update(range);
            this.nodeChanged(node);
        }
    }

    @NotNull
    public Range getRange() {
        return this.myRange;
    }

    public boolean isEmpty() {
        CpuTreeNode data = (CpuTreeNode)((DefaultMutableTreeNode)this.getRoot()).getUserObject();
        return data.getGlobalTotal() == 0.0;
    }

    abstract void expand(@NotNull DefaultMutableTreeNode var1);

    public static enum Aspect {
        TREE_MODEL;

    }
}

