/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.cpu.StatusPanel;
import com.android.tools.profilers.cpu.StatusPanelModel;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.android.tools.profilers.cpu.capturedetails.DetailsCapturePane;
import com.android.tools.profilers.cpu.capturedetails.RecordingInitiatorPane;
import com.google.common.annotations.VisibleForTesting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureView {
    @NotNull
    private final CpuProfilerStageView myStageView;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private CapturePane myCapturePane;
    @NotNull
    private final AspectObserver myObserver;

    public CpuCaptureView(@NotNull CpuProfilerStageView stageView) {
        this.myStageView = stageView;
        this.myStage = (CpuProfilerStage)stageView.getStage();
        this.myPanel = new JPanel(new BorderLayout());
        this.myObserver = new AspectObserver();
        this.myCapturePane = this.createCapturePane();
        this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_DETAILS, this::updateCaptureDetails).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, this::onCaptureStateChanged).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::updateCapturePane);
        this.myStage.getCaptureParser().getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_PARSING, this::updateCapturePane);
        this.updateCapturePane();
    }

    private void updateCaptureDetails() {
        this.myCapturePane.updateView();
    }

    private void onCaptureStateChanged() {
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.STARTING) {
            return;
        }
        this.updateCapturePane();
    }

    private void updateCapturePane() {
        this.myPanel.removeAll();
        this.myCapturePane = this.createCapturePane();
        this.myPanel.add((Component)this.myCapturePane, "Center");
        this.myPanel.revalidate();
    }

    @NotNull
    private CapturePane createCapturePane() {
        if (this.myStage.getCaptureParser().isParsing()) {
            return new ParsingPane(this.myStageView);
        }
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.STOPPING) {
            return new StoppingPane(this.myStageView);
        }
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            return new RecordingPane(this.myStageView);
        }
        if (this.myStage.getCapture() == null) {
            return new RecordingInitiatorPane(this.myStageView);
        }
        return new DetailsCapturePane(this.myStageView);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    static class CpuCaptureViewStatusModel
    implements StatusPanelModel {
        protected Range myRange = new Range(0.0, 0.0);
        protected CpuProfilerStage myStage;
        private AspectObserver myObserver = new AspectObserver();
        private long myStartTimeNs;

        CpuCaptureViewStatusModel(CpuProfilerStage stage, long durationStartTimeNs) {
            this.myStage = stage;
            this.myStartTimeNs = durationStartTimeNs;
            this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME, this::updateDuration);
        }

        @Override
        @NotNull
        public String getConfigurationText() {
            return ProfilingTechnology.fromConfig(this.myStage.getProfilerConfigModel().getProfilingConfiguration()).getName();
        }

        @Override
        @NotNull
        public Range getRange() {
            return this.myRange;
        }

        @Override
        public void abort() {
            this.myStage.toggleCapturing();
        }

        protected void updateDuration() {
            this.myRange.setMax((double)(this.myStage.currentTimeNs() - this.myStartTimeNs));
        }
    }

    static class CpuParsingViewStatusModel
    extends CpuCaptureViewStatusModel {
        CpuParsingViewStatusModel(CpuProfilerStage stage) {
            super(stage, -1L);
        }

        @Override
        public void abort() {
            this.myStage.getCaptureParser().abortParsing();
            this.myStage.setCaptureState(CpuProfilerStage.CaptureState.IDLE);
        }

        @Override
        protected void updateDuration() {
            this.myRange.setMax((double)TimeUnit.MILLISECONDS.toNanos(this.myStage.getCaptureParser().getParsingElapsedTimeMs()));
        }
    }

    @VisibleForTesting
    static class ParsingPane
    extends CapturePane {
        static final String ABORT_BUTTON_TEXT = "Abort";

        ParsingPane(@NotNull CpuProfilerStageView stageView) {
            super(stageView);
            this.disableInteraction();
            this.updateView();
        }

        @Override
        void populateContent(@NotNull JPanel panel2) {
            panel2.add((Component)new StatusPanel(new CpuParsingViewStatusModel((CpuProfilerStage)this.myStageView.getStage()), "Parsing", ABORT_BUTTON_TEXT), "Center");
        }
    }

    @VisibleForTesting
    static class StoppingPane
    extends CapturePane {
        static final String STATUS_TEXT = "Waiting for the recording to stop";
        private final StatusPanel myPanel;

        StoppingPane(@NotNull CpuProfilerStageView stageView) {
            super(stageView);
            this.myPanel = new StatusPanel(new CpuCaptureViewStatusModel((CpuProfilerStage)stageView.getStage(), ((CpuProfilerStage)stageView.getStage()).getCaptureStopTimeNs()), STATUS_TEXT, null);
            this.disableInteraction();
            this.updateView();
        }

        @Override
        void populateContent(@NotNull JPanel panel2) {
            panel2.add((Component)this.myPanel, "Center");
        }
    }

    @VisibleForTesting
    static class RecordingPane
    extends CapturePane {
        private final StatusPanel myPanel;
        private final AspectObserver myObserver = new AspectObserver();

        RecordingPane(@NotNull CpuProfilerStageView stageView) {
            super(stageView);
            this.myPanel = new StatusPanel(new CpuCaptureViewStatusModel((CpuProfilerStage)stageView.getStage(), ((CpuProfilerStage)stageView.getStage()).getCaptureStartTimeNs()), "Recording", "Stop");
            this.myPanel.setAbortButtonEnabled(!((CpuProfilerStage)stageView.getStage()).isApiInitiatedTracingInProgress());
            ((CpuProfilerStage)stageView.getStage()).getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, () -> this.myPanel.setAbortButtonEnabled(false));
            this.disableInteraction();
            this.updateView();
        }

        @Override
        void populateContent(@NotNull JPanel panel2) {
            panel2.add((Component)this.myPanel, "Center");
        }
    }
}

