/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class BottomUpNode
extends CpuTreeNode<BottomUpNode> {
    private final List<CaptureNode> myPathNodes = new ArrayList<CaptureNode>();
    private final boolean myIsRoot;
    private boolean myChildrenBuilt;

    private BottomUpNode(String id) {
        super(id);
        this.myIsRoot = false;
        this.myChildrenBuilt = false;
    }

    public BottomUpNode(@NotNull CaptureNode node) {
        super("Root");
        this.myIsRoot = true;
        this.myChildrenBuilt = true;
        HashMap<String, BottomUpNode> children2 = new HashMap<String, BottomUpNode>();
        HashMap<String, BottomUpNode> unmatchedChildren = new HashMap<String, BottomUpNode>();
        Stack<CaptureNode> stack = new Stack<CaptureNode>();
        stack.add(node);
        while (!stack.isEmpty()) {
            BottomUpNode child;
            CaptureNode curNode = (CaptureNode)stack.pop();
            for (int i2 = curNode.getChildren().size() - 1; i2 >= 0; --i2) {
                stack.add(curNode.getChildren().get(i2));
            }
            if (curNode.getData().getId().isEmpty()) continue;
            String curId = curNode.getData().getId();
            BottomUpNode bottomUpNode = child = curNode.isUnmatched() ? (BottomUpNode)unmatchedChildren.get(curId) : (BottomUpNode)children2.get(curId);
            if (child == null) {
                child = new BottomUpNode(curId);
                if (curNode.isUnmatched()) {
                    unmatchedChildren.put(curId, child);
                } else {
                    children2.put(curId, child);
                }
                this.addChild(child);
            }
            child.addPathNode(curNode);
            child.addNode(curNode);
        }
        this.addNode(node);
        for (BottomUpNode child : this.getChildren()) {
            child.buildChildren();
        }
    }

    private void addPathNode(@NotNull CaptureNode node) {
        this.myPathNodes.add(node);
    }

    public boolean buildChildren() {
        if (this.myChildrenBuilt) {
            return false;
        }
        HashMap<String, BottomUpNode> children2 = new HashMap<String, BottomUpNode>();
        HashMap<String, BottomUpNode> unmatchedChildren = new HashMap<String, BottomUpNode>();
        assert (this.myPathNodes.size() == this.getNodes().size());
        for (int i2 = 0; i2 < this.myPathNodes.size(); ++i2) {
            BottomUpNode child;
            CaptureNode parent = this.myPathNodes.get(i2).getParent();
            if (parent == null) continue;
            String parentId = parent.getData().getId();
            BottomUpNode bottomUpNode = child = parent.isUnmatched() ? (BottomUpNode)unmatchedChildren.get(parentId) : (BottomUpNode)children2.get(parentId);
            if (child == null) {
                child = new BottomUpNode(parentId);
                if (parent.isUnmatched()) {
                    unmatchedChildren.put(parentId, child);
                } else {
                    children2.put(parentId, child);
                }
                this.addChild(child);
            }
            child.addPathNode(parent);
            child.addNode(this.getNodes().get(i2));
        }
        this.myChildrenBuilt = true;
        return true;
    }

    @Override
    public void update(@NotNull Range range) {
        this.myGlobalTotal = 0.0;
        double self = 0.0;
        HashMap<CaptureNode, CaptureNode> outerSoFarByParent = new HashMap<CaptureNode, CaptureNode>();
        for (CaptureNode node : this.myNodes) {
            CaptureNode root = node.findRootNode();
            CaptureNode outerSoFar = outerSoFarByParent.getOrDefault(root, null);
            if (outerSoFar == null || node.getEnd() > outerSoFar.getEnd()) {
                if (outerSoFar != null) {
                    this.myGlobalTotal += BottomUpNode.getIntersection(range, outerSoFar, ClockType.GLOBAL);
                }
                outerSoFarByParent.put(root, node);
            }
            self += BottomUpNode.getIntersection(range, node, ClockType.GLOBAL);
            for (CaptureNode child : node.getChildren()) {
                self -= BottomUpNode.getIntersection(range, child, ClockType.GLOBAL);
            }
        }
        for (CaptureNode outerSoFar : outerSoFarByParent.values()) {
            this.myGlobalTotal += BottomUpNode.getIntersection(range, outerSoFar, ClockType.GLOBAL);
        }
        this.myGlobalChildrenTotal = this.myGlobalTotal - self;
    }

    @Override
    @NotNull
    public CaptureNodeModel getMethodModel() {
        if (this.myIsRoot) {
            return new SingleNameModel("");
        }
        return this.myPathNodes.get(0).getData();
    }

    @Override
    public CaptureNode.FilterType getFilterType() {
        if (this.myIsRoot) {
            return CaptureNode.FilterType.MATCH;
        }
        return this.myPathNodes.get(0).getFilterType();
    }
}

