/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.trackgroup.SelectableTrackModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisStats;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CaptureNodeAnalysisModel
implements CpuAnalyzable<CaptureNodeAnalysisModel> {
    @NotNull
    private final CaptureNode myNode;
    @NotNull
    private final CpuCapture myCapture;

    public CaptureNodeAnalysisModel(@NotNull CaptureNode node, @NotNull CpuCapture capture) {
        this.myNode = node;
        this.myCapture = capture;
    }

    @NotNull
    public CaptureNode getNode() {
        return this.myNode;
    }

    @NotNull
    public Range getNodeRange() {
        return new Range((double)this.myNode.getStart(), (double)this.myNode.getEnd());
    }

    @NotNull
    public List<CaptureNode> getLongestRunningOccurrences(int k) {
        return this.myNode.findRootNode().getTopKNodes(k, this::matchesFullName, Comparator.comparing(HNode::getDuration));
    }

    @NotNull
    public CaptureNodeAnalysisStats getAllOccurrenceStats() {
        List allOccurrences = this.myNode.findRootNode().getDescendantsStream().filter(this::matchesFullName).collect(Collectors.toList());
        return CaptureNodeAnalysisStats.Companion.fromNodes(allOccurrences);
    }

    private boolean matchesFullName(@NotNull CaptureNode node) {
        return this.myNode.getData().getFullName().equals(node.getData().getFullName());
    }

    @Override
    @NotNull
    public CpuAnalysisModel<CaptureNodeAnalysisModel> getAnalysisModel() {
        CpuAnalysisModel<CaptureNodeAnalysisModel> model = new CpuAnalysisModel<CaptureNodeAnalysisModel>(this.myNode.getData().getName(), "%d events");
        Range nodeRange = this.getNodeRange();
        Set<CaptureNode> nodes = Collections.singleton(this.myNode);
        CaptureNodeAnalysisSummaryTabModel summary = new CaptureNodeAnalysisSummaryTabModel(this.myCapture.getRange(), this.myCapture.getType());
        summary.getDataSeries().add(this);
        model.addTabModel(summary);
        CpuAnalysisChartModel<CaptureNodeAnalysisModel> flameChart = new CpuAnalysisChartModel<CaptureNodeAnalysisModel>(CpuAnalysisTabModel.Type.FLAME_CHART, nodeRange, this.myCapture, unused -> nodes);
        flameChart.getDataSeries().add(this);
        model.addTabModel(flameChart);
        CpuAnalysisChartModel<CaptureNodeAnalysisModel> topDown = new CpuAnalysisChartModel<CaptureNodeAnalysisModel>(CpuAnalysisTabModel.Type.TOP_DOWN, nodeRange, this.myCapture, unused -> nodes);
        topDown.getDataSeries().add(this);
        model.addTabModel(topDown);
        CpuAnalysisChartModel<CaptureNodeAnalysisModel> bottomUp = new CpuAnalysisChartModel<CaptureNodeAnalysisModel>(CpuAnalysisTabModel.Type.BOTTOM_UP, nodeRange, this.myCapture, unused -> nodes);
        bottomUp.getDataSeries().add(this);
        model.addTabModel(bottomUp);
        CaptureNodeAnalysisEventsTabModel events = new CaptureNodeAnalysisEventsTabModel(this.myCapture.getRange());
        events.getDataSeries().add(this);
        model.addTabModel(events);
        return model;
    }

    public boolean isCompatibleWith(@NotNull SelectableTrackModel otherObj) {
        return otherObj instanceof CaptureNodeAnalysisModel;
    }
}

