/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

class TraceIdsIterator {
    static final long INVALID_TRACE_ID = -1L;
    private final CpuProfilerStage myStage;
    private final List<Long> myTraceIds;

    public TraceIdsIterator(CpuProfilerStage stage, List<Cpu.CpuTraceInfo> initialTraceInfo) {
        this.myStage = stage;
        this.myTraceIds = TraceIdsIterator.getOrderedInitialTraceIds(initialTraceInfo);
    }

    private static List<Long> getOrderedInitialTraceIds(List<Cpu.CpuTraceInfo> initialTraceInfo) {
        ArrayList<Cpu.CpuTraceInfo> allTraceInfo = new ArrayList<Cpu.CpuTraceInfo>(initialTraceInfo);
        allTraceInfo.sort(Comparator.comparingLong(Cpu.CpuTraceInfo::getFromTimestamp));
        ArrayList<Long> traceIds = new ArrayList<Long>();
        allTraceInfo.forEach(traceInfo -> traceIds.add(traceInfo.getTraceId()));
        return traceIds;
    }

    public boolean hasNext() {
        return this.findNextTraceId() != -1L;
    }

    public long next() {
        return this.findNextTraceId();
    }

    private long findNextTraceId() {
        if (this.myTraceIds.isEmpty()) {
            return -1L;
        }
        if (this.myStage.getCapture() == null) {
            return this.myTraceIds.get(0);
        }
        int currentTraceIdIndex = this.myTraceIds.indexOf(this.myStage.getCapture().getTraceId());
        assert (currentTraceIdIndex >= 0);
        if (currentTraceIdIndex == this.myTraceIds.size() - 1) {
            return -1L;
        }
        return this.myTraceIds.get(currentTraceIdIndex + 1);
    }

    public boolean hasPrevious() {
        return this.findPreviousTraceId() != -1L;
    }

    public long previous() {
        return this.findPreviousTraceId();
    }

    private long findPreviousTraceId() {
        if (this.myTraceIds.isEmpty()) {
            return -1L;
        }
        if (this.myStage.getCapture() == null) {
            return this.myTraceIds.get(this.myTraceIds.size() - 1);
        }
        int currentTraceIdIndex = this.myTraceIds.indexOf(this.myStage.getCapture().getTraceId());
        assert (currentTraceIdIndex >= 0);
        if (currentTraceIdIndex == 0) {
            return -1L;
        }
        return this.myTraceIds.get(currentTraceIdIndex - 1);
    }

    public void addTrace(long traceId) {
        this.myTraceIds.add(traceId);
    }

    public boolean contains(long traceId) {
        return this.myTraceIds.contains(traceId);
    }
}

