/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LegacyCpuThreadCountDataSeries
implements DataSeries<Long> {
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myClient;
    private final Common.Session mySession;

    public LegacyCpuThreadCountDataSeries(@NotNull CpuServiceGrpc.CpuServiceBlockingStub client, Common.Session session) {
        this.myClient = client;
        this.mySession = session;
    }

    public List<SeriesData<Long>> getDataForRange(@NotNull Range timeCurrentRangeUs) {
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        CpuProfiler.GetThreadsRequest.Builder request = CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        CpuProfiler.GetThreadsResponse response = this.myClient.getThreads(request.build());
        TreeMap<Long, Long> count2 = new TreeMap<Long, Long>();
        for (CpuProfiler.GetThreadsResponse.Thread thread2 : response.getThreadsList()) {
            if (thread2.getActivitiesCount() <= 0) continue;
            CpuProfiler.GetThreadsResponse.ThreadActivity first = thread2.getActivities(0);
            CpuProfiler.GetThreadsResponse.ThreadActivity last = thread2.getActivities(thread2.getActivitiesCount() - 1);
            Long current = (Long)count2.get(first.getTimestamp());
            count2.put(first.getTimestamp(), current == null ? 1L : current + 1L);
            if (last.getNewState() != Cpu.CpuThreadData.State.DEAD) continue;
            current = (Long)count2.get(last.getTimestamp());
            count2.put(last.getTimestamp(), current == null ? -1L : current - 1L);
        }
        ArrayList<SeriesData<Long>> data = new ArrayList<SeriesData<Long>>();
        long total = 0L;
        for (Map.Entry entry : count2.entrySet()) {
            data.add((SeriesData<Long>)new SeriesData(TimeUnit.NANOSECONDS.toMicros((Long)entry.getKey()), (Object)(total += ((Long)entry.getValue()).longValue())));
        }
        if (count2.isEmpty()) {
            data.add(new SeriesData((long)timeCurrentRangeUs.getMin(), (Object)total));
            data.add((SeriesData<Long>)new SeriesData((long)timeCurrentRangeUs.getMax(), (Object)total));
        } else if ((double)((SeriesData)data.get((int)(data.size() - 1))).x < timeCurrentRangeUs.getMax()) {
            data.add((SeriesData<Long>)new SeriesData((long)timeCurrentRangeUs.getMax(), (Object)total));
        }
        return data;
    }
}

