/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import org.jetbrains.annotations.NotNull;

public class CpuThreadInfo
implements Comparable<CpuThreadInfo> {
    public static final String RENDER_THREAD_NAME = "RenderThread";
    private final int myId;
    private final String myName;
    private final boolean myIsMainThread;

    public CpuThreadInfo(int threadId, String name, boolean isMainThread) {
        this.myId = threadId;
        this.myName = name;
        this.myIsMainThread = isMainThread;
    }

    public CpuThreadInfo(int threadId, String name) {
        this(threadId, name, false);
    }

    public int getId() {
        return this.myId;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public boolean isMainThread() {
        return this.myIsMainThread;
    }

    public boolean isRenderThread() {
        return this.getName().equals(RENDER_THREAD_NAME);
    }

    @Override
    public int compareTo(@NotNull CpuThreadInfo o) {
        if (this.isMainThread()) {
            return -1;
        }
        if (o.isMainThread()) {
            return 1;
        }
        boolean thisIsRenderThread = this.isRenderThread();
        boolean otherIsRenderThread = o.isRenderThread();
        if (thisIsRenderThread && otherIsRenderThread) {
            return this.getId() - o.getId();
        }
        if (thisIsRenderThread) {
            return -1;
        }
        if (otherIsRenderThread) {
            return 1;
        }
        int nameResult = this.getName().compareTo(o.getName());
        if (nameResult == 0) {
            return this.getId() - o.getId();
        }
        return nameResult;
    }

    public String toString() {
        return this.getName() + ":" + this.getId();
    }
}

