/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.config.CpuProfilingConfigurationView;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class CpuProfilerToolbar {
    public static final String RECORD_TEXT = "Record";
    public static final String STOP_TEXT = "Stop";
    @NotNull
    protected final CpuProfilerStage myStage;
    @NotNull
    protected final JPanel myPanel;

    protected CpuProfilerToolbar(@NotNull CpuProfilerStage stage) {
        this.myStage = stage;
        this.myPanel = new JPanel();
    }

    @NotNull
    JComponent getComponent() {
        return this.myPanel;
    }

    abstract void update();

    static final class ImportMode
    extends CpuProfilerToolbar {
        @NotNull
        private final JLabel mySelectedProcessLabel = new JLabel();

        ImportMode(@NotNull CpuProfilerStage stage) {
            super(stage);
            this.myPanel.setLayout((LayoutManager)new TabularLayout("8px,*", "*"));
            this.myPanel.add((Component)this.mySelectedProcessLabel, new TabularLayout.Constraint(0, 1));
            this.update();
        }

        @Override
        void update() {
            assert (this.myStage.isImportTraceMode());
            this.mySelectedProcessLabel.setText("");
            CpuCapture capture = this.myStage.getCapture();
            if (capture == null) {
                return;
            }
            if (capture.getType() == Cpu.CpuTraceType.ATRACE) {
                CaptureNode node = capture.getCaptureNode(capture.getMainThreadId());
                assert (node != null);
                this.mySelectedProcessLabel.setText("Process: " + node.getData().getName());
            }
        }
    }

    static final class NormalMode
    extends CpuProfilerToolbar {
        @NotNull
        private final CpuProfilingConfigurationView myProfilingConfigurationView;
        @NotNull
        private final JButton myCaptureButton;

        public NormalMode(@NotNull CpuProfilerStage stage, @NotNull IdeProfilerComponents ideComponents) {
            super(stage);
            this.myProfilingConfigurationView = new CpuProfilingConfigurationView(this.myStage, ideComponents);
            this.myCaptureButton = new JButton(CpuProfilerToolbar.RECORD_TEXT);
            this.myCaptureButton.setPreferredSize((Dimension)JBDimension.create((Dimension)this.myCaptureButton.getPreferredSize()).withHeight((int)this.myProfilingConfigurationView.getComponent().getPreferredSize().getHeight()));
            this.myCaptureButton.addActionListener(event -> this.myStage.toggleCapturing());
            JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
            toolbar.add(this.myProfilingConfigurationView.getComponent());
            toolbar.add(this.myCaptureButton);
            this.myPanel.setLayout(new BorderLayout());
            this.myPanel.add((Component)toolbar, "West");
            this.update();
        }

        @Override
        void update() {
            switch (this.myStage.getCaptureState()) {
                case IDLE: {
                    this.myCaptureButton.setEnabled(this.shouldEnableCaptureButton());
                    this.myCaptureButton.setText(CpuProfilerToolbar.RECORD_TEXT);
                    this.myProfilingConfigurationView.getComponent().setEnabled(true);
                    break;
                }
                case CAPTURING: {
                    if (this.myStage.getCaptureInitiationType().equals((Object)Cpu.TraceInitiationType.INITIATED_BY_API)) {
                        this.myCaptureButton.setEnabled(false);
                    } else {
                        this.myCaptureButton.setEnabled(this.shouldEnableCaptureButton());
                    }
                    this.myCaptureButton.setText(CpuProfilerToolbar.STOP_TEXT);
                    this.myProfilingConfigurationView.getComponent().setEnabled(false);
                    break;
                }
                case STARTING: {
                    this.myCaptureButton.setEnabled(false);
                    this.myCaptureButton.setToolTipText("");
                    this.myProfilingConfigurationView.getComponent().setEnabled(false);
                    break;
                }
                case STOPPING: {
                    this.myCaptureButton.setEnabled(false);
                    this.myCaptureButton.setToolTipText("");
                    this.myProfilingConfigurationView.getComponent().setEnabled(false);
                }
            }
        }

        private boolean shouldEnableCaptureButton() {
            return this.myStage.getStudioProfilers().getSessionsManager().isSessionAlive() && !this.myStage.isApiInitiatedTracingInProgress();
        }
    }
}

