/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.CpuUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureMinimapModel {
    @NotNull
    private final Range myCaptureRange;
    @NotNull
    private final RangeSelectionModel myRangeSelectionModel;
    @NotNull
    private final CpuUsage myCpuUsage;

    public CpuCaptureMinimapModel(@NotNull StudioProfilers profilers, @NotNull CpuCapture cpuCapture, @NotNull Range selectionRange) {
        this.myCaptureRange = cpuCapture.getRange();
        this.myCpuUsage = new CpuUsage(profilers, this.myCaptureRange, this.myCaptureRange, cpuCapture);
        this.myRangeSelectionModel = new RangeSelectionModel(selectionRange, new Range(this.myCaptureRange));
        this.myRangeSelectionModel.addConstraint(new DurationDataModel(new RangedSeries(this.myCaptureRange, (DataSeries)new DataSeries<CpuTraceInfo>(){

            public List<SeriesData<CpuTraceInfo>> getDataForRange(Range range) {
                ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
                if (CpuCaptureMinimapModel.this.myCaptureRange.intersectsWith(range)) {
                    CpuTraceInfo traceInfo = new CpuTraceInfo(Cpu.CpuTraceInfo.newBuilder().setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)CpuCaptureMinimapModel.this.myCaptureRange.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)CpuCaptureMinimapModel.this.myCaptureRange.getMax())).build());
                    seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)traceInfo.getRange().getMin(), (Object)traceInfo));
                }
                return seriesData;
            }
        })));
        this.myRangeSelectionModel.set(this.myCaptureRange.getMin(), this.myCaptureRange.getMax());
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        return this.myRangeSelectionModel;
    }

    @NotNull
    public CpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    @NotNull
    public Range getCaptureRange() {
        return this.myCaptureRange;
    }
}

