/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class UnifiedEventDataSeries<T>
implements DataSeries<T> {
    public static final int DEFAULT_GROUP_ID = 0;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    private final long myStreamId;
    private final int myPid;
    @NotNull
    private final Common.Event.Kind myKind;
    private final int myGroupId;
    @NotNull
    private final Function<List<Common.Event>, List<SeriesData<T>>> myDataExtractor;

    public UnifiedEventDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, long streamId, int pid, @NotNull Common.Event.Kind kind, int groupId, @NotNull Function<List<Common.Event>, List<SeriesData<T>>> dataExtractor) {
        this.myClient = client;
        this.myStreamId = streamId;
        this.myPid = pid;
        this.myKind = kind;
        this.myGroupId = groupId;
        this.myDataExtractor = dataExtractor;
    }

    public List<SeriesData<T>> getDataForRange(Range rangeUs) {
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(this.myKind).setGroupId((long)this.myGroupId).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(request);
        assert (response.getGroupsCount() <= 1);
        if (response.getGroupsCount() == 0) {
            return new ArrayList<SeriesData<T>>();
        }
        return this.myDataExtractor.apply(response.getGroups(0).getEventsList());
    }

    public static Function<List<Common.Event>, List<SeriesData<Long>>> fromFieldToDataExtractor(Function<Common.Event, Long> fieldExtractor) {
        return events -> events.stream().map(event -> new SeriesData(TimeUnit.NANOSECONDS.toMicros(event.getTimestamp()), fieldExtractor.apply((Common.Event)event))).collect(Collectors.toList());
    }
}

