/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.ProfilerTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProfilerService
extends ProfilerServiceGrpc.ProfilerServiceImplBase
implements ServicePassThrough {
    @NotNull
    private final LogService myLogService;
    private final ProfilerTable myTable;
    @NotNull
    private final DataStoreService myService;

    public ProfilerService(@NotNull DataStoreService service, @NotNull LogService logService) {
        this.myService = service;
        this.myLogService = logService;
        this.myTable = new ProfilerTable();
    }

    @NotNull
    private LogService.Logger getLogger() {
        return this.myLogService.getLogger(ProfilerService.class);
    }

    public void beginSession(Profiler.BeginSessionRequest request, StreamObserver<Profiler.BeginSessionResponse> responseObserver) {
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(request.getDeviceId());
        if (client == null) {
            responseObserver.onNext((Object)Profiler.BeginSessionResponse.getDefaultInstance());
        } else {
            Profiler.BeginSessionResponse response = client.beginSession(request);
            this.getLogger().info("Session (ID " + response.getSession().getSessionId() + ") begins.");
            this.myTable.insertOrUpdateSession(response.getSession(), request.getSessionName(), request.getRequestTimeEpochMs(), request.getProcessAbi(), request.getJvmtiConfig().getAttachAgent(), request.getJvmtiConfig().getLiveAllocationEnabled(), Common.SessionMetaData.SessionType.FULL);
            responseObserver.onNext((Object)response);
        }
        responseObserver.onCompleted();
    }

    public void endSession(Profiler.EndSessionRequest request, StreamObserver<Profiler.EndSessionResponse> responseObserver) {
        this.getLogger().info("Session (ID " + request.getSessionId() + ") ends.");
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(request.getDeviceId());
        if (client == null) {
            this.myTable.updateSessionEndTime(request.getSessionId(), request.getEndTimestamp());
            Common.Session session = this.myTable.getSessionById(request.getSessionId());
            responseObserver.onNext((Object)Profiler.EndSessionResponse.newBuilder().setSession(session).build());
        } else {
            Profiler.EndSessionResponse response = client.endSession(request);
            Common.Session session = response.getSession();
            this.myTable.updateSessionEndTime(session.getSessionId(), session.getEndTimestamp());
            responseObserver.onNext((Object)response);
        }
        responseObserver.onCompleted();
    }

    public void getSessionMetaData(Profiler.GetSessionMetaDataRequest request, StreamObserver<Profiler.GetSessionMetaDataResponse> responseObserver) {
        responseObserver.onNext((Object)this.myTable.getSessionMetaData(request.getSessionId()));
        responseObserver.onCompleted();
    }

    public void getSessions(Profiler.GetSessionsRequest request, StreamObserver<Profiler.GetSessionsResponse> responseObserver) {
        responseObserver.onNext((Object)this.myTable.getSessions());
        responseObserver.onCompleted();
    }

    public void deleteSession(Profiler.DeleteSessionRequest request, StreamObserver<Profiler.DeleteSessionResponse> responseObserver) {
        this.myTable.deleteSession(request.getSessionId());
        responseObserver.onNext((Object)Profiler.DeleteSessionResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void importSession(Profiler.ImportSessionRequest request, StreamObserver<Profiler.ImportSessionResponse> responseObserver) {
        this.myTable.insertOrUpdateSession(request.getSession(), request.getSessionName(), request.getStartTimestampEpochMs(), "", false, false, request.getSessionType());
        responseObserver.onNext((Object)Profiler.ImportSessionResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myTable.initialize(connection);
    }
}

