/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.StandardDimensions;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.jetbrains.annotations.NotNull;
import sun.swing.MenuItemLayoutHelper;

public class CommonMenuPaintHelper {
    private CommonMenuPaintHelper() {
    }

    public static void paintIcon(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult, @NotNull Color holdColor) {
        Icon icon;
        if (layoutHelper.getIcon() == null) {
            return;
        }
        ButtonModel model2 = layoutHelper.getMenuItem().getModel();
        if (!model2.isEnabled()) {
            icon = layoutHelper.getMenuItem().getDisabledIcon();
        } else if (model2.isPressed() && model2.isArmed()) {
            icon = layoutHelper.getMenuItem().getPressedIcon();
            if (icon == null) {
                icon = layoutHelper.getMenuItem().getIcon();
            }
        } else {
            icon = layoutHelper.getMenuItem().getIcon();
        }
        if (icon != null) {
            icon.paintIcon(layoutHelper.getMenuItem(), graphics, layoutResult.getIconRect().x, layoutResult.getIconRect().y);
            graphics.setColor(holdColor);
        }
    }

    public static void paintAccText(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult, @NotNull Color disabledForeground, @NotNull Color acceleratorForeground, @NotNull Color acceleratorSelectionForeground) {
        if (layoutHelper.getAccText().equals("")) {
            return;
        }
        ButtonModel model2 = layoutHelper.getMenuItem().getModel();
        graphics.setFont(layoutHelper.getAccFontMetrics().getFont());
        if (!model2.isEnabled()) {
            if (disabledForeground != null) {
                graphics.setColor(disabledForeground);
                UIUtilities.drawString((JComponent)layoutHelper.getMenuItem(), (Graphics)graphics, (String)layoutHelper.getAccText(), (int)layoutResult.getAccRect().x, (int)(layoutResult.getAccRect().y + layoutHelper.getAccFontMetrics().getAscent()));
            } else {
                graphics.setColor(layoutHelper.getMenuItem().getBackground().brighter());
                UIUtilities.drawString((JComponent)layoutHelper.getMenuItem(), (Graphics)graphics, (String)layoutHelper.getAccText(), (int)layoutResult.getAccRect().x, (int)(layoutResult.getAccRect().y + layoutHelper.getAccFontMetrics().getAscent()));
                graphics.setColor(layoutHelper.getMenuItem().getBackground().darker());
                UIUtilities.drawString((JComponent)layoutHelper.getMenuItem(), (Graphics)graphics, (String)layoutHelper.getAccText(), (int)(layoutResult.getAccRect().x - 1), (int)(layoutResult.getAccRect().y + layoutHelper.getFontMetrics().getAscent() - 1));
            }
        } else {
            if (model2.isArmed() || layoutHelper.getMenuItem() instanceof JMenu && model2.isSelected()) {
                graphics.setColor(acceleratorSelectionForeground);
            } else {
                graphics.setColor(acceleratorForeground);
            }
            UIUtilities.drawString((JComponent)layoutHelper.getMenuItem(), (Graphics)graphics, (String)layoutHelper.getAccText(), (int)layoutResult.getAccRect().x, (int)(layoutResult.getAccRect().y + layoutHelper.getAccFontMetrics().getAscent()));
        }
    }

    public static void paintArrowIcon(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult, @NotNull Color foreground) {
        if (layoutHelper.getArrowIcon() != null) {
            ButtonModel model2 = layoutHelper.getMenuItem().getModel();
            if (model2.isArmed() || layoutHelper.getMenuItem() instanceof JMenu && model2.isSelected()) {
                graphics.setColor(foreground);
            }
            if (layoutHelper.useCheckAndArrow()) {
                layoutHelper.getArrowIcon().paintIcon(layoutHelper.getMenuItem(), graphics, layoutResult.getArrowRect().x, layoutResult.getArrowRect().y);
            }
        }
    }

    public static void paintArrowIconCustom(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (layoutHelper.getArrowIcon() != null && layoutHelper.useCheckAndArrow()) {
            int arrowWidth = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_WIDTH();
            int arrowHeight = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HEIGHT();
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle rect = layoutResult.getArrowRect();
            float x = rect.x + (rect.width - arrowHeight);
            float y = (float)rect.y + (float)rect.height / 2.0f;
            Path2D.Float triangle = new Path2D.Float();
            triangle.moveTo(x + (float)arrowHeight, y);
            triangle.lineTo(x, y - (float)arrowWidth / 2.0f);
            triangle.lineTo(x, y + (float)arrowWidth / 2.0f);
            triangle.lineTo(x + (float)arrowHeight, y);
            GraphicsUtilKt.setColorAndAlpha(g2d, StandardColors.DROPDOWN_ARROW_COLOR);
            g2d.fill(triangle);
        }
    }

    public static void paintCheckIcon(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult, @NotNull Color holdColor, @NotNull Color foreground) {
        if (layoutHelper.getCheckIcon() != null) {
            ButtonModel model2 = layoutHelper.getMenuItem().getModel();
            if (model2.isArmed() || layoutHelper.getMenuItem() instanceof JMenu && model2.isSelected()) {
                graphics.setColor(foreground);
            } else {
                graphics.setColor(holdColor);
            }
            if (layoutHelper.useCheckAndArrow()) {
                layoutHelper.getCheckIcon().paintIcon(layoutHelper.getMenuItem(), graphics, layoutResult.getCheckRect().x, layoutResult.getCheckRect().y);
            }
            graphics.setColor(holdColor);
        }
    }
}

