/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.model.DefaultHNode;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultHRenderer<T>
implements HRenderer<DefaultHNode<T>> {
    protected static final JBColor fillVendorColor = new JBColor(new Color(146, 215, 248), new Color(146, 215, 248));
    protected static final JBColor borderVendorColor = new JBColor(new Color(115, 190, 233), new Color(115, 190, 233));
    protected static final JBColor fillPlatformColor = new JBColor(new Color(190, 225, 154), new Color(190, 225, 154));
    protected static final JBColor borderPlatformColor = new JBColor(new Color(159, 208, 110), new Color(159, 208, 110));
    protected static final JBColor fillAppColor = new JBColor(new Color(245, 192, 118), new Color(245, 192, 118));
    protected static final JBColor borderAppColor = new JBColor(new Color(235, 163, 63), new Color(235, 163, 63));
    private Rectangle2D.Float mRect;
    private Function<Color, Color> myAdjustFocusedColor;

    public DefaultHRenderer() {
        this(color -> color);
    }

    public DefaultHRenderer(@NotNull Function<Color, Color> adjustFocusedColor) {
        this.myAdjustFocusedColor = adjustFocusedColor;
        this.mRect = new Rectangle2D.Float();
    }

    @Override
    public final void render(@NotNull Graphics2D g, @NotNull DefaultHNode<T> node, @NotNull Rectangle2D fullDrawingArea, @NotNull Rectangle2D drawingArea, boolean isFocused, boolean isDeselected) {
        this.mRect.x = (float)drawingArea.getX();
        this.mRect.y = (float)drawingArea.getY();
        this.mRect.width = (float)drawingArea.getWidth();
        this.mRect.height = (float)drawingArea.getHeight();
        Color fillColor = this.getFillColor(node.getData());
        if (isFocused) {
            fillColor = this.myAdjustFocusedColor.apply(fillColor);
        }
        g.setPaint(fillColor);
        g.fill(this.mRect);
        FontMetrics fontMetrics = g.getFontMetrics(g.getFont());
        String text = this.generateFittingText(node.getData(), drawingArea, fontMetrics);
        g.setPaint(Color.BLACK);
        this.renderText(g, text, this.mRect, fontMetrics);
    }

    protected abstract String generateFittingText(@NotNull T var1, @NotNull Rectangle2D var2, @NotNull FontMetrics var3);

    protected abstract Color getFillColor(@NotNull T var1);

    private void renderText(Graphics2D g, String text, Rectangle2D.Float rect, FontMetrics fontMetrics) {
        float textPositionY = (float)(rect.getY() + (double)fontMetrics.getAscent());
        g.drawString(text, rect.x, textPositionY);
    }
}

