/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RangeTooltipComponent
extends AnimatedComponent {
    public static final Color HIGHLIGHT_COLOR = new JBColor(4882943, 7910143);
    private static final float HIGHLIGHT_WIDTH = 2.0f;
    private static final float INVALID_HIGHLIGHT_X = -3.4028235E38f;
    private float myOldHighlightX = -3.4028235E38f;
    @NotNull
    private final Timeline myTimeline;
    @NotNull
    private final TooltipComponent myTooltipComponent;
    @NotNull
    private final Supplier<Boolean> myShowSeekComponent;
    @Nullable
    private Point myLastPoint;

    public RangeTooltipComponent(@NotNull Timeline timeline, @NotNull JComponent component, @NotNull JLayeredPane parent, @NotNull Supplier<Boolean> showSeekComponent) {
        this.myTimeline = timeline;
        this.myShowSeekComponent = showSeekComponent;
        this.myTooltipComponent = new TooltipComponent.Builder(component, this, parent).setDefaultVisibilityOverride(() -> this.isHighlightRangeVisible()).setEnableAntiFlap(timeline instanceof StreamingTimeline).build();
        this.myTimeline.getViewRange().addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::refreshRanges);
        this.myTimeline.getTooltipRange().addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::tooltipRangeChanged);
    }

    @VisibleForTesting
    public RangeTooltipComponent(Timeline timeline, @NotNull JComponent component) {
        this(timeline, component, new JLayeredPane(), () -> true);
    }

    public void registerListenersOn(@NotNull JComponent component) {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RangeTooltipComponent.this.myLastPoint = null;
                RangeTooltipComponent.this.myTimeline.getTooltipRange().clear();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            private void handleMove(MouseEvent e) {
                Point nextPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), RangeTooltipComponent.this);
                if (RangeTooltipComponent.this.myLastPoint != null && RangeTooltipComponent.this.myLastPoint.equals(nextPoint)) {
                    return;
                }
                RangeTooltipComponent.this.myLastPoint = nextPoint;
                RangeTooltipComponent.this.refreshRanges();
            }
        };
        component.addMouseMotionListener(adapter);
        component.addMouseListener(adapter);
        this.myTooltipComponent.registerListenersOn(component);
    }

    private void refreshRanges() {
        if (this.isShowing()) {
            if (this.myLastPoint != null) {
                double current = this.xToRange(this.myLastPoint.x);
                this.myTimeline.getTooltipRange().set(current, current);
            } else {
                this.myTimeline.getTooltipRange().clear();
            }
        }
    }

    private void tooltipRangeChanged() {
        if (this.myTimeline.getTooltipRange().isEmpty() && this.myOldHighlightX == -3.4028235E38f) {
            return;
        }
        if (this.myOldHighlightX != -3.4028235E38f) {
            int minX = (int)Math.floor((double)this.myOldHighlightX - 1.0);
            int width = (int)Math.ceil((double)this.myOldHighlightX + 1.0) - minX;
            this.opaqueRepaint(minX, 0, width, this.getHeight());
            this.myOldHighlightX = -3.4028235E38f;
        }
        if (this.isHighlightRangeVisible() && this.myShowSeekComponent.get().booleanValue()) {
            float x = this.rangeToX(this.myTimeline.getTooltipRange().getMin());
            int minX = (int)Math.floor((double)x - 1.0);
            int width = (int)Math.ceil((double)x + 1.0) - minX;
            this.opaqueRepaint(minX, 0, width, this.getHeight());
        }
        this.myTooltipComponent.setVisible(this.isHighlightRangeVisible());
    }

    @VisibleForTesting
    double xToRange(int x) {
        return (double)x / (double)this.getWidth() * this.myTimeline.getViewRange().getLength() + this.myTimeline.getViewRange().getMin();
    }

    @VisibleForTesting
    float rangeToX(double value) {
        return (float)((double)this.getWidth() * (value - this.myTimeline.getViewRange().getMin()) / (this.myTimeline.getViewRange().getMax() - this.myTimeline.getViewRange().getMin()));
    }

    private boolean isHighlightRangeVisible() {
        return this.myLastPoint != null && !this.myTimeline.getTooltipRange().isEmpty() && this.myTimeline.getTooltipRange().getMin() >= this.myTimeline.getDataRange().getMin();
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (!this.isHighlightRangeVisible()) {
            return;
        }
        if (this.myShowSeekComponent.get().booleanValue()) {
            float x;
            this.myOldHighlightX = x = this.rangeToX(this.myTimeline.getTooltipRange().getMin());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(HIGHLIGHT_COLOR);
            g.setStroke(new BasicStroke(2.0f));
            Path2D.Float path = new Path2D.Float();
            path.moveTo(x, 0.0f);
            path.lineTo(x, this.getHeight());
            g.draw(path);
        }
    }
}

