/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.NotNull;

public class HtmlLabel
extends JEditorPane {
    public HtmlLabel() {
        this.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String uri = event.getDescription();
                    try {
                        BrowserLauncher.getInstance().browse(new URI(uri));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static void setUpAsHtmlLabel(@NotNull JEditorPane editorPane) {
        HtmlLabel.setUpAsHtmlLabel(editorPane, UIUtil.getLabelFont());
    }

    public static void setUpAsHtmlLabel(@NotNull JEditorPane editorPane, @NotNull Font font) {
        HtmlLabel.setUpAsHtmlLabel(editorPane, font, "");
    }

    public static void setUpAsHtmlLabel(@NotNull JEditorPane editorPane, @NotNull Font font, @NotNull Color c) {
        String color = String.format("#%02x%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        HtmlLabel.setUpAsHtmlLabel(editorPane, font, "color: " + color + ";");
    }

    private static void setUpAsHtmlLabel(@NotNull JEditorPane editorPane, @NotNull Font font, @NotNull String color) {
        editorPane.setEditorKit(UIUtil.getHTMLEditorKit());
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; " + color + " } ol { padding-left: 0px; margin-left: 35px; margin-top: 0px; } ol li { margin-left: 0px; padding-left: 0px; list-style-type: decimal; }";
        ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        String linkColor = "#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkColor());
        ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule("a { color: " + linkColor + "; text-decoration: none;}");
    }
}

