/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project.dependencies;

import com.intellij.openapi.externalSystem.model.project.dependencies.AbstractDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.serialization.PropertyMapping;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectDependencyNodeImpl
extends AbstractDependencyNode
implements ProjectDependencyNode {
    private final String projectName;

    @PropertyMapping(value={"id", "projectName"})
    public ProjectDependencyNodeImpl(long id, @NotNull String projectName) {
        super(id);
        this.projectName = projectName;
    }

    @Override
    @NotNull
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    @NonNls
    @NotNull
    public String getDisplayName() {
        return "project " + this.projectName;
    }

    @Override
    public boolean match(AbstractDependencyNode dependencyNode) {
        if (dependencyNode == null || this.getClass() != dependencyNode.getClass()) {
            return false;
        }
        ProjectDependencyNodeImpl node = (ProjectDependencyNodeImpl)dependencyNode;
        return this.projectName.equals(node.projectName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.projectName.hashCode();
        return result;
    }
}

