/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project.dependencies;

import com.intellij.openapi.externalSystem.model.project.dependencies.AbstractDependencyNode;
import com.intellij.serialization.PropertyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyScopeNode
extends AbstractDependencyNode {
    private final String scope;
    private final String displayName;
    private final String description;

    @PropertyMapping(value={"id", "scope", "displayName", "description"})
    public DependencyScopeNode(long id, @NotNull String scope, @NotNull String displayName, @Nullable String description) {
        super(id);
        this.displayName = displayName;
        this.scope = scope;
        this.description = description;
    }

    @NotNull
    public String getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean match(AbstractDependencyNode dependencyNode) {
        if (dependencyNode == null || this.getClass() != dependencyNode.getClass()) {
            return false;
        }
        DependencyScopeNode node = (DependencyScopeNode)dependencyNode;
        if (!this.scope.equals(node.scope)) {
            return false;
        }
        if (!this.displayName.equals(node.displayName)) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(node.description) : node.description != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.scope.hashCode();
        result = 31 * result + this.displayName.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

