/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class TrustAllX509TrustManagerDetector
extends Detector
implements SourceCodeScanner,
ClassScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(TrustAllX509TrustManagerDetector.class, EnumSet.of(Scope.JAVA_LIBRARIES, Scope.JAVA_FILE), Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("TrustAllX509TrustManager", "Insecure TLS/SSL trust manager", "This check looks for X509TrustManager implementations whose `checkServerTrusted` or `checkClientTrusted` methods do nothing (thus trusting any certificate chain) which could result in insecure network traffic caused by trusting arbitrary TLS/SSL certificates presented by peers.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(true);

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("javax.net.ssl.X509TrustManager");
    }

    @Override
    public void visitClass(JavaContext context2, UClass cls) {
        TrustAllX509TrustManagerDetector.checkMethod(context2, cls, "checkServerTrusted");
        TrustAllX509TrustManagerDetector.checkMethod(context2, cls, "checkClientTrusted");
    }

    private static void checkMethod(JavaContext context2, UClass cls, String methodName) {
        JavaEvaluator evaluator = context2.getEvaluator();
        for (PsiMethod method : cls.findMethodsByName(methodName, true)) {
            if (evaluator.isAbstract((PsiModifierListOwner)method)) continue;
            UExpression body = UastFacade.INSTANCE.getMethodBody(method);
            ComplexBodyVisitor visitor2 = new ComplexBodyVisitor();
            if (body != null) {
                body.accept((UastVisitor)visitor2);
            }
            if (visitor2.isComplex()) continue;
            Location location = context2.getNameLocation((PsiElement)method);
            String message2 = TrustAllX509TrustManagerDetector.getErrorMessage(methodName);
            context2.report(ISSUE, (PsiElement)method, location, message2);
        }
    }

    private static String getErrorMessage(String methodName) {
        return "`" + methodName + "` is empty, which could cause insecure network traffic due to trusting arbitrary TLS/SSL certificates presented by peers";
    }

    @Override
    public void checkClass(ClassContext context2, ClassNode classNode) {
        if (!context2.isFromClassLibrary()) {
            return;
        }
        if (!classNode.interfaces.contains("javax/net/ssl/X509TrustManager")) {
            return;
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!"checkServerTrusted".equals(method.name) && !"checkClientTrusted".equals(method.name)) continue;
            InsnList nodes = method.instructions;
            boolean emptyMethod = true;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                int type = instruction.getType();
                if (type == 8 || type == 15 || type == 0 && instruction.getOpcode() == 177) continue;
                emptyMethod = false;
                break;
            }
            if (!emptyMethod) continue;
            Location location = context2.getLocation(method, classNode);
            context2.report(ISSUE, location, TrustAllX509TrustManagerDetector.getErrorMessage(method.name));
        }
    }

    private static class ComplexBodyVisitor
    extends AbstractUastVisitor {
        private boolean isComplex = false;

        private ComplexBodyVisitor() {
        }

        public boolean visitElement(UElement node) {
            if (node instanceof UExpression && !(node instanceof UReturnExpression) && !(node instanceof UBlockExpression) && !(node instanceof UastEmptyExpression)) {
                this.isComplex = true;
            }
            return this.isComplex || super.visitElement(node);
        }

        boolean isComplex() {
            return this.isComplex;
        }
    }
}

