/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.MissingClassDetector$WhenMappings;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.kotlin.KotlinUClass;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J0\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001cH\u0002J \u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/MissingClassDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/ClassScanner;", "()V", "checkedClasses", "", "", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkClassReference", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "pkg", "className", "classNameNode", "Lorg/w3c/dom/Node;", "element", "Lorg/w3c/dom/Element;", "requireInstantiatable", "expectedParent", "checkExpectedParent", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "nameNode", "cls", "Lcom/intellij/psi/PsiClass;", "checkInnerClassReference", "checkInstantiatable", "fqcn", "getApplicableElements", "", "getRefLocation", "Lcom/android/tools/lint/detector/api/Location;", "hasImplicitDefaultConstructor", "psiClass", "reportMissing", "location", "Lcom/android/tools/lint/detector/api/Context;", "visitElement", "Companion", "android.sdktools.lint-checks"})
public final class MissingClassDetector
extends LayoutDetector
implements ClassScanner {
    private Map<String, Boolean> checkedClasses;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue INSTANTIATABLE;
    @JvmField
    @NotNull
    public static final Issue INNERCLASS;
    public static final Companion Companion;

    @Override
    @Nullable
    public Collection<String> getApplicableElements() {
        return LayoutDetector.ALL;
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.TRANSITION;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        block44: {
            block43: {
                tag = element.getTagName();
                v0 = context.getResourceFolderType();
                if (v0 != null) break block43;
                if (!Intrinsics.areEqual((Object)"application", (Object)tag) && !Intrinsics.areEqual((Object)"activity", (Object)tag) && !Intrinsics.areEqual((Object)"service", (Object)tag) && !Intrinsics.areEqual((Object)"receiver", (Object)tag) && !Intrinsics.areEqual((Object)"provider", (Object)tag)) break block44;
                v1 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (v1 == null) {
                    return;
                }
                attr = v1;
                pkg = context.getProject().getPackage();
                v2 = attr.getValue();
                v3 = attr;
                v4 = tag;
                if (v4 == null) ** GOTO lbl-1000
                var6_15 = v4;
                tmp = -1;
                switch (var6_15.hashCode()) {
                    case -1655966961: {
                        if (!var6_15.equals("activity")) break;
                        tmp = 1;
                        break;
                    }
                    case -808719889: {
                        if (!var6_15.equals("receiver")) break;
                        tmp = 2;
                        break;
                    }
                    case 1554253136: {
                        if (!var6_15.equals("application")) break;
                        tmp = 3;
                        break;
                    }
                    case -987494927: {
                        if (!var6_15.equals("provider")) break;
                        tmp = 4;
                        break;
                    }
                    case 1984153269: {
                        if (!var6_15.equals("service")) break;
                        tmp = 5;
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v5 = "android.app.Activity";
                        break;
                    }
                    case 5: {
                        v5 = "android.app.Service";
                        break;
                    }
                    case 2: {
                        v5 = "android.content.BroadcastReceiver";
                        break;
                    }
                    case 4: {
                        v5 = "android.content.ContentProvider";
                        break;
                    }
                    case 3: {
                        v5 = "android.app.Application";
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v5 = null;
                    }
                }
                this.checkClassReference(context, pkg, v2, v3, element, true, v5);
                ** break;
            }
            switch (MissingClassDetector$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case 1: {
                    if (Intrinsics.areEqual((Object)tag, (Object)"string") && SdkUtils.endsWith((CharSequence)context.file.getPath(), (CharSequence)"analytics.xml")) {
                        v6 = element.getAttributeNode("name");
                        if (v6 == null) {
                            return;
                        }
                        attr = v6;
                        MissingClassDetector.checkClassReference$default(this, context, null, attr.getValue(), attr, element, false, null, 96, null);
                    }
                    break;
                }
                case 2: {
                    if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) > 0) {
                        MissingClassDetector.checkClassReference$default(this, context, null, tag, element, element, false, LintClient.Companion.isStudio() != false ? null : "android.view.View", 32, null);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
                        v7 = element.getAttributeNode("class");
                        if (v7 == null) {
                            return;
                        }
                        attr = v7;
                        MissingClassDetector.checkClassReference$default(this, context, null, attr.getValue(), attr, element, false, LintClient.Companion.isStudio() != false ? null : "android.view.View", 32, null);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tag, (Object)"fragment")) {
                        v8 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                        if (v8 == null) {
                            v8 = element.getAttributeNode("class");
                        }
                        if (v8 == null) {
                            return;
                        }
                        attr = v8;
                        this.checkClassReference(context, null, attr.getValue(), attr, element, true, "android.app.Fragment");
                    }
                    break;
                }
                case 3: {
                    if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) > 0) {
                        MissingClassDetector.checkClassReference$default(this, context, null, tag, element, element, false, null, 96, null);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tag, (Object)"drawable")) {
                        v9 = element.getAttributeNode("class");
                        if (v9 == null) {
                            return;
                        }
                        attr = v9;
                        MissingClassDetector.checkClassReference$default(this, context, null, attr.getValue(), attr, element, false, "android.graphics.drawable.Drawable", 32, null);
                    }
                    break;
                }
                case 4: {
                    if (Intrinsics.areEqual((Object)tag, (Object)"transition") || Intrinsics.areEqual((Object)tag, (Object)"pathMotion")) {
                        v10 = element.getAttributeNode("class");
                        if (v10 == null) {
                            return;
                        }
                        attr = v10;
                        expectedParent = Intrinsics.areEqual((Object)tag, (Object)"transition") != false ? "android.transition.Transition" : "android.transition.PathMotion";
                        MissingClassDetector.checkClassReference$default(this, context, null, attr.getValue(), attr, element, false, expectedParent, 32, null);
                    }
                    break;
                }
                case 5: {
                    if (Intrinsics.areEqual((Object)tag, (Object)"header")) {
                        v11 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fragment");
                        if (v11 == null) {
                            return;
                        }
                        attr = v11;
                        this.checkClassReference(context, null, attr.getValue(), attr, element, true, "android.app.Fragment");
                    }
                    break;
                }
                case 6: {
                    if (Intrinsics.areEqual((Object)tag, (Object)"item")) {
                        v12 = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "actionViewClass");
                        if (v12 == null) {
                            v12 = view = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "actionViewClass");
                        }
                        if (view != null) {
                            MissingClassDetector.checkClassReference$default(this, context, null, view.getValue(), view, element, false, "android.view.View", 32, null);
                        }
                        if ((v13 = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "actionProviderClass")) == null) {
                            v13 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "actionProviderClass");
                        }
                        if (v13 == null) {
                            return;
                        }
                        provider = v13;
                        MissingClassDetector.checkClassReference$default(this, context, null, provider.getValue(), provider, element, false, null, 96, null);
                    }
                    break;
                }
            }
lbl138:
            // 11 sources

        }
    }

    private final void checkClassReference(XmlContext context2, String pkg, String className, Node classNameNode, Element element, boolean requireInstantiatable, String expectedParent) {
        CharSequence charSequence = className;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        String fqcn = null;
        int dotIndex = StringsKt.indexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex <= 0) {
            if (pkg == null) {
                return;
            }
            fqcn = dotIndex == 0 ? pkg + className : pkg + '.' + className;
        } else {
            fqcn = className;
        }
        if (StringsKt.startsWith$default((String)fqcn, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqcn, (String)"com.android.internal.", (boolean)false, (int)2, null)) {
            return;
        }
        Boolean ok = this.checkedClasses.get(fqcn);
        if (ok == null) {
            UastParser parser = context2.getClient().getUastParser(context2.getMainProject());
            JavaEvaluator evaluator = parser.getEvaluator();
            PsiClass cls = evaluator.findClass(StringsKt.replace$default((String)fqcn, (char)'$', (char)'.', (boolean)false, (int)4, null));
            if (cls != null) {
                ok = true;
                if (requireInstantiatable) {
                    this.checkInstantiatable(context2, evaluator, cls, fqcn, classNameNode);
                }
                this.checkInnerClassReference(context2, cls, className, classNameNode, element);
                if (expectedParent != null) {
                    this.checkExpectedParent(context2, evaluator, classNameNode, cls, expectedParent);
                }
            } else {
                ok = false;
            }
            this.checkedClasses.put(fqcn, ok);
        }
        if (Intrinsics.areEqual((Object)ok, (Object)false)) {
            Location location = this.getRefLocation(context2, classNameNode);
            this.reportMissing(location, fqcn, context2);
        }
    }

    static /* synthetic */ void checkClassReference$default(MissingClassDetector missingClassDetector, XmlContext xmlContext, String string, String string2, Node node, Element element, boolean bl, String string3, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        missingClassDetector.checkClassReference(xmlContext, string, string2, node, element, bl, string3);
    }

    private final void checkExpectedParent(XmlContext context2, JavaEvaluator evaluator, Node nameNode, PsiClass cls, String expectedParent) {
        if (!evaluator.inheritsFrom(cls, expectedParent, false)) {
            if (Intrinsics.areEqual((Object)expectedParent, (Object)"android.app.Fragment")) {
                this.checkExpectedParent(context2, evaluator, nameNode, cls, SdkConstants.CLASS_V4_FRAGMENT.oldName());
                return;
            }
            if (Intrinsics.areEqual((Object)expectedParent, (Object)SdkConstants.CLASS_V4_FRAGMENT.oldName())) {
                this.checkExpectedParent(context2, evaluator, nameNode, cls, SdkConstants.CLASS_V4_FRAGMENT.newName());
                return;
            }
            PsiClass psiClass = cls.getSuperClass();
            if (psiClass == null) {
                return;
            }
            PsiClass curr = psiClass;
            while (true) {
                String qualifiedName;
                if (Intrinsics.areEqual((Object)(qualifiedName = curr.getQualifiedName()), (Object)expectedParent)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)qualifiedName, (Object)"java.lang.Object")) break;
                if (curr.getSuperClass() != null) continue;
                return;
            }
            String message2 = StringsKt.contains$default((CharSequence)expectedParent, (CharSequence)"Fragment", (boolean)false, (int)2, null) ? '`' + cls.getName() + "` must be a fragment" : '`' + cls.getName() + "` must extend " + expectedParent;
            Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message2, null, 8, null);
        }
    }

    private final void checkInnerClassReference(XmlContext context2, PsiClass cls, String className, Node nameNode, Element element) {
        String full;
        String name = cls.getName();
        if (cls.getContainingClass() == null || name == null || StringsKt.contains$default((CharSequence)className, (CharSequence)"$", (boolean)false, (int)2, null)) {
            return;
        }
        String string = Lint.getInternalName(cls);
        if (string == null || (string = StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null)) == null) {
            return;
        }
        String string2 = full = string;
        int n = full.length() - className.length();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String fixed = string4;
        String message2 = "Use '$' instead of '.' for inner classes; replace \"" + className + "\" with \"" + fixed + '\"';
        Location location = this.getRefLocation(context2, nameNode);
        LintFix fix = LintFix.create().replace().text(className).with(fixed).autoFix().build();
        context2.report(INNERCLASS, (Node)element, location, message2, fix);
    }

    private final void checkInstantiatable(XmlContext context2, JavaEvaluator evaluator, PsiClass cls, String fqcn, Node nameNode) {
        if (evaluator.isPrivate((PsiModifierListOwner)cls)) {
            String message2 = "This class should be public (`" + fqcn + "`)";
            Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message2, null, 8, null);
        } else if (cls.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)cls)) {
            String message3 = "This inner class should be static (`" + fqcn + "`)";
            Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message3, null, 8, null);
        } else {
            PsiMethod[] constructors;
            PsiMethod[] psiMethodArray = constructors = cls.getConstructors();
            int n = 0;
            if (psiMethodArray.length == 0 && this.hasImplicitDefaultConstructor(cls)) {
                return;
            }
            for (PsiMethod constructor : cls.getConstructors()) {
                if (!constructor.getParameterList().isEmpty()) continue;
                if (evaluator.isPrivate((PsiModifierListOwner)constructor)) {
                    String message4 = "The default constructor must be public in `" + fqcn + '`';
                    Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message4, null, 8, null);
                    return;
                }
                return;
            }
            String message5 = "This class should provide a default constructor (a public constructor with no arguments) (`" + fqcn + "`)";
            Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message5, null, 8, null);
        }
    }

    private final Location getRefLocation(XmlContext context2, Node nameNode) {
        return nameNode instanceof Attr ? context2.getValueLocation((Attr)nameNode) : context2.getLocation(nameNode);
    }

    private final boolean hasImplicitDefaultConstructor(PsiClass psiClass) {
        PsiMethod[] constructors;
        if (psiClass instanceof KotlinUClass && ((KotlinUClass)psiClass).getSourcePsi() == null) {
            return false;
        }
        PsiMethod[] psiMethodArray = constructors = psiClass.getConstructors();
        boolean bl = false;
        if (psiMethodArray.length == 0 && !psiClass.isInterface() && !psiClass.isAnnotationType() && !psiClass.isEnum()) {
            if (PsiUtil.hasDefaultConstructor((PsiClass)psiClass)) {
                return true;
            }
            if (psiClass.hasModifierProperty("final") && !psiClass.hasModifierProperty("abstract") && psiClass.hasModifierProperty("public")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportMissing(Location location, String fqcn, Context context2) {
        String string;
        File parentFile = location.getFile().getParentFile();
        if (parentFile != null) {
            ResourceFolderType resourceFolderType;
            String parent = parentFile.getName();
            ResourceFolderType resourceFolderType2 = resourceFolderType = ResourceFolderType.getFolderType((String)parent);
            if (resourceFolderType2 == null) {
                string = "manifest";
            } else {
                switch (MissingClassDetector$WhenMappings.$EnumSwitchMapping$1[resourceFolderType2.ordinal()]) {
                    case 1: {
                        string = "layout file";
                        break;
                    }
                    case 2: {
                        string = "preference header file";
                        break;
                    }
                    case 3: {
                        string = "analytics file";
                        break;
                    }
                    default: {
                        void type;
                        StringBuilder stringBuilder = new StringBuilder();
                        String string2 = type.getName();
                        Locale locale = Locale.US;
                        boolean bl = false;
                        String string3 = string2;
                        boolean bl2 = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                        string = stringBuilder.append(string5).append(" file").toString();
                        break;
                    }
                }
            }
        } else {
            string = "the manifest";
        }
        String target2 = string;
        String message2 = "Class referenced in the " + target2 + ", `" + fqcn + "`, was not found in the project or the libraries";
        Context.report$default(context2, MISSING, location, message2, null, 8, null);
    }

    public MissingClassDetector() {
        boolean bl = false;
        this.checkedClasses = new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(MissingClassDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Object object = "https://developer.android.com/guide/topics/manifest/manifest-intro.html";
        Severity severity = Severity.ERROR;
        int n = 8;
        Category category = Category.CORRECTNESS;
        MISSING = Issue.Companion.create$default(Issue.Companion, "MissingClass", "Missing registered class", "\n                    If a class is referenced in the manifest or in a layout file, it must \\\n                    also exist in the project (or in one of the libraries included by the \\\n                    project. This check helps uncover typos in registration names, or \\\n                    attempts to rename or move classes without updating the XML references\n                    properly.\n                    ", implementation, object, category, n, severity, bl, bl2, enumSet, collection, 3328, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        bl2 = true;
        object = Severity.FATAL;
        int n2 = 6;
        String string = null;
        category = Category.CORRECTNESS;
        INSTANTIATABLE = Issue.Companion.create$default(Issue.Companion, "Instantiatable", "Registered class is not instantiatable", "\n                    Activities, services, broadcast receivers etc. registered in the \\\n                    manifest file (or for custom views, in a layout file) must be \\\n                    \"instantiatable\" by the system, which means that the class must \\\n                    be public, it must have an empty public constructor, and if it's an \\\n                    inner class, it must be a static inner class.", implementation, string, category, n2, (Severity)((Object)object), bl, bl2, enumSet, collection, 3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        bl2 = true;
        object = Severity.WARNING;
        n2 = 3;
        string = null;
        category = Category.CORRECTNESS;
        INNERCLASS = Issue.Companion.create$default(Issue.Companion, "InnerclassSeparator", "Inner classes should use `$` rather than `.`", "\n                    When you reference an inner class in a manifest file, you must use '$' \\\n                    instead of '.' as the separator character, i.e. Outer$Inner instead of \\\n                    Outer.Inner.\n\n                    (If you get this warning for a class which is not actually an inner class, \\\n                    it's because you are using uppercase characters in your package name, which \\\n                    is not conventional.)\n                    ", implementation, string, category, n2, (Severity)((Object)object), bl, bl2, enumSet, collection, 3344, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/MissingClassDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "INNERCLASS", "Lcom/android/tools/lint/detector/api/Issue;", "INSTANTIATABLE", "MISSING", "android.sdktools.lint-checks"})
    public static final class Companion {
        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

