/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/DiffUtilDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "checkExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "checkMethod", "declaration", "Lorg/jetbrains/uast/UMethod;", "defaultEquals", "", "type", "Lcom/intellij/psi/PsiClassType;", "Lorg/jetbrains/uast/UElement;", "isCastWithEquals", "Lorg/jetbrains/uast/UExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "withinCastWithEquals", "Companion", "android.sdktools.lint-checks"})
public final class DiffUtilDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object[])new String[]{"android.support.v7.util.DiffUtil.ItemCallback", "androidx.recyclerview.widget.DiffUtil.ItemCallback", "android.support.v17.leanback.widget.DiffCallback", "androidx.leanback.widget.DiffCallback"});
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        JavaEvaluator evaluator = context2.getEvaluator();
        for (UMethod method : declaration.getMethods()) {
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"areContentsTheSame") || evaluator.getParameterCount((PsiMethod)method) != 2) continue;
            this.checkMethod(context2, method);
        }
    }

    private final void checkMethod(JavaContext context2, UMethod declaration) {
        declaration.accept((UastVisitor)new AbstractUastVisitor(this, context2){
            final /* synthetic */ DiffUtilDetector this$0;
            final /* synthetic */ JavaContext $context;

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                DiffUtilDetector.access$checkExpression(this.this$0, this.$context, node);
                return super.visitBinaryExpression(node);
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                DiffUtilDetector.access$checkCall(this.this$0, this.$context, node);
                return super.visitCallExpression(node);
            }
            {
                this.this$0 = this$0;
                this.$context = $captured_local_variable$1;
            }
        });
    }

    private final boolean defaultEquals(JavaContext context2, UElement node) {
        PsiMethod resolved = null;
        if (node instanceof UBinaryExpression) {
            resolved = ((UBinaryExpression)node).resolveOperator();
            if (resolved == null) {
                PsiType psiType = ((UBinaryExpression)node).getLeftOperand().getExpressionType();
                if (!(psiType instanceof PsiClassType)) {
                    psiType = null;
                }
                PsiClassType left = (PsiClassType)psiType;
                return this.defaultEquals(context2, left);
            }
        } else if (node instanceof UCallExpression) {
            resolved = ((UCallExpression)node).resolve();
        } else {
            return false;
        }
        if (resolved == null) {
            return false;
        }
        PsiClass psiClass = resolved.getContainingClass();
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.lang.Object");
    }

    private final boolean defaultEquals(JavaContext context2, PsiClassType type) {
        PsiClassType psiClassType = type;
        if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
            return false;
        }
        PsiClassType cls = psiClassType;
        if (Lint.isKotlin((PsiElement)cls) && (context2.getEvaluator().isSealed((PsiModifierListOwner)cls) || context2.getEvaluator().isData((PsiModifierListOwner)cls))) {
            return false;
        }
        for (PsiMethod m : cls.findMethodsByName("equals", true)) {
            PsiParameter[] parameters;
            if (!(m instanceof PsiMethod) || (parameters = m.getParameterList().getParameters()).length != 1 || !Intrinsics.areEqual((Object)parameters[0].getType().getCanonicalText(), (Object)"java.lang.Object")) continue;
            PsiClass psiClass = m.getContainingClass();
            return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.lang.Object");
        }
        return false;
    }

    private final void checkCall(JavaContext context2, UCallExpression node) {
        if (this.defaultEquals(context2, (UElement)node)) {
            if (this.withinCastWithEquals(context2, node)) {
                return;
            }
            Object object = node.getReceiverType();
            if (object == null || (object = object.getCanonicalText()) == null) {
                object = "target";
            }
            Object targetType = object;
            String message2 = "Suspicious equality check: `equals()` is not implemented in " + (String)targetType;
            Location location = context2.getCallLocation(node, false, true);
            JavaContext.report$default(context2, ISSUE, (UElement)node, location, message2, null, 16, null);
        }
    }

    private final boolean withinCastWithEquals(JavaContext context2, UCallExpression node) {
        UElement uElement = UastUtils.getParentOfType((UElement)((UElement)node), UIfExpression.class, (boolean)false, (Class[])new Class[]{UMethod.class});
        if (!(uElement instanceof UIfExpression)) {
            uElement = null;
        }
        UIfExpression uIfExpression = (UIfExpression)uElement;
        if (uIfExpression == null) {
            return false;
        }
        UIfExpression ifStatement = uIfExpression;
        UExpression condition = ifStatement.getCondition();
        return this.isCastWithEquals(context2, condition);
    }

    private final boolean isCastWithEquals(JavaContext context2, UExpression node) {
        if (node instanceof UBinaryExpressionWithType) {
            PsiType psiType = ((UBinaryExpressionWithType)node).getType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            return !this.defaultEquals(context2, (PsiClassType)psiType);
        }
        if (node instanceof UPolyadicExpression) {
            for (UExpression operand : ((UPolyadicExpression)node).getOperands()) {
                if (!this.isCastWithEquals(context2, operand)) continue;
                return true;
            }
        }
        return false;
    }

    private final void checkExpression(JavaContext context2, UBinaryExpression node) {
        block10: {
            Object object;
            String message2;
            block15: {
                block14: {
                    block11: {
                        Object object2;
                        String message3;
                        block13: {
                            block12: {
                                if (!Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.IDENTITY_EQUALS) && !Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.EQUALS)) break block10;
                                PsiType psiType = node.getLeftOperand().getExpressionType();
                                if (psiType == null) {
                                    return;
                                }
                                PsiType left = psiType;
                                PsiType psiType2 = node.getRightOperand().getExpressionType();
                                if (psiType2 == null) {
                                    return;
                                }
                                PsiType right = psiType2;
                                if (!(left instanceof PsiClassType) || !(right instanceof PsiClassType)) break block10;
                                if (!Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.EQUALS)) break block11;
                                if (!this.defaultEquals(context2, (UElement)node)) break block10;
                                message3 = "Suspicious equality check: `equals()` is not implemented in " + ((PsiClassType)left).getClassName();
                                object2 = node.getOperatorIdentifier();
                                if (object2 == null) break block12;
                                UIdentifier uIdentifier = object2;
                                boolean bl = false;
                                boolean bl2 = false;
                                UIdentifier it = uIdentifier;
                                boolean bl3 = false;
                                object2 = context2.getLocation((UElement)it);
                                if (object2 != null) break block13;
                            }
                            object2 = context2.getLocation((UElement)node);
                        }
                        Object location = object2;
                        JavaContext.report$default(context2, ISSUE, (UElement)node, (Location)location, message3, null, 16, null);
                        break block10;
                    }
                    message2 = Lint.isKotlin(node.getSourcePsi()) ? "Suspicious equality check: Did you mean `==` instead of `===` ?" : "Suspicious equality check: Did you mean `.equals()` instead of `==` ?";
                    object = node.getOperatorIdentifier();
                    if (object == null) break block14;
                    UIdentifier uIdentifier = object;
                    boolean bl = false;
                    boolean bl4 = false;
                    UIdentifier it = uIdentifier;
                    boolean bl5 = false;
                    object = context2.getLocation((UElement)it);
                    if (object != null) break block15;
                }
                object = context2.getLocation((UElement)node);
            }
            Object location = object;
            JavaContext.report$default(context2, ISSUE, (UElement)node, (Location)location, message2, null, 16, null);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(DiffUtilDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Severity severity = Severity.ERROR;
        String string = "https://issuetracker.google.com/116789824";
        Boolean bl2 = true;
        int n = 4;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default(Issue.Companion, "DiffUtilEquals", "Suspicious DiffUtil Equality", "\n                `areContentsTheSame` is used by `DiffUtil` to produce diffs. If the \\\n                method is implemented incorrectly, such as using identity equals \\\n                instead of equals, or calling equals on a class that has not implemented \\\n                it, weird visual artifacts can occur.\n                ", implementation, string, category, n, severity, bl, bl2, enumSet, collection, 3328, null);
    }

    public static final /* synthetic */ void access$checkExpression(DiffUtilDetector $this, JavaContext context2, UBinaryExpression node) {
        $this.checkExpression(context2, node);
    }

    public static final /* synthetic */ void access$checkCall(DiffUtilDetector $this, JavaContext context2, UCallExpression node) {
        $this.checkCall(context2, node);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/DiffUtilDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

