/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.Apk;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ApplicationDumper {
    private final Installer installer;

    public ApplicationDumper(Installer installer) {
        this.installer = installer;
    }

    public static String getPackageName(List<Apk> apks) throws DeployerException {
        String packageName = null;
        for (Apk apk : apks) {
            if (packageName == null) {
                packageName = apk.packageName;
            }
            if (apk.packageName.equals(packageName)) continue;
            throw DeployerException.swapMultiplePackages();
        }
        return packageName;
    }

    public Dump dump(List<Apk> apks) throws DeployerException {
        Deploy.DumpResponse response;
        String packageName = null;
        HashSet<String> targetPackages = new HashSet<String>();
        for (Apk apk : apks) {
            if (packageName == null) {
                packageName = apk.packageName;
            }
            if (!apk.packageName.equals(packageName)) {
                throw DeployerException.swapMultiplePackages();
            }
            targetPackages.addAll(apk.targetPackages);
        }
        ArrayList<String> packagesToDump = new ArrayList<String>();
        packagesToDump.add(packageName);
        packagesToDump.addAll(targetPackages);
        try {
            response = this.installer.dump(packagesToDump);
        }
        catch (IOException e) {
            throw DeployerException.dumpFailed(e.getMessage());
        }
        if (response.getStatus() == Deploy.DumpResponse.Status.ERROR_PACKAGE_NOT_FOUND) {
            throw DeployerException.unknownPackage(response.getFailedPackage());
        }
        return new Dump(ApplicationDumper.GetApks(response.getPackages(0)), ApplicationDumper.GetPids(response), ApplicationDumper.GetArch(response));
    }

    private static List<Apk> GetApks(Deploy.PackageDump packageDump) {
        ArrayList<Apk> dumps = new ArrayList<Apk>();
        for (Deploy.ApkDump dump2 : packageDump.getApksList()) {
            ByteBuffer cd = dump2.getCd().asReadOnlyByteBuffer();
            ByteBuffer signature = dump2.getSignature().asReadOnlyByteBuffer();
            List<ZipUtils.ZipEntry> zipEntries = ZipUtils.readZipEntries(cd);
            cd.rewind();
            String digest = ZipUtils.digest(signature.remaining() != 0 ? signature : cd);
            Apk.Builder builder = Apk.builder().setName(dump2.getName()).setChecksum(digest).setPath(dump2.getAbsolutePath());
            for (ZipUtils.ZipEntry entry : zipEntries) {
                builder.addApkEntry(entry);
            }
            dumps.add(builder.build());
        }
        return dumps;
    }

    private static Map<String, List<Integer>> GetPids(Deploy.DumpResponse response) {
        HashMap<String, List<Integer>> pids = new HashMap<String, List<Integer>>();
        for (Deploy.PackageDump packageDump : response.getPackagesList()) {
            if (packageDump.getProcessesList().isEmpty()) continue;
            pids.put(packageDump.getName(), packageDump.getProcessesList());
        }
        return pids;
    }

    private static Deploy.Arch GetArch(Deploy.DumpResponse response) throws DeployerException {
        Deploy.Arch result2 = Deploy.Arch.ARCH_UNKNOWN;
        String lastPackageWithKnowArch = null;
        for (Deploy.PackageDump pkg : response.getPackagesList()) {
            Deploy.Arch arch = pkg.getArch();
            if (arch.equals((Object)Deploy.Arch.ARCH_UNKNOWN)) continue;
            if (!result2.equals((Object)Deploy.Arch.ARCH_UNKNOWN) && !result2.equals((Object)arch)) {
                throw DeployerException.dumpMixedArch(lastPackageWithKnowArch + " is " + result2 + " while " + pkg.getName() + " is " + arch + ".");
            }
            result2 = arch;
            lastPackageWithKnowArch = pkg.getName();
        }
        return result2;
    }

    public static class Dump {
        public final List<Apk> apks;
        public final Map<String, List<Integer>> packagePids;
        public final Deploy.Arch arch;

        public Dump(List<Apk> apks, Map<String, List<Integer>> packagePids, Deploy.Arch arch) {
            this.apks = apks;
            this.packagePids = packagePids;
            this.arch = arch;
        }
    }
}

