/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallCreateReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class SplitApkInstallerBase {
    private static final String LOG_TAG = "SplitApkInstallerBase";
    private final IDevice mDevice;
    private final String mOptions;
    private final String mPrefix;
    protected static final CharMatcher UNSAFE_PM_INSTALL_SESSION_SPLIT_NAME_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.anyOf((CharSequence)"_-")).negate();

    protected SplitApkInstallerBase(IDevice device, String options) {
        this.mDevice = device;
        this.mOptions = options;
        this.mPrefix = this.mDevice.getVersion().isGreaterOrEqualThan(AndroidVersion.BINDER_CMD_AVAILABLE.getApiLevel()) ? "cmd package" : "pm";
    }

    protected String createMultiInstallSession(String options, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        InstallCreateReceiver receiver = new InstallCreateReceiver();
        String cmd = this.mPrefix + " install-create";
        if (!options.trim().isEmpty()) {
            cmd = cmd + " " + options;
        }
        this.mDevice.executeShellCommand(cmd, receiver, timeout, unit);
        String sessionId = receiver.getSessionId();
        if (sessionId == null) {
            String message2 = String.format("'%s'", cmd);
            message2 = receiver.getErrorMessage() != null ? String.format("%s returns error '%s'", message2, receiver.getErrorMessage()) : (receiver.getSuccessMessage() != null ? String.format("%s returns '%s' without session ID", message2, receiver.getSuccessMessage()) : String.format("Failed to create install session with %s", message2));
            Log.e(LOG_TAG, message2);
            throw new InstallException(message2);
        }
        Log.i(LOG_TAG, String.format("Created install session %s with options %s", sessionId, options));
        return sessionId;
    }

    protected void installCommit(String sessionId, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        String command = this.mPrefix + " install-commit " + sessionId;
        InstallReceiver receiver = new InstallReceiver();
        this.mDevice.executeShellCommand(command, receiver, timeout, unit);
        if (!receiver.isSuccessfullyCompleted()) {
            String message2 = String.format("Failed to commit install session %s with command %s.", sessionId, command);
            if (receiver.getErrorMessage() != null) {
                message2 = message2 + String.format(" Error: %s", receiver.getErrorMessage());
            }
            Log.e(LOG_TAG, message2);
            throw new InstallException(message2, receiver.getErrorCode());
        }
    }

    protected void installAbandon(String sessionId, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        String command = this.mPrefix + " install-abandon " + sessionId;
        InstallReceiver receiver = new InstallReceiver();
        this.mDevice.executeShellCommand(command, receiver, timeout, unit);
        if (!receiver.isSuccessfullyCompleted()) {
            Log.e(LOG_TAG, String.format("Failed to abandon install session %s", sessionId));
        }
    }

    protected IDevice getDevice() {
        return this.mDevice;
    }

    protected String getPrefix() {
        return this.mPrefix;
    }

    protected String getOptions() {
        return this.mOptions;
    }

    protected static String getOptions(boolean reInstall, List<String> installOptions) {
        return SplitApkInstallerBase.getOptions(reInstall, false, null, installOptions);
    }

    protected static String getOptions(boolean reInstall, boolean partialInstall, String applicationId, List<String> installOptions) {
        StringBuilder sb = new StringBuilder();
        if (reInstall) {
            sb.append("-r");
        }
        if (partialInstall) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (applicationId == null) {
                throw new IllegalArgumentException("Cannot do a partial install without knowing the application id");
            }
            sb.append("-p ");
            sb.append(applicationId);
        }
        if (!installOptions.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(Joiner.on((String)" ").join(installOptions));
        }
        return sb.toString();
    }

    protected static void validateApiLevel(IDevice device) {
        int apiWithSplitApk = AndroidVersion.ALLOW_SPLIT_APK_INSTALLATION.getApiLevel();
        if (!device.getVersion().isGreaterOrEqualThan(apiWithSplitApk)) {
            throw new IllegalArgumentException(String.format("Device %s API level=%d. Cannot install split APKs with API level < %d", device.getSerialNumber(), device.getVersion().getApiLevel(), apiWithSplitApk));
        }
    }
}

