/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;

public class SnippetsRegistry {
    @NotNull
    private final MultiMap<String, TextMateSnippet> mySnippets = MultiMap.create();

    public void register(@NotNull TextMateSnippet snippet) {
        this.mySnippets.putValue((Object)snippet.getKey(), (Object)snippet);
    }

    @NotNull
    public Collection<TextMateSnippet> findSnippet(@NotNull String key, @Nullable CharSequence scopeSelector) {
        if (scopeSelector == null) {
            return Collections.emptyList();
        }
        return new TextMateScopeComparator<TextMateSnippet>(scopeSelector, TextMateSnippet::getScopeSelector).sortAndFilter(this.mySnippets.get((Object)key));
    }

    @NotNull
    public Collection<TextMateSnippet> getAvailableSnippets(@Nullable CharSequence scopeSelector) {
        if (scopeSelector == null) {
            return Collections.emptyList();
        }
        return new TextMateScopeComparator<TextMateSnippet>(scopeSelector, TextMateSnippet::getScopeSelector).sortAndFilter(this.mySnippets.values());
    }

    public void clear() {
        this.mySnippets.clear();
    }
}

