/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.reposearch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.DependencySearchProvidersFactory;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.DependencySearchServiceKt$sam$java_util_function_Consumer$0;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001aH\u0002J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u001cJ4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001aJ`\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001a2(\u0010\u001f\u001a$\u0012\u0004\u0012\u00020\r\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001a\u0012\u0004\u0012\u00020\u00190 H\u0002J\"\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0#J2\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u001cJ<\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001aJ\u0006\u0010(\u001a\u00020\u0019R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/reposearch/DependencySearchService;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "", "", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "localProviders", "", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "myExecutorService", "Ljava/util/concurrent/ExecutorService;", "remoteProviders", "foundInCache", "Lorg/jetbrains/concurrency/Promise;", "", "searchString", "parameters", "Lorg/jetbrains/idea/reposearch/SearchParameters;", "consumer", "Lkotlin/Function1;", "", "Lorg/jetbrains/idea/reposearch/ResultConsumer;", "fulltextSearch", "Ljava/util/function/Consumer;", "performSearch", "cacheKey", "searchMethod", "Lkotlin/Function2;", "setProviders", "local", "", "remote", "suggestPrefix", "groupId", "artifactId", "updateProviders", "Companion", "intellij.repository.search"})
@ApiStatus.Experimental
public final class DependencySearchService {
    private final ExecutorService myExecutorService;
    private final Map<String, CompletableFuture<Collection<RepositoryArtifactData>>> cache;
    private final List<DependencySearchProvider> remoteProviders;
    private final List<DependencySearchProvider> localProviders;
    private final Project myProject;
    public static final Companion Companion = new Companion(null);

    public final void updateProviders() {
        ReadAction.nonBlocking((Runnable)new Runnable(this){
            final /* synthetic */ DependencySearchService this$0;

            public final void run() {
                DependencySearchService.access$getRemoteProviders$p(this.this$0).clear();
                DependencySearchService.access$getLocalProviders$p(this.this$0).clear();
                if (DependencySearchService.access$getMyProject$p(this.this$0).isDisposed()) {
                    return;
                }
                for (DependencySearchProvidersFactory f : DependencySearchProvidersFactory.EXTENSION_POINT_NAME.getExtensionList()) {
                    if (!f.isApplicable(DependencySearchService.access$getMyProject$p(this.this$0))) continue;
                    for (DependencySearchProvider provider : f.getProviders(DependencySearchService.access$getMyProject$p(this.this$0))) {
                        if (provider.isLocal()) {
                            DependencySearchService.access$getLocalProviders$p(this.this$0).add(provider);
                            continue;
                        }
                        DependencySearchService.access$getRemoteProviders$p(this.this$0).add(provider);
                    }
                }
            }
            {
                this.this$0 = dependencySearchService;
            }
        }).executeSynchronously();
    }

    private final Promise<Integer> performSearch(String cacheKey, SearchParameters parameters, Function1<? super RepositoryArtifactData, Unit> consumer, Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit> searchMethod) {
        Promise<Integer> cachedValue;
        if (parameters.useCache() && (cachedValue = this.foundInCache(cacheKey, parameters, consumer)) != null) {
            return cachedValue;
        }
        Set localResultSet = new LinkedHashSet();
        Iterable $this$forEach$iv = this.localProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencySearchProvider lp = (DependencySearchProvider)element$iv;
            boolean bl = false;
            searchMethod.invoke((Object)lp, (Object)new Function1<RepositoryArtifactData, Unit>(searchMethod, localResultSet){
                final /* synthetic */ Function2 $searchMethod$inlined;
                final /* synthetic */ Set $localResultSet$inlined;
                {
                    this.$searchMethod$inlined = function2;
                    this.$localResultSet$inlined = set;
                    super(1);
                }

                public final void invoke(@NotNull RepositoryArtifactData it) {
                    this.$localResultSet$inlined.add(it);
                }
            });
        }
        $this$forEach$iv = localResultSet;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            consumer.invoke(element$iv);
        }
        if (parameters.isLocalOnly() || this.remoteProviders.size() == 0) {
            return Promises.resolvedPromise((Object)0);
        }
        List promises = new ArrayList(this.remoteProviders.size());
        Set resultSet = Collections.synchronizedSet(localResultSet);
        for (DependencySearchProvider provider : this.remoteProviders) {
            AsyncPromise promise = new AsyncPromise();
            promises.add(promise);
            ProgressWrapper wrapper = ProgressWrapper.wrap((ProgressIndicator)ProgressIndicatorProvider.getInstance().getProgressIndicator());
            this.myExecutorService.submit(new Runnable(searchMethod, provider, resultSet, consumer, promise, wrapper){
                final /* synthetic */ Function2 $searchMethod;
                final /* synthetic */ DependencySearchProvider $provider;
                final /* synthetic */ Set $resultSet;
                final /* synthetic */ Function1 $consumer;
                final /* synthetic */ AsyncPromise $promise;
                final /* synthetic */ ProgressWrapper $wrapper;

                public final void run() {
                    try {
                        ProgressManager.getInstance().runProcess(new Runnable(this){
                            final /* synthetic */ performSearch.2 this$0;

                            public final void run() {
                                this.this$0.$searchMethod.invoke((Object)this.this$0.$provider, (Object)new Function1<RepositoryArtifactData, Unit>(this){
                                    final /* synthetic */ performSearch.1 this$0;

                                    public final void invoke(@NotNull RepositoryArtifactData it) {
                                        if (this.this$0.this$0.$resultSet.add(it)) {
                                            this.this$0.this$0.$consumer.invoke((Object)it);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                                this.this$0.$promise.setResult(null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, (ProgressIndicator)this.$wrapper);
                    }
                    catch (Exception e) {
                        this.$promise.setError((Throwable)e);
                    }
                }
                {
                    this.$searchMethod = function2;
                    this.$provider = dependencySearchProvider;
                    this.$resultSet = set;
                    this.$consumer = function1;
                    this.$promise = asyncPromise;
                    this.$wrapper = progressWrapper;
                }
            });
        }
        return Promises.all((Collection)promises, resultSet, (boolean)true).then((Function)new Function<Set<RepositoryArtifactData>, Integer>(this, resultSet, cacheKey){
            final /* synthetic */ DependencySearchService this$0;
            final /* synthetic */ Set $resultSet;
            final /* synthetic */ String $cacheKey;

            public final Integer fun(Set<RepositoryArtifactData> it) {
                if (!this.$resultSet.isEmpty()) {
                    DependencySearchService.access$getCache$p(this.this$0).put(this.$cacheKey, CompletableFuture.completedFuture(this.$resultSet));
                }
                return 1;
            }
            {
                this.this$0 = dependencySearchService;
                this.$resultSet = set;
                this.$cacheKey = string;
            }
        });
    }

    @NotNull
    public final Promise<Integer> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        return this.suggestPrefix(groupId, artifactId, parameters, (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(consumer){
            final /* synthetic */ Consumer $consumer;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                this.$consumer.accept(it);
            }
            {
                this.$consumer = consumer;
                super(1);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Function1<? super RepositoryArtifactData, Unit> consumer) {
        String cacheKey = '_' + groupId + ':' + artifactId;
        return this.performSearch(cacheKey, parameters, consumer, (Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit>)((Function2)new Function2<DependencySearchProvider, Function1<? super RepositoryArtifactData, ? extends Unit>, Unit>(groupId, artifactId){
            final /* synthetic */ String $groupId;
            final /* synthetic */ String $artifactId;

            public final void invoke(@NotNull DependencySearchProvider p, @NotNull Function1<? super RepositoryArtifactData, Unit> c) {
                Object object = c;
                if (object != null) {
                    Function1<? super RepositoryArtifactData, Unit> function1 = object;
                    object = new DependencySearchServiceKt$sam$java_util_function_Consumer$0(function1);
                }
                p.suggestPrefix(this.$groupId, this.$artifactId, (Consumer)object);
            }
            {
                this.$groupId = string;
                this.$artifactId = string2;
                super(2);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> fulltextSearch(@NotNull String searchString, @NotNull SearchParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        return this.fulltextSearch(searchString, parameters, (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(consumer){
            final /* synthetic */ Consumer $consumer;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                this.$consumer.accept(it);
            }
            {
                this.$consumer = consumer;
                super(1);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> fulltextSearch(@NotNull String searchString, @NotNull SearchParameters parameters, @NotNull Function1<? super RepositoryArtifactData, Unit> consumer) {
        return this.performSearch(searchString, parameters, consumer, (Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit>)((Function2)new Function2<DependencySearchProvider, Function1<? super RepositoryArtifactData, ? extends Unit>, Unit>(searchString){
            final /* synthetic */ String $searchString;

            public final void invoke(@NotNull DependencySearchProvider p, @NotNull Function1<? super RepositoryArtifactData, Unit> c) {
                Object object = c;
                if (object != null) {
                    Function1<? super RepositoryArtifactData, Unit> function1 = object;
                    object = new DependencySearchServiceKt$sam$java_util_function_Consumer$0(function1);
                }
                p.fulltextSearch(this.$searchString, (Consumer)object);
            }
            {
                this.$searchString = string;
                super(2);
            }
        }));
    }

    private final Promise<Integer> foundInCache(String searchString, SearchParameters parameters, Function1<? super RepositoryArtifactData, Unit> consumer) {
        CompletableFuture<Collection<RepositoryArtifactData>> future = this.cache.get(searchString);
        if (future != null) {
            AsyncPromise p = new AsyncPromise();
            future.whenComplete(new BiConsumer<Collection<? extends RepositoryArtifactData>, Throwable>(p, consumer){
                final /* synthetic */ AsyncPromise $p;
                final /* synthetic */ Function1 $consumer;

                /*
                 * WARNING - void declaration
                 */
                public final void accept(@NotNull Collection<? extends RepositoryArtifactData> r, @Nullable Throwable e) {
                    if (e != null) {
                        this.$p.setError(e);
                    } else {
                        void $this$forEach$iv;
                        Iterable iterable = r;
                        Function1 action$iv = this.$consumer;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            action$iv.invoke(element$iv);
                        }
                        this.$p.setResult(null);
                    }
                }
                {
                    this.$p = asyncPromise;
                    this.$consumer = function1;
                }
            });
            return (Promise)p;
        }
        return null;
    }

    public final void setProviders(@NotNull List<? extends DependencySearchProvider> local, @NotNull List<? extends DependencySearchProvider> remote) {
        this.remoteProviders.clear();
        this.localProviders.clear();
        this.remoteProviders.addAll((Collection<DependencySearchProvider>)remote);
        this.localProviders.addAll((Collection<DependencySearchProvider>)local);
    }

    public DependencySearchService(@NotNull Project myProject) {
        this.myProject = myProject;
        this.cache = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        this.remoteProviders = new ArrayList();
        this.localProviders = new ArrayList();
        DependencySearchProvidersFactory.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DependencySearchProvidersFactory>(){

            public void extensionAdded(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                this.updateProviders();
            }

            public void extensionRemoved(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                this.updateProviders();
            }
        }, (Disposable)this.myProject);
        this.myExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"DependencySearch", (int)2);
        DependencySearchProvidersFactory.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DependencySearchProvidersFactory>(){

            public void extensionAdded(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                this.updateProviders();
            }

            public void extensionRemoved(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                this.updateProviders();
            }
        }, (Disposable)this.myProject);
        this.updateProviders();
    }

    public static final /* synthetic */ List access$getRemoteProviders$p(DependencySearchService $this) {
        return $this.remoteProviders;
    }

    public static final /* synthetic */ List access$getLocalProviders$p(DependencySearchService $this) {
        return $this.localProviders;
    }

    public static final /* synthetic */ Project access$getMyProject$p(DependencySearchService $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ Map access$getCache$p(DependencySearchService $this) {
        return $this.cache;
    }

    @JvmStatic
    @NotNull
    public static final DependencySearchService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/reposearch/DependencySearchService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.repository.search"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DependencySearchService getInstance(@NotNull Project project) {
            return (DependencySearchService)project.getService(DependencySearchService.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

