/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.kpmsearch;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.kpmsearch.MyErrorHandler;
import org.jetbrains.idea.kpmsearch.PackageSearchResultModel;
import org.jetbrains.idea.kpmsearch.PackageServiceConfig;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

public class PackageSearchService
implements DependencySearchProvider {
    private static final MyErrorHandler<Throwable> myErrorHandler = new MyErrorHandler();
    private final Gson myGson = new Gson();
    private final PackageServiceConfig myPackageServiceConfig = new PackageServiceConfig();

    @Override
    public void fulltextSearch(@NotNull String searchString, @NotNull Consumer<RepositoryArtifactData> consumer) {
        searchString = this.normalize(searchString);
        ProgressManager.checkCanceled();
        String url = this.createUrlFullTextSearch(searchString);
        this.doRequest(consumer, url);
    }

    private String normalize(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean isOK = true;
        for (char c : string.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':' || c == '-') {
                builder.append(c);
                continue;
            }
            isOK = false;
        }
        return isOK ? string : builder.toString();
    }

    @Override
    public void suggestPrefix(@Nullable String groupId, @Nullable String artifactId, @NotNull Consumer<RepositoryArtifactData> consumer) {
        artifactId = this.normalize(artifactId);
        groupId = this.normalize(groupId);
        ProgressManager.checkCanceled();
        String url = this.createUrlSuggestPrefix(groupId, artifactId);
        this.doRequest(consumer, url);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    private void doRequest(@NotNull Consumer<RepositoryArtifactData> consumer, String url) {
        if (url == null) {
            return;
        }
        try {
            HttpRequests.request((String)url).userAgent(this.myPackageServiceConfig.getUserAgent()).forceHttps(true).connectTimeout((int)PackageServiceConfig.MAX_TIMEOUT).readTimeout((int)PackageServiceConfig.MAX_TIMEOUT).connect(request -> this.process(consumer, request));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object process(@NotNull Consumer<RepositoryArtifactData> consumer, HttpRequests.Request request) {
        try {
            JsonReader reader = this.myGson.newJsonReader((Reader)request.getReader());
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("items".equals(name)) {
                    this.readVariants(reader, consumer);
                    continue;
                }
                reader.nextString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String createUrlFullTextSearch(@NotNull String coord) {
        String url = this.myPackageServiceConfig.getFullTextUrl();
        if (url == null) {
            return null;
        }
        return url + "?query=" + PackageSearchService.encode(coord.trim());
    }

    private String createUrlSuggestPrefix(@Nullable String groupId, @Nullable String artifactId) {
        String url = this.myPackageServiceConfig.getSuggestUrl();
        if (url == null) {
            return null;
        }
        String groupParam = StringUtil.isEmpty((String)groupId) ? "" : "groupId=" + PackageSearchService.encode(groupId.trim());
        String artifactParam = StringUtil.isEmpty((String)artifactId) ? "" : "artifactId=" + PackageSearchService.encode(artifactId.trim());
        return url + "?" + groupParam + "&" + artifactParam;
    }

    private void readVariants(JsonReader reader, Consumer<RepositoryArtifactData> consumer) throws IOException {
        reader.beginArray();
        int results = 0;
        while (reader.hasNext() && results++ < 20) {
            PackageSearchResultModel resultModel = (PackageSearchResultModel)this.myGson.fromJson(reader, PackageSearchResultModel.class);
            ProgressManager.checkCanceled();
            if (resultModel.versions == null || resultModel.versions.length < 1 || StringUtil.isEmpty((String)resultModel.groupId) || StringUtil.isEmpty((String)resultModel.artifactId)) continue;
            HashSet<String> versions = new HashSet<String>();
            ArrayList<MavenDependencyCompletionItem> itemList = new ArrayList<MavenDependencyCompletionItem>();
            for (int i = 0; i < resultModel.versions.length; ++i) {
                if (!versions.add(resultModel.versions[i])) continue;
                itemList.add(new MavenDependencyCompletionItem(resultModel.groupId, resultModel.artifactId, resultModel.versions[i], MavenDependencyCompletionItem.Type.REMOTE));
            }
            MavenDependencyCompletionItem[] items = itemList.toArray(new MavenDependencyCompletionItem[0]);
            consumer.accept(new MavenRepositoryArtifactInfo(items[0].getGroupId(), items[0].getArtifactId(), items));
        }
    }

    @NotNull
    private static String encode(@NotNull String s) {
        try {
            return URLEncoder.encode(s.trim(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

