/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitConvertTool
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"TestNG QuickFix");
    private static final String DISPLAY_NAME = "JUnit Test can be converted to TestNG";
    private static final Map<String, String> ANNOTATIONS_MAP = new HashMap<String, String>();
    public static final String QUICKFIX_NAME = "Convert TestCase to TestNG";

    @NotNull
    public String getGroupDisplayName() {
        return "TestNG";
    }

    @NotNull
    public String getShortName() {
        return "JUnitTestNG";
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (TestNGUtil.inheritsJUnitTestCase(psiClass) || TestNGUtil.containsJunitAnnotations(psiClass)) {
            PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
            ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)(nameIdentifier != null ? nameIdentifier : psiClass), TestngBundle.message("test.case.can.be.converted.to.testng", new Object[0]), (LocalQuickFix)new JUnitConverterQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    static {
        ANNOTATIONS_MAP.put("org.junit.Test", "@org.testng.annotations.Test");
        ANNOTATIONS_MAP.put("org.junit.BeforeClass", "@org.testng.annotations.BeforeClass");
        ANNOTATIONS_MAP.put("org.junit.Before", "@org.testng.annotations.BeforeMethod");
        ANNOTATIONS_MAP.put("org.junit.AfterClass", "@org.testng.annotations.AfterClass");
        ANNOTATIONS_MAP.put("org.junit.After", "@org.testng.annotations.AfterMethod");
    }

    public static class JUnitConverterQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return JUnitConvertTool.QUICKFIX_NAME;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            if (psiClass == null || !TestNGUtil.checkTestNGInClasspath((PsiElement)psiClass)) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{psiClass})) {
                return;
            }
            WriteAction.run(() -> JUnitConverterQuickFix.doFix(project, psiClass));
        }

        private static void doFix(@NotNull Project project, PsiClass psiClass) {
            try {
                PsiManager manager = PsiManager.getInstance((Project)project);
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                PsiJavaFile javaFile = (PsiJavaFile)psiClass.getContainingFile();
                for (PsiMethod method : psiClass.getMethods()) {
                    PsiMethodCallExpression[] methodCalls = JUnitConverterQuickFix.getTestCaseCalls(method);
                    if (method.isConstructor()) {
                        JUnitConverterQuickFix.convertJUnitConstructor(method);
                    } else if (!javaFile.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
                        JUnitConverterQuickFix.addMethodJavadoc(factory, method);
                    } else if (TestNGUtil.containsJunitAnnotations(method)) {
                        JUnitConverterQuickFix.convertJunitAnnotations(factory, method);
                    } else {
                        JUnitConverterQuickFix.addMethodAnnotations(factory, method);
                    }
                    for (PsiMethodCallExpression methodCall : methodCalls) {
                        String replaceTemplate;
                        String searchTemplate;
                        String qualifierTemplate;
                        PsiMethod assertMethod = methodCall.resolveMethod();
                        if (assertMethod == null) continue;
                        String methodName = assertMethod.getName();
                        PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
                        PsiStatement methodCallStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiStatement.class);
                        LOG.assertTrue(methodCallStatement != null);
                        String string = qualifierTemplate = methodCall.getMethodExpression().getQualifierExpression() != null ? "$qualifier$." : "";
                        if ("assertNull".equals(methodName) || "assertNotNull".equals(methodName) || "assertTrue".equals(methodName) || "assertFalse".equals(methodName)) {
                            boolean hasMessage = expressions.length == 2;
                            searchTemplate = qualifierTemplate + "$method$($object$ " + (hasMessage ? ",$msg$" : "") + ")";
                            replaceTemplate = "org.testng.Assert.$method$(" + (hasMessage ? "$msg$," : "") + "$object$)";
                        } else if ("fail".equals(methodName)) {
                            boolean hasMessage = expressions.length == 1;
                            searchTemplate = qualifierTemplate + "$method$(" + (hasMessage ? "$msg$" : "") + ")";
                            replaceTemplate = "org.testng.Assert.$method$(" + (hasMessage ? "$msg$" : "") + ")";
                        } else if ("assertThat".equals(methodName)) {
                            String paramTemplate = (expressions.length == 3 ? "$msg$," : "") + "$actual$, $matcher$";
                            searchTemplate = qualifierTemplate + "assertThat(" + paramTemplate + ")";
                            replaceTemplate = "org.hamcrest.MatcherAssert.assertThat(" + paramTemplate + ")";
                        } else {
                            boolean hasMessage = JUnitConverterQuickFix.hasMessage(methodCall);
                            if (hasMessage && expressions.length == 4 || !hasMessage && expressions.length == 3) {
                                searchTemplate = qualifierTemplate + "$method$";
                                replaceTemplate = "org.testng.AssertJUnit.$method$";
                            } else {
                                String replaceMethodWildCard = "$method$";
                                if (methodName.equals("assertArrayEquals")) {
                                    replaceMethodWildCard = "assertEquals";
                                }
                                searchTemplate = qualifierTemplate + "$method$(" + (hasMessage ? "$msg$, " : "") + "$expected$, $actual$)";
                                replaceTemplate = "org.testng.Assert." + replaceMethodWildCard + "($actual$, $expected$ " + (hasMessage ? ", $msg$" : "") + ")";
                            }
                        }
                        TypeConversionDescriptor.replaceExpression((PsiExpression)methodCall, (String)searchTemplate, (String)replaceTemplate);
                    }
                }
                PsiClass superClass = psiClass.getSuperClass();
                if (superClass != null && "junit.framework.TestCase".equals(superClass.getQualifiedName())) {
                    PsiReferenceList extendsList = psiClass.getExtendsList();
                    LOG.assertTrue(extendsList != null);
                    for (PsiJavaCodeReferenceElement element : extendsList.getReferenceElements()) {
                        element.delete();
                    }
                }
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                codeStyleManager.optimizeImports((PsiFile)javaFile);
                codeStyleManager.shortenClassReferences((PsiElement)javaFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error("Error converting testcase", (Throwable)e);
            }
        }

        private static boolean hasMessage(PsiMethodCallExpression expression) {
            PsiExpression[] expressions = expression.getArgumentList().getExpressions();
            if (expressions.length == 4) {
                return true;
            }
            PsiMethod method = expression.resolveMethod();
            LOG.assertTrue(method != null);
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                PsiClass resolvedClass;
                PsiType type = parameter.getType();
                if (!(type instanceof PsiClassType) || (resolvedClass = ((PsiClassType)type).resolve()) == null || !"java.lang.String".equals(resolvedClass.getQualifiedName())) continue;
                return true;
            }
            return false;
        }

        private static List<PsiElement> convertJunitAnnotations(PsiElementFactory factory, PsiMethod method) throws IncorrectOperationException {
            Object[] annotations = method.getModifierList().getAnnotations();
            return ContainerUtil.mapNotNull((Object[])annotations, annotation -> {
                String testNgAnnotation = (String)ANNOTATIONS_MAP.get(annotation.getQualifiedName());
                if (testNgAnnotation != null) {
                    PsiAnnotation newAnnotation = factory.createAnnotationFromText("@org.testng.annotations.Test", (PsiElement)method);
                    return annotation.replace((PsiElement)newAnnotation);
                }
                return null;
            });
        }

        private static void convertJUnitConstructor(PsiMethod method) {
            method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitExpressionStatement(PsiExpressionStatement statement) {
                    PsiMethod resolved;
                    PsiMethodCallExpression methodCall;
                    PsiExpression expression = statement.getExpression();
                    if (expression instanceof PsiMethodCallExpression && (methodCall = (PsiMethodCallExpression)expression).getArgumentList().getExpressionCount() == 1 && (resolved = methodCall.resolveMethod()) != null && "junit.framework.TestCase".equals(resolved.getContainingClass().getQualifiedName()) && "TestCase".equals(resolved.getName())) {
                        try {
                            statement.delete();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            });
        }

        private static PsiMethodCallExpression[] getTestCaseCalls(PsiMethod method) {
            return (PsiMethodCallExpression[])SyntaxTraverser.psiTraverser((PsiElement)method).filter(PsiMethodCallExpression.class).filter(methodCall -> {
                PsiClass containingClass;
                PsiMethod method1 = methodCall.resolveMethod();
                if (method1 != null && (containingClass = method1.getContainingClass()) != null) {
                    String qualifiedName = containingClass.getQualifiedName();
                    return "junit.framework.Assert".equals(qualifiedName) || "org.junit.Assert".equals(qualifiedName) || "junit.framework.TestCase".equals(qualifiedName);
                }
                return false;
            }).toArray((Object[])new PsiMethodCallExpression[0]);
        }

        private static void addMethodJavadoc(PsiElementFactory factory, PsiMethod method) throws IncorrectOperationException {
            if (method.getName().startsWith("test")) {
                JUnitConverterQuickFix.addMethodJavadocLine(factory, method, " * @testng.test");
            } else if ("setUp".equals(method.getName()) && method.getParameterList().isEmpty()) {
                JUnitConverterQuickFix.addMethodJavadocLine(factory, method, " * @testng.before-test");
            } else if ("tearDown".equals(method.getName()) && method.getParameterList().isEmpty()) {
                JUnitConverterQuickFix.addMethodJavadocLine(factory, method, " * @testng.after-test");
            }
        }

        private static void addMethodJavadocLine(PsiElementFactory factory, PsiMethod method, @NonNls String javaDocLine) throws IncorrectOperationException {
            PsiElement comment = method.getFirstChild();
            if (comment instanceof PsiComment) {
                String[] commentLines = comment.getText().split("\n");
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < commentLines.length; ++i) {
                    String commentLine = commentLines[i];
                    if (i == commentLines.length - 1) {
                        buf.append(javaDocLine);
                        buf.append(commentLine);
                        continue;
                    }
                    buf.append(commentLine);
                    buf.append('\n');
                }
                String commentString = buf.toString();
                PsiComment newComment = factory.createCommentFromText(commentString, null);
                comment.replace((PsiElement)newComment);
            } else {
                PsiComment newComment = factory.createCommentFromText("/**\n" + javaDocLine + "\n */", null);
                method.addBefore((PsiElement)newComment, comment);
            }
        }

        private static PsiElement addMethodAnnotations(PsiElementFactory factory, PsiMethod method) throws IncorrectOperationException {
            PsiAnnotation annotation = null;
            if (method.getName().startsWith("test")) {
                annotation = factory.createAnnotationFromText("@org.testng.annotations.Test", (PsiElement)method);
            } else if ("setUp".equals(method.getName()) && method.getParameterList().isEmpty()) {
                annotation = factory.createAnnotationFromText("@org.testng.annotations.BeforeMethod", (PsiElement)method);
            } else if ("tearDown".equals(method.getName()) && method.getParameterList().isEmpty()) {
                annotation = factory.createAnnotationFromText("@org.testng.annotations.AfterMethod", (PsiElement)method);
            }
            if (annotation != null) {
                return method.getModifierList().addAfter((PsiElement)annotation, null);
            }
            return null;
        }
    }
}

