/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.TextMateFileType;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;

public class TextMateTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (fileType == TextMateFileType.INSTANCE) {
            if (c == '\'' || c == '\"' || c == '`' ? !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE : !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            int offset = editor.getCaretModel().getOffset();
            CharSequence scopeSelector = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor);
            Document document = editor.getDocument();
            TextMateBracePair pairForRightChar = TextMateEditorUtils.getSmartTypingPairForRightChar(c, scopeSelector);
            if (pairForRightChar != null && c == pairForRightChar.rightChar && offset < document.getTextLength() && document.getCharsSequence().charAt(offset) == c) {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                return TypedHandlerDelegate.Result.STOP;
            }
            TextMateBracePair pairForLeftChar = TextMateEditorUtils.getSmartTypingPairForLeftChar(c, scopeSelector);
            if (pairForLeftChar != null) {
                CharSequence chars = document.getCharsSequence();
                if (pairForLeftChar.leftChar == pairForLeftChar.rightChar) {
                    char nextChar;
                    char prevChar = offset > 0 ? (char)document.getCharsSequence().charAt(offset - 1) : (char)' ';
                    char c2 = nextChar = offset < document.getTextLength() ? (char)document.getCharsSequence().charAt(offset) : (char)' ';
                    if (!Character.isLetterOrDigit(prevChar) && prevChar != pairForLeftChar.leftChar && !Character.isLetterOrDigit(nextChar) && nextChar != pairForLeftChar.rightChar) {
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.repeatSymbol((char)pairForLeftChar.leftChar, (int)2), (boolean)true, (int)1);
                        return TypedHandlerDelegate.Result.STOP;
                    }
                } else {
                    if (TextMateTypedHandler.alreadyHasEnding(chars, c, pairForLeftChar.rightChar, offset)) {
                        return TypedHandlerDelegate.Result.CONTINUE;
                    }
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(new char[]{pairForLeftChar.leftChar, pairForLeftChar.rightChar}), (boolean)true, (int)1);
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean alreadyHasEnding(@NotNull CharSequence chars, char startChar, char endChar, int offset) {
        int i;
        for (i = offset; i < chars.length() && chars.charAt(i) != startChar && chars.charAt(i) != endChar && chars.charAt(i) != '\n'; ++i) {
        }
        return i < chars.length() && chars.charAt(i) == endChar;
    }
}

